# This an autogenerated file
# Description for long term statistical metocean data.
# Generated with LongTermStats
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.longtermstats import LongTermStatsBlueprint
from typing import Dict
from .period import Period
from dmt.namedentity import NamedEntity

class LongTermStats(NamedEntity):
    """
    Description for long term statistical metocean data.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         name for the metocean data.(default None)
    periods : List[Period]
         statistical model for different time periods.
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.periods = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return LongTermStatsBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """name for the metocean data."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def periods(self) -> List[Period]:
        """statistical model for different time periods."""
        return self.__periods

    @periods.setter
    def periods(self, value: List[Period]):
        """Set periods"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__periods = value
