# This an autogenerated file
# Description for wave at a sector.
# Generated with Sector
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.sector import SectorBlueprint
from typing import Dict
from .contour import Contour
from .jointextremevalues import JointExtremeValues
from .spectralpeak import SpectralPeak
from .weibull import Weibull
from dmt.namedentity import NamedEntity

class Sector(NamedEntity):
    """
    Description for wave at a sector.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         unique name for the sector, e.g. sec120, or omni.(default None)
    direction : float
         mean sector direction.(default 0.0)
    sectorSize : float
         sector size.(default 0.0)
    probability : float
         probability of this combination(default 0.0)
    weibullDistribution : Weibull
         weibull parameters for Hs.
    extremeValues : JointExtremeValues
         joined extreme values for Hs and Tp.
    spectralPeak : SpectralPeak
         Spectral peak period as a function of Hs.
    contours : List[Contour]
         Hs-Tp contours
    """

    def __init__(self , description="", direction=0.0, sectorSize=0.0, probability=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.direction = direction
        self.sectorSize = sectorSize
        self.probability = probability
        self.weibullDistribution = None
        self.extremeValues = None
        self.spectralPeak = None
        self.contours = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SectorBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """unique name for the sector, e.g. sec120, or omni."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def direction(self) -> float:
        """mean sector direction."""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def sectorSize(self) -> float:
        """sector size."""
        return self.__sectorSize

    @sectorSize.setter
    def sectorSize(self, value: float):
        """Set sectorSize"""
        self.__sectorSize = float(value)

    @property
    def probability(self) -> float:
        """probability of this combination"""
        return self.__probability

    @probability.setter
    def probability(self, value: float):
        """Set probability"""
        self.__probability = float(value)

    @property
    def weibullDistribution(self) -> Weibull:
        """weibull parameters for Hs."""
        return self.__weibullDistribution

    @weibullDistribution.setter
    def weibullDistribution(self, value: Weibull):
        """Set weibullDistribution"""
        self.__weibullDistribution = value

    @property
    def extremeValues(self) -> JointExtremeValues:
        """joined extreme values for Hs and Tp."""
        return self.__extremeValues

    @extremeValues.setter
    def extremeValues(self, value: JointExtremeValues):
        """Set extremeValues"""
        self.__extremeValues = value

    @property
    def spectralPeak(self) -> SpectralPeak:
        """Spectral peak period as a function of Hs."""
        return self.__spectralPeak

    @spectralPeak.setter
    def spectralPeak(self, value: SpectralPeak):
        """Set spectralPeak"""
        self.__spectralPeak = value

    @property
    def contours(self) -> List[Contour]:
        """Hs-Tp contours"""
        return self.__contours

    @contours.setter
    def contours(self, value: List[Contour]):
        """Set contours"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__contours = value
