# This an autogenerated file
# Description for stochastic wave.
# Generated with Stat
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.stat import StatBlueprint
from typing import Dict
from .sector import Sector
from dmt.namedentity import NamedEntity

class Stat(NamedEntity):
    """
    Description for stochastic wave.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         name for this statistical data which appear in SIMA, e.g. wave12sec, or waveomni.(default None)
    duration : float
         sampling rate in hours.(default 0.0)
    sectors : List[Sector]
         sectoral wave at this sampling rate for Hs.
    omni : Sector
         omni wave at this sampling rate for Hs.
    """

    def __init__(self , description="", duration=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.duration = duration
        self.sectors = list()
        self.omni = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StatBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """name for this statistical data which appear in SIMA, e.g. wave12sec, or waveomni."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def duration(self) -> float:
        """sampling rate in hours."""
        return self.__duration

    @duration.setter
    def duration(self, value: float):
        """Set duration"""
        self.__duration = float(value)

    @property
    def sectors(self) -> List[Sector]:
        """sectoral wave at this sampling rate for Hs."""
        return self.__sectors

    @sectors.setter
    def sectors(self, value: List[Sector]):
        """Set sectors"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__sectors = value

    @property
    def omni(self) -> Sector:
        """omni wave at this sampling rate for Hs."""
        return self.__omni

    @omni.setter
    def omni(self, value: Sector):
        """Set omni"""
        self.__omni = value
