# This an autogenerated file
# Description for stochastic process at a sector.
# Generated with Wave
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.wave import WaveBlueprint
from numpy import ndarray,asarray
from dmt.entity import Entity

class Wave(Entity):
    """
    Description for stochastic process at a sector.
    Keyword arguments
    -----------------
    description : str
         (default "")
    occurrence : ndarray
         the scatter data for occurrence of Hs-Tp.
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.occurrence = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WaveBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def occurrence(self) -> ndarray:
        """the scatter data for occurrence of Hs-Tp."""
        return self.__occurrence

    @occurrence.setter
    def occurrence(self, value: ndarray):
        """Set occurrence"""
        array = asarray(value, dtype=int)
        if len(array) > 0 and array.ndim != 2:
            raise ValueError("Expected array with 2 dimensions")
        self.__occurrence = array
