# This an autogenerated file
# 
# Generated with ExportCommand
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.exportcommand import ExportCommandBlueprint
from numpy import ndarray,asarray
from ..sima import Property
from ..sima import ScriptableValue
from .command import Command

class ExportCommand(Command):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    parameters : List[Property]
         Additional parameters
    file : str
         Path to file, e.g stask(default None)
    delete : bool
         Delete the file if it already exist(default False)
    dependencies : bool
         Include task dependencies automatically(default True)
    tasks : ndarray of str
         Optional list of task names to export (if not given all tasks will be exported)
    """

    def __init__(self , description="", delete=False, dependencies=True, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.parameters = list()
        self.file = None
        self.delete = delete
        self.dependencies = dependencies
        self.tasks = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ExportCommandBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def parameters(self) -> List[Property]:
        """Additional parameters"""
        return self.__parameters

    @parameters.setter
    def parameters(self, value: List[Property]):
        """Set parameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__parameters = value

    @property
    def file(self) -> str:
        """Path to file, e.g stask"""
        return self.__file

    @file.setter
    def file(self, value: str):
        """Set file"""
        self.__file = value

    @property
    def delete(self) -> bool:
        """Delete the file if it already exist"""
        return self.__delete

    @delete.setter
    def delete(self, value: bool):
        """Set delete"""
        self.__delete = bool(value)

    @property
    def dependencies(self) -> bool:
        """Include task dependencies automatically"""
        return self.__dependencies

    @dependencies.setter
    def dependencies(self, value: bool):
        """Set dependencies"""
        self.__dependencies = bool(value)

    @property
    def tasks(self) -> ndarray:
        """Optional list of task names to export (if not given all tasks will be exported)"""
        return self.__tasks

    @tasks.setter
    def tasks(self, value: ndarray):
        """Set tasks"""
        array = asarray(value, dtype=str)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__tasks = array
