# This an autogenerated file
# 
# Generated with ExternalCommand
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.externalcommand import ExternalCommandBlueprint
from typing import Dict
from ..sima import Property
from ..sima import ScriptableValue
from .command import Command

class ExternalCommand(Command):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    parameters : List[Property]
         Additional parameters
    file : str
         file path to command file (*.txt or *.json)(default None)
    ignore : bool
         Continute command despite any intermediate failure(default False)
    """

    def __init__(self , description="", ignore=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.parameters = list()
        self.file = None
        self.ignore = ignore
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ExternalCommandBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def parameters(self) -> List[Property]:
        """Additional parameters"""
        return self.__parameters

    @parameters.setter
    def parameters(self, value: List[Property]):
        """Set parameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__parameters = value

    @property
    def file(self) -> str:
        """file path to command file (*.txt or *.json)"""
        return self.__file

    @file.setter
    def file(self, value: str):
        """Set file"""
        self.__file = value

    @property
    def ignore(self) -> bool:
        """Continute command despite any intermediate failure"""
        return self.__ignore

    @ignore.setter
    def ignore(self, value: bool):
        """Set ignore"""
        self.__ignore = bool(value)
