# This an autogenerated file
# 
# Generated with StorageTaskRootCommand
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.storagetaskrootcommand import StorageTaskRootCommandBlueprint
from typing import Dict
from ..sima import Property
from ..sima import ScriptableValue
from .command import Command

class StorageTaskRootCommand(Command):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    parameters : List[Property]
         Additional parameters
    task : str
         Name of storage task(default None)
    root : str
         Storage task root(default None)
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.parameters = list()
        self.task = None
        self.root = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StorageTaskRootCommandBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def parameters(self) -> List[Property]:
        """Additional parameters"""
        return self.__parameters

    @parameters.setter
    def parameters(self, value: List[Property]):
        """Set parameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__parameters = value

    @property
    def task(self) -> str:
        """Name of storage task"""
        return self.__task

    @task.setter
    def task(self, value: str):
        """Set task"""
        self.__task = value

    @property
    def root(self) -> str:
        """Storage task root"""
        return self.__root

    @root.setter
    def root(self, value: str):
        """Set root"""
        self.__root = value
