# This an autogenerated file
# 
# Generated with WorkflowRunCommand
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.workflowruncommand import WorkflowRunCommandBlueprint
from typing import Dict
from ..sima import Property
from ..sima import ScriptableValue
from .command import Command

class WorkflowRunCommand(Command):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    parameters : List[Property]
         Additional parameters
    file : str
         Optional path to SIMA stask to import before running the workflow(default None)
    task : str
         Name of task containing workflow(default None)
    workflow : str
         Workflow name(default None)
    input : List[Property]
         Enables override of task variables or workflow input values.\nSpecified on the form Hs=2.0;Tp=12.0 where Hs and Tp are names of variables or workflow inputs.\nVariables will take precendence if duplicate names exist.\nIt is also possible to specify more complex input by using the json string representation of SIMA signals.
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.parameters = list()
        self.file = None
        self.task = None
        self.workflow = None
        self.input = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WorkflowRunCommandBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def parameters(self) -> List[Property]:
        """Additional parameters"""
        return self.__parameters

    @parameters.setter
    def parameters(self, value: List[Property]):
        """Set parameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__parameters = value

    @property
    def file(self) -> str:
        """Optional path to SIMA stask to import before running the workflow"""
        return self.__file

    @file.setter
    def file(self, value: str):
        """Set file"""
        self.__file = value

    @property
    def task(self) -> str:
        """Name of task containing workflow"""
        return self.__task

    @task.setter
    def task(self, value: str):
        """Set task"""
        self.__task = value

    @property
    def workflow(self) -> str:
        """Workflow name"""
        return self.__workflow

    @workflow.setter
    def workflow(self, value: str):
        """Set workflow"""
        self.__workflow = value

    @property
    def input(self) -> List[Property]:
        """Enables override of task variables or workflow input values.
Specified on the form Hs=2.0;Tp=12.0 where Hs and Tp are names of variables or workflow inputs.
Variables will take precendence if duplicate names exist.
It is also possible to specify more complex input by using the json string representation of SIMA signals."""
        return self.__input

    @input.setter
    def input(self, value: List[Property]):
        """Set input"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__input = value
