# This an autogenerated file
# 
# Generated with ESDUWind
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.esduwind import ESDUWindBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .wind import Wind

class ESDUWind(Wind):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    direction : float
         Wind propagation direction(default 0.0)
    averageVelocity : float
         Average velocity at reference height(default 0.0)
    psi : float
         Site latitude in decimal degrees(default 0.0)
    friction : float
         Surface drag coefficient used for transverse gust spectrum(default 0.002)
    """

    def __init__(self , description="", direction=0.0, averageVelocity=0.0, psi=0.0, friction=0.002, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.direction = direction
        self.averageVelocity = averageVelocity
        self.psi = psi
        self.friction = friction
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ESDUWindBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def direction(self) -> float:
        """Wind propagation direction"""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def averageVelocity(self) -> float:
        """Average velocity at reference height"""
        return self.__averageVelocity

    @averageVelocity.setter
    def averageVelocity(self, value: float):
        """Set averageVelocity"""
        self.__averageVelocity = float(value)

    @property
    def psi(self) -> float:
        """Site latitude in decimal degrees"""
        return self.__psi

    @psi.setter
    def psi(self, value: float):
        """Set psi"""
        self.__psi = float(value)

    @property
    def friction(self) -> float:
        """Surface drag coefficient used for transverse gust spectrum"""
        return self.__friction

    @friction.setter
    def friction(self, value: float):
        """Set friction"""
        self.__friction = float(value)
