# This an autogenerated file
# 
# Generated with WindVelocityProfile
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.windvelocityprofile import WindVelocityProfileBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class WindVelocityProfile(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    verticalCoordinate : float
         Vertical coordinate of profile level(default 0.0)
    longitudinalVelocityFactor : float
         Wind speed scaling factor for fluctuating part of the longitudinal wind(default 0.0)
    lateralVelocityFactor : float
         Wind speed scaling factor for the lateral wind velocity(default 0.0)
    verticalVelocityFactor : float
         Wind speed scaling factor for the vertical wind velocity(default 0.0)
    """

    def __init__(self , description="", verticalCoordinate=0.0, longitudinalVelocityFactor=0.0, lateralVelocityFactor=0.0, verticalVelocityFactor=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.verticalCoordinate = verticalCoordinate
        self.longitudinalVelocityFactor = longitudinalVelocityFactor
        self.lateralVelocityFactor = lateralVelocityFactor
        self.verticalVelocityFactor = verticalVelocityFactor
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WindVelocityProfileBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def verticalCoordinate(self) -> float:
        """Vertical coordinate of profile level"""
        return self.__verticalCoordinate

    @verticalCoordinate.setter
    def verticalCoordinate(self, value: float):
        """Set verticalCoordinate"""
        self.__verticalCoordinate = float(value)

    @property
    def longitudinalVelocityFactor(self) -> float:
        """Wind speed scaling factor for fluctuating part of the longitudinal wind"""
        return self.__longitudinalVelocityFactor

    @longitudinalVelocityFactor.setter
    def longitudinalVelocityFactor(self, value: float):
        """Set longitudinalVelocityFactor"""
        self.__longitudinalVelocityFactor = float(value)

    @property
    def lateralVelocityFactor(self) -> float:
        """Wind speed scaling factor for the lateral wind velocity"""
        return self.__lateralVelocityFactor

    @lateralVelocityFactor.setter
    def lateralVelocityFactor(self, value: float):
        """Set lateralVelocityFactor"""
        self.__lateralVelocityFactor = float(value)

    @property
    def verticalVelocityFactor(self) -> float:
        """Wind speed scaling factor for the vertical wind velocity"""
        return self.__verticalVelocityFactor

    @verticalVelocityFactor.setter
    def verticalVelocityFactor(self, value: float):
        """Set verticalVelocityFactor"""
        self.__verticalVelocityFactor = float(value)
