# This an autogenerated file
# 
# Generated with QuadraticCurrentCoefficient
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.quadraticcurrentcoefficient import QuadraticCurrentCoefficientBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .coefficienttype import CoefficientType
from .directionsymmetry import DirectionSymmetry
from .quadraticcurrentcoefficientitem import QuadraticCurrentCoefficientItem

class QuadraticCurrentCoefficient(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    symmetry : DirectionSymmetry
    items : List[QuadraticCurrentCoefficientItem]
    _type : CoefficientType
         Current coefficient type
    fileName : str
         Text file containing the current coefficients. The force coefficents in the file must be specified in [kN/(m/s)] for translational degrees of freedom and [kN.s] for rotational degrees of freedom.(default None)
    """

    def __init__(self , description="", symmetry=DirectionSymmetry.NO_SYMMETRY, _type=CoefficientType.CLASSIC, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.symmetry = symmetry
        self.items = list()
        self._type = _type
        self.fileName = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return QuadraticCurrentCoefficientBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def items(self) -> List[QuadraticCurrentCoefficientItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[QuadraticCurrentCoefficientItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def _type(self) -> CoefficientType:
        """Current coefficient type"""
        return self.___type

    @_type.setter
    def _type(self, value: CoefficientType):
        """Set _type"""
        self.___type = value

    @property
    def fileName(self) -> str:
        """Text file containing the current coefficients. The force coefficents in the file must be specified in [kN/(m/s)] for translational degrees of freedom and [kN.s] for rotational degrees of freedom."""
        return self.__fileName

    @fileName.setter
    def fileName(self, value: str):
        """Set fileName"""
        self.__fileName = value
