# This an autogenerated file
# 
# Generated with RetardationElementData
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.retardationelementdata import RetardationElementDataBlueprint
from numpy import ndarray,asarray
from ..sima import MOAO
from ..sima import ScriptableValue
from .dof import DOF

class RetardationElementData(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    dof1 : DOF
    dof2 : DOF
    values : ndarray of float
    """

    def __init__(self , description="", dof1=DOF.X, dof2=DOF.X, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.dof1 = dof1
        self.dof2 = dof2
        self.values = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return RetardationElementDataBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def dof1(self) -> DOF:
        """"""
        return self.__dof1

    @dof1.setter
    def dof1(self, value: DOF):
        """Set dof1"""
        self.__dof1 = value

    @property
    def dof2(self) -> DOF:
        """"""
        return self.__dof2

    @dof2.setter
    def dof2(self, value: DOF):
        """Set dof2"""
        self.__dof2 = value

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__values = array
