# This an autogenerated file
# 
# Generated with WaveDriftDamping
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.wavedriftdamping import WaveDriftDampingBlueprint
from numpy import ndarray,asarray
from ..sima import MOAO
from ..sima import ScriptableValue
from .directionsymmetry import DirectionSymmetry
from .wavedriftdampingdofitem import WaveDriftDampingDofItem
from .wavedriftdampingforce import WaveDriftDampingForce
from .wavedriftdampingsource import WaveDriftDampingSource

class WaveDriftDamping(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray of float
    frequencies : ndarray of float
    symmetry : DirectionSymmetry
    items : List[WaveDriftDampingDofItem]
    from_ : WaveDriftDampingSource
         Calculate from
    forceCalculation : WaveDriftDampingForce
    """

    def __init__(self , description="", symmetry=DirectionSymmetry.NO_SYMMETRY, from_=WaveDriftDampingSource.INPUT, forceCalculation=WaveDriftDampingForce.ABSOLUTE, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.directions = []
        self.frequencies = []
        self.symmetry = symmetry
        self.items = list()
        self.from_ = from_
        self.forceCalculation = forceCalculation
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WaveDriftDampingBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__directions = array

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__frequencies = array

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def items(self) -> List[WaveDriftDampingDofItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[WaveDriftDampingDofItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def from_(self) -> WaveDriftDampingSource:
        """Calculate from"""
        return self.__from_

    @from_.setter
    def from_(self, value: WaveDriftDampingSource):
        """Set from_"""
        self.__from_ = value

    @property
    def forceCalculation(self) -> WaveDriftDampingForce:
        """"""
        return self.__forceCalculation

    @forceCalculation.setter
    def forceCalculation(self, value: WaveDriftDampingForce):
        """Set forceCalculation"""
        self.__forceCalculation = value
