# This an autogenerated file
# 
# Generated with WaveDriftForce
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.wavedriftforce import WaveDriftForceBlueprint
from numpy import ndarray,asarray
from ..sima import MOAO
from ..sima import ScriptableValue
from .directiondependentvalues import DirectionDependentValues
from .directionsymmetry import DirectionSymmetry

class WaveDriftForce(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray of float
    frequencies : ndarray of float
    symmetry : DirectionSymmetry
    fx : DirectionDependentValues
    fy : DirectionDependentValues
    fz : DirectionDependentValues
    mx : DirectionDependentValues
    my : DirectionDependentValues
    mz : DirectionDependentValues
    enableCurrentCorrection : bool
         Enable wave-current interaction using extended Aranha formula(default False)
    """

    def __init__(self , description="", symmetry=DirectionSymmetry.NO_SYMMETRY, enableCurrentCorrection=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.directions = []
        self.frequencies = []
        self.symmetry = symmetry
        self.fx = None
        self.fy = None
        self.fz = None
        self.mx = None
        self.my = None
        self.mz = None
        self.enableCurrentCorrection = enableCurrentCorrection
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WaveDriftForceBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__directions = array

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__frequencies = array

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def fx(self) -> DirectionDependentValues:
        """"""
        return self.__fx

    @fx.setter
    def fx(self, value: DirectionDependentValues):
        """Set fx"""
        self.__fx = value

    @property
    def fy(self) -> DirectionDependentValues:
        """"""
        return self.__fy

    @fy.setter
    def fy(self, value: DirectionDependentValues):
        """Set fy"""
        self.__fy = value

    @property
    def fz(self) -> DirectionDependentValues:
        """"""
        return self.__fz

    @fz.setter
    def fz(self, value: DirectionDependentValues):
        """Set fz"""
        self.__fz = value

    @property
    def mx(self) -> DirectionDependentValues:
        """"""
        return self.__mx

    @mx.setter
    def mx(self, value: DirectionDependentValues):
        """Set mx"""
        self.__mx = value

    @property
    def my(self) -> DirectionDependentValues:
        """"""
        return self.__my

    @my.setter
    def my(self, value: DirectionDependentValues):
        """Set my"""
        self.__my = value

    @property
    def mz(self) -> DirectionDependentValues:
        """"""
        return self.__mz

    @mz.setter
    def mz(self, value: DirectionDependentValues):
        """Set mz"""
        self.__mz = value

    @property
    def enableCurrentCorrection(self) -> bool:
        """Enable wave-current interaction using extended Aranha formula"""
        return self.__enableCurrentCorrection

    @enableCurrentCorrection.setter
    def enableCurrentCorrection(self, value: bool):
        """Set enableCurrentCorrection"""
        self.__enableCurrentCorrection = bool(value)
