# This an autogenerated file
# 
# Generated with OmniDirectionalScatterData
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.omnidirectionalscatterdata import OmniDirectionalScatterDataBlueprint
from numpy import ndarray,asarray
from ..sima import ScriptableValue
from .scatterdata import ScatterData
from .scatterdimension import ScatterDimension
from .scatterlevelcontainer import ScatterLevelContainer

class OmniDirectionalScatterData(ScatterData):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    hsUpperLimits : ScatterDimension
    tpUpperLimits : ScatterDimension
    windScatter : ScatterLevelContainer
    currentScatter : ScatterLevelContainer
    occurrences : ndarray of int
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.hsUpperLimits = None
        self.tpUpperLimits = None
        self.windScatter = None
        self.currentScatter = None
        self.occurrences = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return OmniDirectionalScatterDataBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def hsUpperLimits(self) -> ScatterDimension:
        """"""
        return self.__hsUpperLimits

    @hsUpperLimits.setter
    def hsUpperLimits(self, value: ScatterDimension):
        """Set hsUpperLimits"""
        self.__hsUpperLimits = value

    @property
    def tpUpperLimits(self) -> ScatterDimension:
        """"""
        return self.__tpUpperLimits

    @tpUpperLimits.setter
    def tpUpperLimits(self, value: ScatterDimension):
        """Set tpUpperLimits"""
        self.__tpUpperLimits = value

    @property
    def windScatter(self) -> ScatterLevelContainer:
        """"""
        return self.__windScatter

    @windScatter.setter
    def windScatter(self, value: ScatterLevelContainer):
        """Set windScatter"""
        self.__windScatter = value

    @property
    def currentScatter(self) -> ScatterLevelContainer:
        """"""
        return self.__currentScatter

    @currentScatter.setter
    def currentScatter(self, value: ScatterLevelContainer):
        """Set currentScatter"""
        self.__currentScatter = value

    @property
    def occurrences(self) -> ndarray:
        """"""
        return self.__occurrences

    @occurrences.setter
    def occurrences(self, value: ndarray):
        """Set occurrences"""
        array = asarray(value, dtype=int)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__occurrences = array
