# This an autogenerated file
# 
# Generated with SignalInputSlot
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.signalinputslot import SignalInputSlotBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .generatorsignal import GeneratorSignal
from .inputslot import InputSlot
from .signalgeneratorcontainer import SignalGeneratorContainer
from .signalproperties import SignalProperties

class SignalInputSlot(InputSlot,SignalGeneratorContainer):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    properties : List[SignalProperties]
    signals : List[GeneratorSignal]
    children : List[SignalGeneratorContainer]
    includeRootFolder : bool
         Will add a root folder to the output(default False)
    """

    def __init__(self , description="", includeRootFolder=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.properties = list()
        self.signals = list()
        self.children = list()
        self.includeRootFolder = includeRootFolder
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SignalInputSlotBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def properties(self) -> List[SignalProperties]:
        """"""
        return self.__properties

    @properties.setter
    def properties(self, value: List[SignalProperties]):
        """Set properties"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__properties = value

    @property
    def signals(self) -> List[GeneratorSignal]:
        """"""
        return self.__signals

    @signals.setter
    def signals(self, value: List[GeneratorSignal]):
        """Set signals"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__signals = value

    @property
    def children(self) -> List[SignalGeneratorContainer]:
        """"""
        return self.__children

    @children.setter
    def children(self, value: List[SignalGeneratorContainer]):
        """Set children"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__children = value

    @property
    def includeRootFolder(self) -> bool:
        """Will add a root folder to the output"""
        return self.__includeRootFolder

    @includeRootFolder.setter
    def includeRootFolder(self, value: bool):
        """Set includeRootFolder"""
        self.__includeRootFolder = bool(value)
