# This an autogenerated file
# 
# Generated with WindowFilter
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.windowfilter import WindowFilterBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .controlsignalinputslot import ControlSignalInputSlot
from .inputslot import InputSlot
from .operationnode import OperationNode
from .outputslot import OutputSlot

class WindowFilter(OperationNode):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    x : int
         (default 0)
    y : int
         (default 0)
    h : int
         (default 0)
    w : int
         (default 0)
    controlSignalInputSlots : List[ControlSignalInputSlot]
    filterInputSlots : List[InputSlot]
    filterOutputSlots : List[OutputSlot]
    renameOutput : bool
         (default True)
    useIndex : bool
         Specify start and end index of signal(default False)
    start : float
         (default 0.0)
    end : float
         (default 0.0)
    setStartValue : bool
         (default False)
    startValue : float
         (default 0.0)
    startIndex : int
         (default 0)
    endIndex : int
         End index or last index if not set(default 0)
    """

    def __init__(self , description="", x=0, y=0, h=0, w=0, renameOutput=True, useIndex=False, start=0.0, end=0.0, setStartValue=False, startValue=0.0, startIndex=0, endIndex=0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.x = x
        self.y = y
        self.h = h
        self.w = w
        self.controlSignalInputSlots = list()
        self.filterInputSlots = list()
        self.filterOutputSlots = list()
        self.renameOutput = renameOutput
        self.useIndex = useIndex
        self.start = start
        self.end = end
        self.setStartValue = setStartValue
        self.startValue = startValue
        self.startIndex = startIndex
        self.endIndex = endIndex
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WindowFilterBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def x(self) -> int:
        """"""
        return self.__x

    @x.setter
    def x(self, value: int):
        """Set x"""
        self.__x = int(value)

    @property
    def y(self) -> int:
        """"""
        return self.__y

    @y.setter
    def y(self, value: int):
        """Set y"""
        self.__y = int(value)

    @property
    def h(self) -> int:
        """"""
        return self.__h

    @h.setter
    def h(self, value: int):
        """Set h"""
        self.__h = int(value)

    @property
    def w(self) -> int:
        """"""
        return self.__w

    @w.setter
    def w(self, value: int):
        """Set w"""
        self.__w = int(value)

    @property
    def controlSignalInputSlots(self) -> List[ControlSignalInputSlot]:
        """"""
        return self.__controlSignalInputSlots

    @controlSignalInputSlots.setter
    def controlSignalInputSlots(self, value: List[ControlSignalInputSlot]):
        """Set controlSignalInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__controlSignalInputSlots = value

    @property
    def filterInputSlots(self) -> List[InputSlot]:
        """"""
        return self.__filterInputSlots

    @filterInputSlots.setter
    def filterInputSlots(self, value: List[InputSlot]):
        """Set filterInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__filterInputSlots = value

    @property
    def filterOutputSlots(self) -> List[OutputSlot]:
        """"""
        return self.__filterOutputSlots

    @filterOutputSlots.setter
    def filterOutputSlots(self, value: List[OutputSlot]):
        """Set filterOutputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__filterOutputSlots = value

    @property
    def renameOutput(self) -> bool:
        """"""
        return self.__renameOutput

    @renameOutput.setter
    def renameOutput(self, value: bool):
        """Set renameOutput"""
        self.__renameOutput = bool(value)

    @property
    def useIndex(self) -> bool:
        """Specify start and end index of signal"""
        return self.__useIndex

    @useIndex.setter
    def useIndex(self, value: bool):
        """Set useIndex"""
        self.__useIndex = bool(value)

    @property
    def start(self) -> float:
        """"""
        return self.__start

    @start.setter
    def start(self, value: float):
        """Set start"""
        self.__start = float(value)

    @property
    def end(self) -> float:
        """"""
        return self.__end

    @end.setter
    def end(self, value: float):
        """Set end"""
        self.__end = float(value)

    @property
    def setStartValue(self) -> bool:
        """"""
        return self.__setStartValue

    @setStartValue.setter
    def setStartValue(self, value: bool):
        """Set setStartValue"""
        self.__setStartValue = bool(value)

    @property
    def startValue(self) -> float:
        """"""
        return self.__startValue

    @startValue.setter
    def startValue(self, value: float):
        """Set startValue"""
        self.__startValue = float(value)

    @property
    def startIndex(self) -> int:
        """"""
        return self.__startIndex

    @startIndex.setter
    def startIndex(self, value: int):
        """Set startIndex"""
        self.__startIndex = int(value)

    @property
    def endIndex(self) -> int:
        """End index or last index if not set"""
        return self.__endIndex

    @endIndex.setter
    def endIndex(self, value: int):
        """Set endIndex"""
        self.__endIndex = int(value)
