# This an autogenerated file
# 
# Generated with ZeroCrossingOperation
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.zerocrossingoperation import ZeroCrossingOperationBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .controlsignalinputslot import ControlSignalInputSlot
from .inputslot import InputSlot
from .operationnode import OperationNode
from .outputslot import OutputSlot
from .zerocrossing import ZeroCrossing

class ZeroCrossingOperation(OperationNode):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    x : int
         (default 0)
    y : int
         (default 0)
    h : int
         (default 0)
    w : int
         (default 0)
    controlSignalInputSlots : List[ControlSignalInputSlot]
    filterInputSlots : List[InputSlot]
    filterOutputSlots : List[OutputSlot]
    renameOutput : bool
         (default True)
    firstCrossing : bool
         Use the first crossing only(default False)
    threshold : float
         Defines the crossing threshold. NB! Value must be given in SI even though presentation unit is not(default 0.0)
    zeroCrossing : ZeroCrossing
         Trigger when the value cross the threshold from below or from above
    """

    def __init__(self , description="", x=0, y=0, h=0, w=0, renameOutput=True, firstCrossing=False, threshold=0.0, zeroCrossing=ZeroCrossing.UP, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.x = x
        self.y = y
        self.h = h
        self.w = w
        self.controlSignalInputSlots = list()
        self.filterInputSlots = list()
        self.filterOutputSlots = list()
        self.renameOutput = renameOutput
        self.firstCrossing = firstCrossing
        self.threshold = threshold
        self.zeroCrossing = zeroCrossing
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ZeroCrossingOperationBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def x(self) -> int:
        """"""
        return self.__x

    @x.setter
    def x(self, value: int):
        """Set x"""
        self.__x = int(value)

    @property
    def y(self) -> int:
        """"""
        return self.__y

    @y.setter
    def y(self, value: int):
        """Set y"""
        self.__y = int(value)

    @property
    def h(self) -> int:
        """"""
        return self.__h

    @h.setter
    def h(self, value: int):
        """Set h"""
        self.__h = int(value)

    @property
    def w(self) -> int:
        """"""
        return self.__w

    @w.setter
    def w(self, value: int):
        """Set w"""
        self.__w = int(value)

    @property
    def controlSignalInputSlots(self) -> List[ControlSignalInputSlot]:
        """"""
        return self.__controlSignalInputSlots

    @controlSignalInputSlots.setter
    def controlSignalInputSlots(self, value: List[ControlSignalInputSlot]):
        """Set controlSignalInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__controlSignalInputSlots = value

    @property
    def filterInputSlots(self) -> List[InputSlot]:
        """"""
        return self.__filterInputSlots

    @filterInputSlots.setter
    def filterInputSlots(self, value: List[InputSlot]):
        """Set filterInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__filterInputSlots = value

    @property
    def filterOutputSlots(self) -> List[OutputSlot]:
        """"""
        return self.__filterOutputSlots

    @filterOutputSlots.setter
    def filterOutputSlots(self, value: List[OutputSlot]):
        """Set filterOutputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__filterOutputSlots = value

    @property
    def renameOutput(self) -> bool:
        """"""
        return self.__renameOutput

    @renameOutput.setter
    def renameOutput(self, value: bool):
        """Set renameOutput"""
        self.__renameOutput = bool(value)

    @property
    def firstCrossing(self) -> bool:
        """Use the first crossing only"""
        return self.__firstCrossing

    @firstCrossing.setter
    def firstCrossing(self, value: bool):
        """Set firstCrossing"""
        self.__firstCrossing = bool(value)

    @property
    def threshold(self) -> float:
        """Defines the crossing threshold. NB! Value must be given in SI even though presentation unit is not"""
        return self.__threshold

    @threshold.setter
    def threshold(self, value: float):
        """Set threshold"""
        self.__threshold = float(value)

    @property
    def zeroCrossing(self) -> ZeroCrossing:
        """Trigger when the value cross the threshold from below or from above"""
        return self.__zeroCrossing

    @zeroCrossing.setter
    def zeroCrossing(self, value: ZeroCrossing):
        """Set zeroCrossing"""
        self.__zeroCrossing = value
