# This an autogenerated file
# 
# Generated with Table
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.table import TableBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .reportitem import ReportItem
from .tablecolumn import TableColumn
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from ..sima import MOAO

class Table(ReportItem):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    object : MOAO
    caption : str
         Caption(default None)
    autoSplit : bool
         Automatically split a large table into multiple tables.(default True)
    columns : List[TableColumn]
    customisableTable : bool
         (default False)
    """

    def __init__(self , description="", autoSplit=True, customisableTable=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.object = None
        self.caption = None
        self.autoSplit = autoSplit
        self.columns = list()
        self.customisableTable = customisableTable
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return TableBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def object(self) -> MOAO:
        """"""
        return self.__object

    @object.setter
    def object(self, value: MOAO):
        """Set object"""
        self.__object = value

    @property
    def caption(self) -> str:
        """Caption"""
        return self.__caption

    @caption.setter
    def caption(self, value: str):
        """Set caption"""
        self.__caption = value

    @property
    def autoSplit(self) -> bool:
        """Automatically split a large table into multiple tables."""
        return self.__autoSplit

    @autoSplit.setter
    def autoSplit(self, value: bool):
        """Set autoSplit"""
        self.__autoSplit = bool(value)

    @property
    def columns(self) -> List[TableColumn]:
        """"""
        return self.__columns

    @columns.setter
    def columns(self, value: List[TableColumn]):
        """Set columns"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__columns = value

    @property
    def customisableTable(self) -> bool:
        """"""
        return self.__customisableTable

    @customisableTable.setter
    def customisableTable(self, value: bool):
        """Set customisableTable"""
        self.__customisableTable = bool(value)
