# This an autogenerated file
# 
# Generated with BendingStiffnessY_Item
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.bendingstiffnessy_item import BendingStiffnessY_ItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class BendingStiffnessY_Item(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    curvatureValue : float
         Curvature value for which bending moment is specified(default 0.0)
    bendingMoment : float
         Corresponding bending moment(default 0.0)
    """

    def __init__(self , description="", curvatureValue=0.0, bendingMoment=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.curvatureValue = curvatureValue
        self.bendingMoment = bendingMoment
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return BendingStiffnessY_ItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def curvatureValue(self) -> float:
        """Curvature value for which bending moment is specified"""
        return self.__curvatureValue

    @curvatureValue.setter
    def curvatureValue(self, value: float):
        """Set curvatureValue"""
        self.__curvatureValue = float(value)

    @property
    def bendingMoment(self) -> float:
        """Corresponding bending moment"""
        return self.__bendingMoment

    @bendingMoment.setter
    def bendingMoment(self, value: float):
        """Set bendingMoment"""
        self.__bendingMoment = float(value)
