# This an autogenerated file
# 
# Generated with BendingStiffnessYZ_Item
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.bendingstiffnessyz_item import BendingStiffnessYZ_ItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class BendingStiffnessYZ_Item(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    curvatureValue : float
         Curvature value for which bending moment is specified(default 0.0)
    bendingMomentY : float
         Bending moment around y-axis corresponding to curvature values.(default 0.0)
    bendingMomentZ : float
         Bending moment around z-axis corresponding to curvature values.(default 0.0)
    """

    def __init__(self , description="", curvatureValue=0.0, bendingMomentY=0.0, bendingMomentZ=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.curvatureValue = curvatureValue
        self.bendingMomentY = bendingMomentY
        self.bendingMomentZ = bendingMomentZ
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return BendingStiffnessYZ_ItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def curvatureValue(self) -> float:
        """Curvature value for which bending moment is specified"""
        return self.__curvatureValue

    @curvatureValue.setter
    def curvatureValue(self, value: float):
        """Set curvatureValue"""
        self.__curvatureValue = float(value)

    @property
    def bendingMomentY(self) -> float:
        """Bending moment around y-axis corresponding to curvature values."""
        return self.__bendingMomentY

    @bendingMomentY.setter
    def bendingMomentY(self, value: float):
        """Set bendingMomentY"""
        self.__bendingMomentY = float(value)

    @property
    def bendingMomentZ(self) -> float:
        """Bending moment around z-axis corresponding to curvature values."""
        return self.__bendingMomentZ

    @bendingMomentZ.setter
    def bendingMomentZ(self, value: float):
        """Set bendingMomentZ"""
        self.__bendingMomentZ = float(value)
