# This an autogenerated file
# 
# Generated with CurrentProfile
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.currentprofile import CurrentProfileBlueprint
from typing import Dict
from ..environment import CurrentItem
from ..sima import MOAO
from ..sima import ScriptableValue

class CurrentProfile(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    globalXPosition : float
         Global X-coordinate for this current profile(default 0.0)
    globalYPosition : float
         Global Y-coordinate for this current profile(default 0.0)
    items : List[CurrentItem]
    """

    def __init__(self , description="", globalXPosition=0.0, globalYPosition=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.globalXPosition = globalXPosition
        self.globalYPosition = globalYPosition
        self.items = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return CurrentProfileBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def globalXPosition(self) -> float:
        """Global X-coordinate for this current profile"""
        return self.__globalXPosition

    @globalXPosition.setter
    def globalXPosition(self, value: float):
        """Set globalXPosition"""
        self.__globalXPosition = float(value)

    @property
    def globalYPosition(self) -> float:
        """Global Y-coordinate for this current profile"""
        return self.__globalYPosition

    @globalYPosition.setter
    def globalYPosition(self, value: float):
        """Set globalYPosition"""
        self.__globalYPosition = float(value)

    @property
    def items(self) -> List[CurrentItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[CurrentItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__items = value
