# This an autogenerated file
# 
# Generated with DampingDisplacementItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.dampingdisplacementitem import DampingDisplacementItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class DampingDisplacementItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    dampingCoefficient : float
         Damping coefficient.(default 0.0)
    displacement : float
         Spring displacement.(default 0.0)
    """

    def __init__(self , description="", dampingCoefficient=0.0, displacement=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.dampingCoefficient = dampingCoefficient
        self.displacement = displacement
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DampingDisplacementItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def dampingCoefficient(self) -> float:
        """Damping coefficient."""
        return self.__dampingCoefficient

    @dampingCoefficient.setter
    def dampingCoefficient(self, value: float):
        """Set dampingCoefficient"""
        self.__dampingCoefficient = float(value)

    @property
    def displacement(self) -> float:
        """Spring displacement."""
        return self.__displacement

    @displacement.setter
    def displacement(self, value: float):
        """Set displacement"""
        self.__displacement = float(value)
