# This an autogenerated file
# 
# Generated with DragChainType
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.dragchaintype import DragChainTypeBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .nodalcomponenttype import NodalComponentType

class DragChainType(NodalComponentType):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    length : float
         Drag chain length.(default 0.0)
    unitWeight : float
         Drag chain weight.(default 0.0)
    friction : float
         Chain / seafloor friction coefficient.(default 0.0)
    cableLength : float
         Cable length.(default 0.0)
    cableWeight : float
         Cable weight.(default 0.0)
    """

    def __init__(self , description="", length=0.0, unitWeight=0.0, friction=0.0, cableLength=0.0, cableWeight=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.length = length
        self.unitWeight = unitWeight
        self.friction = friction
        self.cableLength = cableLength
        self.cableWeight = cableWeight
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DragChainTypeBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def length(self) -> float:
        """Drag chain length."""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def unitWeight(self) -> float:
        """Drag chain weight."""
        return self.__unitWeight

    @unitWeight.setter
    def unitWeight(self, value: float):
        """Set unitWeight"""
        self.__unitWeight = float(value)

    @property
    def friction(self) -> float:
        """Chain / seafloor friction coefficient."""
        return self.__friction

    @friction.setter
    def friction(self, value: float):
        """Set friction"""
        self.__friction = float(value)

    @property
    def cableLength(self) -> float:
        """Cable length."""
        return self.__cableLength

    @cableLength.setter
    def cableLength(self, value: float):
        """Set cableLength"""
        self.__cableLength = float(value)

    @property
    def cableWeight(self) -> float:
        """Cable weight."""
        return self.__cableWeight

    @cableWeight.setter
    def cableWeight(self, value: float):
        """Set cableWeight"""
        self.__cableWeight = float(value)
