# This an autogenerated file
# 
# Generated with GeneralCrossSection
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.generalcrosssection import GeneralCrossSectionBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .aerodynamicforcetype import AerodynamicForceType
from .aerodynamicinputcode import AerodynamicInputCode
from .crosssection import CrossSection
from .crsaxialdamping import CRSAxialDamping
from .crsaxialfrictionmodel import CRSAxialFrictionModel
from .crsmassdamping import CRSMassDamping
from .crsstiffnessdamping import CRSStiffnessDamping
from .hydrodynamicinputcode import HydrodynamicInputCode
from .loadformulation import LoadFormulation
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from ..windturbine import Airfoil

class GeneralCrossSection(CrossSection,CRSAxialFrictionModel):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    staticFriction : float
         Static friction force corresponding to elongation(default 0.0)
    staticElongation : float
         Relative elongation(default 0.0)
    dynamicFriction : float
         Dynamic friction force corresponding to elongation(default 0.0)
    dynamicElongation : float
         Relative elongation(default 0.0)
    axialFriction : bool
         Local axial friction model(default False)
    scfkSpecification : bool
         Scaling of Froude-Krylov term in Morison’s equation in normal direction(default False)
    loadFormulation : LoadFormulation
    hydrodynamicDiameter : float
         Hydrodynamic diameter(default 0.0)
    hydrodynamicInputCode : HydrodynamicInputCode
         Hydrodynamic input code
    addedMassTanDir : float
         Added mass in tangential direction(default 0.0)
    addedMassNormDir : float
         Added mass in normal direction(default 0.0)
    dampingNormDir : float
         Damping coefficients in normal direction(default 0.0)
    normalDirectionScaling : float
         Scaling factor for Froude-Krylov term in Morison’s equation in normal direction(default 1.0)
    tangentialDirectionScaling : float
         Scale for Froude-Krylov term in Morison’s equation in tangential direction(default 1.0)
    cdx : float
         Quadratic drag force coefficient per unit length in tangential direction(default 0.0)
    cdy : float
         Quadratic drag force coefficient per unit length in local y-direction(default 0.0)
    cdz : float
         Quadratic drag force coefficient per unit length local z-direction(default 0.0)
    amx : float
         Added mass per unit length in tangential direction(default 0.0)
    amy : float
         Added mass per unit length in local y-direction(default 0.0)
    amz : float
         Added mass per unit length in local z-direction(default 0.0)
    addedMass : float
         Added mass per unit length for torsional rotation(default 0.0)
    cdlx : float
         Linear drag force coefficient per unit length in tangential direction(default 0.0)
    cdly : float
         Linear drag force coefficient per unit length in local y-direction(default 0.0)
    cdlz : float
         Linear drag force coefficient per unit length in local z-direction(default 0.0)
    cdt : float
         Quadratic drag coefficient in tangential direction.(default 0.0)
    cdn : float
         Quadratic drag coefficient in normal direction.(default 0.0)
    cdnz : float
         Quadratic drag coefficient in normal direction.(default 0.0)
    massDampingSpecification : bool
         Mass proportional Rayleigh damping(default False)
    stiffnessDampingSpecification : bool
         Stiffness proportional Rayleigh damping(default False)
    axialDampingSpecification : bool
         Local axial damping model(default False)
    massDamping : CRSMassDamping
    stiffnessDamping : CRSStiffnessDamping
    axialDamping : CRSAxialDamping
    cdax : float
         Quadratic aerodynamic drag force coefficient per unit length in tangential direction(default 0.0)
    cday : float
         Quadratic aerodynamic drag force coefficient per unit length in normal direction(default 0.0)
    cdaz : float
         Quadratic aerodynamic drag force coefficient per unit length in z direction(default 0.0)
    aerodynamicInputCode : AerodynamicInputCode
         Aerodynamic input code
    aerodynamicDiameter : float
         Aerodynamic diameter(default 0.0)
    temperature : float
         Temperature at which the specification applies(default 0.0)
    pressureDependency : int
         Pressure dependency parameter related to bending moment(default 0)
    axialStiffness : float
         Axial stiffness(default 0.0)
    tensionCapacity : float
         Tension capacity(default 0.0)
    maxCurvatureY : float
         Maximum curvature around local y-axis(default 0.0)
    maxCurvatureZ : float
         Maximum curvature around local z-axis(default 0.0)
    airfoil : Airfoil
    chordLength : float
         (default 0.0)
    foilOriginY : float
         Y-coordinate of foil origin(default 0.0)
    foilOriginZ : float
         Z-coordinate of foil origin(default 0.0)
    foilInclination : float
         Inclination of foil system in the local cross section (strength) system.(default 0.0)
    aerodynamicForceType : AerodynamicForceType
    coupledBendingTorsion : bool
         Geometric stiffness coupling between bending and torsion(default False)
    alpha : float
         Thermal expansion coefficient(default 0.0)
    massCenterY : float
         Mass center Y-coordinate in beam element system(default 0.0)
    massCenterZ : float
         Mass center Z-coordinate in beam element system(default 0.0)
    buoyancyCenterY : float
         Buoyancy center Y-coordinate in beam element system(default 0.0)
    buoyancyCenterZ : float
         Buoyancy center Z-coordinate in beam element system(default 0.0)
    areaCenterY : float
         Area center Y-coordinate in beam element system(default 0.0)
    areaCenterZ : float
         Area center Z-coordinate in beam element system(default 0.0)
    principalAxesOrientation : float
         Orientation (theta) of principal axes V and W(default 0.0)
    shearCenterY : float
         Shear center Y-coordinate in beam element system(default 0.0)
    shearCenterZ : float
         Shear center Z-coordinate in beam element system(default 0.0)
    massCoefficient : float
         Mass / unit length(default 0.0)
    extCrossSectionalArea : float
         External cross-sectional area(default 0.0)
    intCrossSectionalArea : float
         Internal cross-sectional area(default 0.0)
    gyrationRadius : float
         Radius of gyration about local x-axis(default 0.0)
    torsionStiffness : float
         Torsion stiffness(default 0.0)
    bendingStiffnessV : float
         Bending stiffness around principal V-axis(default 0.0)
    bendingStiffnessW : float
         Bending stiffness around principal W-axis(default 0.0)
    shearStiffnessW : float
         Shear stiffness in principal W-direction. Infinite shear stiffness if equal to zero(default 0.0)
    shearStiffnessV : float
         Shear stiffness in principal V-direction. Infinite shear stiffness if equal to zero(default 0.0)
    """

    def __init__(self , description="", staticFriction=0.0, staticElongation=0.0, dynamicFriction=0.0, dynamicElongation=0.0, axialFriction=False, scfkSpecification=False, loadFormulation=LoadFormulation.MORISON, hydrodynamicDiameter=0.0, hydrodynamicInputCode=HydrodynamicInputCode.DIMENSIONAL, addedMassTanDir=0.0, addedMassNormDir=0.0, dampingNormDir=0.0, normalDirectionScaling=1.0, tangentialDirectionScaling=1.0, cdx=0.0, cdy=0.0, cdz=0.0, amx=0.0, amy=0.0, amz=0.0, addedMass=0.0, cdlx=0.0, cdly=0.0, cdlz=0.0, cdt=0.0, cdn=0.0, cdnz=0.0, massDampingSpecification=False, stiffnessDampingSpecification=False, axialDampingSpecification=False, cdax=0.0, cday=0.0, cdaz=0.0, aerodynamicInputCode=AerodynamicInputCode.NONE, aerodynamicDiameter=0.0, temperature=0.0, pressureDependency=0, axialStiffness=0.0, tensionCapacity=0.0, maxCurvatureY=0.0, maxCurvatureZ=0.0, chordLength=0.0, foilOriginY=0.0, foilOriginZ=0.0, foilInclination=0.0, aerodynamicForceType=AerodynamicForceType.NONE, coupledBendingTorsion=False, alpha=0.0, massCenterY=0.0, massCenterZ=0.0, buoyancyCenterY=0.0, buoyancyCenterZ=0.0, areaCenterY=0.0, areaCenterZ=0.0, principalAxesOrientation=0.0, shearCenterY=0.0, shearCenterZ=0.0, massCoefficient=0.0, extCrossSectionalArea=0.0, intCrossSectionalArea=0.0, gyrationRadius=0.0, torsionStiffness=0.0, bendingStiffnessV=0.0, bendingStiffnessW=0.0, shearStiffnessW=0.0, shearStiffnessV=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.staticFriction = staticFriction
        self.staticElongation = staticElongation
        self.dynamicFriction = dynamicFriction
        self.dynamicElongation = dynamicElongation
        self.axialFriction = axialFriction
        self.scfkSpecification = scfkSpecification
        self.loadFormulation = loadFormulation
        self.hydrodynamicDiameter = hydrodynamicDiameter
        self.hydrodynamicInputCode = hydrodynamicInputCode
        self.addedMassTanDir = addedMassTanDir
        self.addedMassNormDir = addedMassNormDir
        self.dampingNormDir = dampingNormDir
        self.normalDirectionScaling = normalDirectionScaling
        self.tangentialDirectionScaling = tangentialDirectionScaling
        self.cdx = cdx
        self.cdy = cdy
        self.cdz = cdz
        self.amx = amx
        self.amy = amy
        self.amz = amz
        self.addedMass = addedMass
        self.cdlx = cdlx
        self.cdly = cdly
        self.cdlz = cdlz
        self.cdt = cdt
        self.cdn = cdn
        self.cdnz = cdnz
        self.massDampingSpecification = massDampingSpecification
        self.stiffnessDampingSpecification = stiffnessDampingSpecification
        self.axialDampingSpecification = axialDampingSpecification
        self.massDamping = None
        self.stiffnessDamping = None
        self.axialDamping = None
        self.cdax = cdax
        self.cday = cday
        self.cdaz = cdaz
        self.aerodynamicInputCode = aerodynamicInputCode
        self.aerodynamicDiameter = aerodynamicDiameter
        self.temperature = temperature
        self.pressureDependency = pressureDependency
        self.axialStiffness = axialStiffness
        self.tensionCapacity = tensionCapacity
        self.maxCurvatureY = maxCurvatureY
        self.maxCurvatureZ = maxCurvatureZ
        self.airfoil = None
        self.chordLength = chordLength
        self.foilOriginY = foilOriginY
        self.foilOriginZ = foilOriginZ
        self.foilInclination = foilInclination
        self.aerodynamicForceType = aerodynamicForceType
        self.coupledBendingTorsion = coupledBendingTorsion
        self.alpha = alpha
        self.massCenterY = massCenterY
        self.massCenterZ = massCenterZ
        self.buoyancyCenterY = buoyancyCenterY
        self.buoyancyCenterZ = buoyancyCenterZ
        self.areaCenterY = areaCenterY
        self.areaCenterZ = areaCenterZ
        self.principalAxesOrientation = principalAxesOrientation
        self.shearCenterY = shearCenterY
        self.shearCenterZ = shearCenterZ
        self.massCoefficient = massCoefficient
        self.extCrossSectionalArea = extCrossSectionalArea
        self.intCrossSectionalArea = intCrossSectionalArea
        self.gyrationRadius = gyrationRadius
        self.torsionStiffness = torsionStiffness
        self.bendingStiffnessV = bendingStiffnessV
        self.bendingStiffnessW = bendingStiffnessW
        self.shearStiffnessW = shearStiffnessW
        self.shearStiffnessV = shearStiffnessV
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GeneralCrossSectionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def staticFriction(self) -> float:
        """Static friction force corresponding to elongation"""
        return self.__staticFriction

    @staticFriction.setter
    def staticFriction(self, value: float):
        """Set staticFriction"""
        self.__staticFriction = float(value)

    @property
    def staticElongation(self) -> float:
        """Relative elongation"""
        return self.__staticElongation

    @staticElongation.setter
    def staticElongation(self, value: float):
        """Set staticElongation"""
        self.__staticElongation = float(value)

    @property
    def dynamicFriction(self) -> float:
        """Dynamic friction force corresponding to elongation"""
        return self.__dynamicFriction

    @dynamicFriction.setter
    def dynamicFriction(self, value: float):
        """Set dynamicFriction"""
        self.__dynamicFriction = float(value)

    @property
    def dynamicElongation(self) -> float:
        """Relative elongation"""
        return self.__dynamicElongation

    @dynamicElongation.setter
    def dynamicElongation(self, value: float):
        """Set dynamicElongation"""
        self.__dynamicElongation = float(value)

    @property
    def axialFriction(self) -> bool:
        """Local axial friction model"""
        return self.__axialFriction

    @axialFriction.setter
    def axialFriction(self, value: bool):
        """Set axialFriction"""
        self.__axialFriction = bool(value)

    @property
    def scfkSpecification(self) -> bool:
        """Scaling of Froude-Krylov term in Morison’s equation in normal direction"""
        return self.__scfkSpecification

    @scfkSpecification.setter
    def scfkSpecification(self, value: bool):
        """Set scfkSpecification"""
        self.__scfkSpecification = bool(value)

    @property
    def loadFormulation(self) -> LoadFormulation:
        """"""
        return self.__loadFormulation

    @loadFormulation.setter
    def loadFormulation(self, value: LoadFormulation):
        """Set loadFormulation"""
        self.__loadFormulation = value

    @property
    def hydrodynamicDiameter(self) -> float:
        """Hydrodynamic diameter"""
        return self.__hydrodynamicDiameter

    @hydrodynamicDiameter.setter
    def hydrodynamicDiameter(self, value: float):
        """Set hydrodynamicDiameter"""
        self.__hydrodynamicDiameter = float(value)

    @property
    def hydrodynamicInputCode(self) -> HydrodynamicInputCode:
        """Hydrodynamic input code"""
        return self.__hydrodynamicInputCode

    @hydrodynamicInputCode.setter
    def hydrodynamicInputCode(self, value: HydrodynamicInputCode):
        """Set hydrodynamicInputCode"""
        self.__hydrodynamicInputCode = value

    @property
    def addedMassTanDir(self) -> float:
        """Added mass in tangential direction"""
        return self.__addedMassTanDir

    @addedMassTanDir.setter
    def addedMassTanDir(self, value: float):
        """Set addedMassTanDir"""
        self.__addedMassTanDir = float(value)

    @property
    def addedMassNormDir(self) -> float:
        """Added mass in normal direction"""
        return self.__addedMassNormDir

    @addedMassNormDir.setter
    def addedMassNormDir(self, value: float):
        """Set addedMassNormDir"""
        self.__addedMassNormDir = float(value)

    @property
    def dampingNormDir(self) -> float:
        """Damping coefficients in normal direction"""
        return self.__dampingNormDir

    @dampingNormDir.setter
    def dampingNormDir(self, value: float):
        """Set dampingNormDir"""
        self.__dampingNormDir = float(value)

    @property
    def normalDirectionScaling(self) -> float:
        """Scaling factor for Froude-Krylov term in Morison’s equation in normal direction"""
        return self.__normalDirectionScaling

    @normalDirectionScaling.setter
    def normalDirectionScaling(self, value: float):
        """Set normalDirectionScaling"""
        self.__normalDirectionScaling = float(value)

    @property
    def tangentialDirectionScaling(self) -> float:
        """Scale for Froude-Krylov term in Morison’s equation in tangential direction"""
        return self.__tangentialDirectionScaling

    @tangentialDirectionScaling.setter
    def tangentialDirectionScaling(self, value: float):
        """Set tangentialDirectionScaling"""
        self.__tangentialDirectionScaling = float(value)

    @property
    def cdx(self) -> float:
        """Quadratic drag force coefficient per unit length in tangential direction"""
        return self.__cdx

    @cdx.setter
    def cdx(self, value: float):
        """Set cdx"""
        self.__cdx = float(value)

    @property
    def cdy(self) -> float:
        """Quadratic drag force coefficient per unit length in local y-direction"""
        return self.__cdy

    @cdy.setter
    def cdy(self, value: float):
        """Set cdy"""
        self.__cdy = float(value)

    @property
    def cdz(self) -> float:
        """Quadratic drag force coefficient per unit length local z-direction"""
        return self.__cdz

    @cdz.setter
    def cdz(self, value: float):
        """Set cdz"""
        self.__cdz = float(value)

    @property
    def amx(self) -> float:
        """Added mass per unit length in tangential direction"""
        return self.__amx

    @amx.setter
    def amx(self, value: float):
        """Set amx"""
        self.__amx = float(value)

    @property
    def amy(self) -> float:
        """Added mass per unit length in local y-direction"""
        return self.__amy

    @amy.setter
    def amy(self, value: float):
        """Set amy"""
        self.__amy = float(value)

    @property
    def amz(self) -> float:
        """Added mass per unit length in local z-direction"""
        return self.__amz

    @amz.setter
    def amz(self, value: float):
        """Set amz"""
        self.__amz = float(value)

    @property
    def addedMass(self) -> float:
        """Added mass per unit length for torsional rotation"""
        return self.__addedMass

    @addedMass.setter
    def addedMass(self, value: float):
        """Set addedMass"""
        self.__addedMass = float(value)

    @property
    def cdlx(self) -> float:
        """Linear drag force coefficient per unit length in tangential direction"""
        return self.__cdlx

    @cdlx.setter
    def cdlx(self, value: float):
        """Set cdlx"""
        self.__cdlx = float(value)

    @property
    def cdly(self) -> float:
        """Linear drag force coefficient per unit length in local y-direction"""
        return self.__cdly

    @cdly.setter
    def cdly(self, value: float):
        """Set cdly"""
        self.__cdly = float(value)

    @property
    def cdlz(self) -> float:
        """Linear drag force coefficient per unit length in local z-direction"""
        return self.__cdlz

    @cdlz.setter
    def cdlz(self, value: float):
        """Set cdlz"""
        self.__cdlz = float(value)

    @property
    def cdt(self) -> float:
        """Quadratic drag coefficient in tangential direction."""
        return self.__cdt

    @cdt.setter
    def cdt(self, value: float):
        """Set cdt"""
        self.__cdt = float(value)

    @property
    def cdn(self) -> float:
        """Quadratic drag coefficient in normal direction."""
        return self.__cdn

    @cdn.setter
    def cdn(self, value: float):
        """Set cdn"""
        self.__cdn = float(value)

    @property
    def cdnz(self) -> float:
        """Quadratic drag coefficient in normal direction."""
        return self.__cdnz

    @cdnz.setter
    def cdnz(self, value: float):
        """Set cdnz"""
        self.__cdnz = float(value)

    @property
    def massDampingSpecification(self) -> bool:
        """Mass proportional Rayleigh damping"""
        return self.__massDampingSpecification

    @massDampingSpecification.setter
    def massDampingSpecification(self, value: bool):
        """Set massDampingSpecification"""
        self.__massDampingSpecification = bool(value)

    @property
    def stiffnessDampingSpecification(self) -> bool:
        """Stiffness proportional Rayleigh damping"""
        return self.__stiffnessDampingSpecification

    @stiffnessDampingSpecification.setter
    def stiffnessDampingSpecification(self, value: bool):
        """Set stiffnessDampingSpecification"""
        self.__stiffnessDampingSpecification = bool(value)

    @property
    def axialDampingSpecification(self) -> bool:
        """Local axial damping model"""
        return self.__axialDampingSpecification

    @axialDampingSpecification.setter
    def axialDampingSpecification(self, value: bool):
        """Set axialDampingSpecification"""
        self.__axialDampingSpecification = bool(value)

    @property
    def massDamping(self) -> CRSMassDamping:
        """"""
        return self.__massDamping

    @massDamping.setter
    def massDamping(self, value: CRSMassDamping):
        """Set massDamping"""
        self.__massDamping = value

    @property
    def stiffnessDamping(self) -> CRSStiffnessDamping:
        """"""
        return self.__stiffnessDamping

    @stiffnessDamping.setter
    def stiffnessDamping(self, value: CRSStiffnessDamping):
        """Set stiffnessDamping"""
        self.__stiffnessDamping = value

    @property
    def axialDamping(self) -> CRSAxialDamping:
        """"""
        return self.__axialDamping

    @axialDamping.setter
    def axialDamping(self, value: CRSAxialDamping):
        """Set axialDamping"""
        self.__axialDamping = value

    @property
    def cdax(self) -> float:
        """Quadratic aerodynamic drag force coefficient per unit length in tangential direction"""
        return self.__cdax

    @cdax.setter
    def cdax(self, value: float):
        """Set cdax"""
        self.__cdax = float(value)

    @property
    def cday(self) -> float:
        """Quadratic aerodynamic drag force coefficient per unit length in normal direction"""
        return self.__cday

    @cday.setter
    def cday(self, value: float):
        """Set cday"""
        self.__cday = float(value)

    @property
    def cdaz(self) -> float:
        """Quadratic aerodynamic drag force coefficient per unit length in z direction"""
        return self.__cdaz

    @cdaz.setter
    def cdaz(self, value: float):
        """Set cdaz"""
        self.__cdaz = float(value)

    @property
    def aerodynamicInputCode(self) -> AerodynamicInputCode:
        """Aerodynamic input code"""
        return self.__aerodynamicInputCode

    @aerodynamicInputCode.setter
    def aerodynamicInputCode(self, value: AerodynamicInputCode):
        """Set aerodynamicInputCode"""
        self.__aerodynamicInputCode = value

    @property
    def aerodynamicDiameter(self) -> float:
        """Aerodynamic diameter"""
        return self.__aerodynamicDiameter

    @aerodynamicDiameter.setter
    def aerodynamicDiameter(self, value: float):
        """Set aerodynamicDiameter"""
        self.__aerodynamicDiameter = float(value)

    @property
    def temperature(self) -> float:
        """Temperature at which the specification applies"""
        return self.__temperature

    @temperature.setter
    def temperature(self, value: float):
        """Set temperature"""
        self.__temperature = float(value)

    @property
    def pressureDependency(self) -> int:
        """Pressure dependency parameter related to bending moment"""
        return self.__pressureDependency

    @pressureDependency.setter
    def pressureDependency(self, value: int):
        """Set pressureDependency"""
        self.__pressureDependency = int(value)

    @property
    def axialStiffness(self) -> float:
        """Axial stiffness"""
        return self.__axialStiffness

    @axialStiffness.setter
    def axialStiffness(self, value: float):
        """Set axialStiffness"""
        self.__axialStiffness = float(value)

    @property
    def tensionCapacity(self) -> float:
        """Tension capacity"""
        return self.__tensionCapacity

    @tensionCapacity.setter
    def tensionCapacity(self, value: float):
        """Set tensionCapacity"""
        self.__tensionCapacity = float(value)

    @property
    def maxCurvatureY(self) -> float:
        """Maximum curvature around local y-axis"""
        return self.__maxCurvatureY

    @maxCurvatureY.setter
    def maxCurvatureY(self, value: float):
        """Set maxCurvatureY"""
        self.__maxCurvatureY = float(value)

    @property
    def maxCurvatureZ(self) -> float:
        """Maximum curvature around local z-axis"""
        return self.__maxCurvatureZ

    @maxCurvatureZ.setter
    def maxCurvatureZ(self, value: float):
        """Set maxCurvatureZ"""
        self.__maxCurvatureZ = float(value)

    @property
    def airfoil(self) -> Airfoil:
        """"""
        return self.__airfoil

    @airfoil.setter
    def airfoil(self, value: Airfoil):
        """Set airfoil"""
        self.__airfoil = value

    @property
    def chordLength(self) -> float:
        """"""
        return self.__chordLength

    @chordLength.setter
    def chordLength(self, value: float):
        """Set chordLength"""
        self.__chordLength = float(value)

    @property
    def foilOriginY(self) -> float:
        """Y-coordinate of foil origin"""
        return self.__foilOriginY

    @foilOriginY.setter
    def foilOriginY(self, value: float):
        """Set foilOriginY"""
        self.__foilOriginY = float(value)

    @property
    def foilOriginZ(self) -> float:
        """Z-coordinate of foil origin"""
        return self.__foilOriginZ

    @foilOriginZ.setter
    def foilOriginZ(self, value: float):
        """Set foilOriginZ"""
        self.__foilOriginZ = float(value)

    @property
    def foilInclination(self) -> float:
        """Inclination of foil system in the local cross section (strength) system."""
        return self.__foilInclination

    @foilInclination.setter
    def foilInclination(self, value: float):
        """Set foilInclination"""
        self.__foilInclination = float(value)

    @property
    def aerodynamicForceType(self) -> AerodynamicForceType:
        """"""
        return self.__aerodynamicForceType

    @aerodynamicForceType.setter
    def aerodynamicForceType(self, value: AerodynamicForceType):
        """Set aerodynamicForceType"""
        self.__aerodynamicForceType = value

    @property
    def coupledBendingTorsion(self) -> bool:
        """Geometric stiffness coupling between bending and torsion"""
        return self.__coupledBendingTorsion

    @coupledBendingTorsion.setter
    def coupledBendingTorsion(self, value: bool):
        """Set coupledBendingTorsion"""
        self.__coupledBendingTorsion = bool(value)

    @property
    def alpha(self) -> float:
        """Thermal expansion coefficient"""
        return self.__alpha

    @alpha.setter
    def alpha(self, value: float):
        """Set alpha"""
        self.__alpha = float(value)

    @property
    def massCenterY(self) -> float:
        """Mass center Y-coordinate in beam element system"""
        return self.__massCenterY

    @massCenterY.setter
    def massCenterY(self, value: float):
        """Set massCenterY"""
        self.__massCenterY = float(value)

    @property
    def massCenterZ(self) -> float:
        """Mass center Z-coordinate in beam element system"""
        return self.__massCenterZ

    @massCenterZ.setter
    def massCenterZ(self, value: float):
        """Set massCenterZ"""
        self.__massCenterZ = float(value)

    @property
    def buoyancyCenterY(self) -> float:
        """Buoyancy center Y-coordinate in beam element system"""
        return self.__buoyancyCenterY

    @buoyancyCenterY.setter
    def buoyancyCenterY(self, value: float):
        """Set buoyancyCenterY"""
        self.__buoyancyCenterY = float(value)

    @property
    def buoyancyCenterZ(self) -> float:
        """Buoyancy center Z-coordinate in beam element system"""
        return self.__buoyancyCenterZ

    @buoyancyCenterZ.setter
    def buoyancyCenterZ(self, value: float):
        """Set buoyancyCenterZ"""
        self.__buoyancyCenterZ = float(value)

    @property
    def areaCenterY(self) -> float:
        """Area center Y-coordinate in beam element system"""
        return self.__areaCenterY

    @areaCenterY.setter
    def areaCenterY(self, value: float):
        """Set areaCenterY"""
        self.__areaCenterY = float(value)

    @property
    def areaCenterZ(self) -> float:
        """Area center Z-coordinate in beam element system"""
        return self.__areaCenterZ

    @areaCenterZ.setter
    def areaCenterZ(self, value: float):
        """Set areaCenterZ"""
        self.__areaCenterZ = float(value)

    @property
    def principalAxesOrientation(self) -> float:
        """Orientation (theta) of principal axes V and W"""
        return self.__principalAxesOrientation

    @principalAxesOrientation.setter
    def principalAxesOrientation(self, value: float):
        """Set principalAxesOrientation"""
        self.__principalAxesOrientation = float(value)

    @property
    def shearCenterY(self) -> float:
        """Shear center Y-coordinate in beam element system"""
        return self.__shearCenterY

    @shearCenterY.setter
    def shearCenterY(self, value: float):
        """Set shearCenterY"""
        self.__shearCenterY = float(value)

    @property
    def shearCenterZ(self) -> float:
        """Shear center Z-coordinate in beam element system"""
        return self.__shearCenterZ

    @shearCenterZ.setter
    def shearCenterZ(self, value: float):
        """Set shearCenterZ"""
        self.__shearCenterZ = float(value)

    @property
    def massCoefficient(self) -> float:
        """Mass / unit length"""
        return self.__massCoefficient

    @massCoefficient.setter
    def massCoefficient(self, value: float):
        """Set massCoefficient"""
        self.__massCoefficient = float(value)

    @property
    def extCrossSectionalArea(self) -> float:
        """External cross-sectional area"""
        return self.__extCrossSectionalArea

    @extCrossSectionalArea.setter
    def extCrossSectionalArea(self, value: float):
        """Set extCrossSectionalArea"""
        self.__extCrossSectionalArea = float(value)

    @property
    def intCrossSectionalArea(self) -> float:
        """Internal cross-sectional area"""
        return self.__intCrossSectionalArea

    @intCrossSectionalArea.setter
    def intCrossSectionalArea(self, value: float):
        """Set intCrossSectionalArea"""
        self.__intCrossSectionalArea = float(value)

    @property
    def gyrationRadius(self) -> float:
        """Radius of gyration about local x-axis"""
        return self.__gyrationRadius

    @gyrationRadius.setter
    def gyrationRadius(self, value: float):
        """Set gyrationRadius"""
        self.__gyrationRadius = float(value)

    @property
    def torsionStiffness(self) -> float:
        """Torsion stiffness"""
        return self.__torsionStiffness

    @torsionStiffness.setter
    def torsionStiffness(self, value: float):
        """Set torsionStiffness"""
        self.__torsionStiffness = float(value)

    @property
    def bendingStiffnessV(self) -> float:
        """Bending stiffness around principal V-axis"""
        return self.__bendingStiffnessV

    @bendingStiffnessV.setter
    def bendingStiffnessV(self, value: float):
        """Set bendingStiffnessV"""
        self.__bendingStiffnessV = float(value)

    @property
    def bendingStiffnessW(self) -> float:
        """Bending stiffness around principal W-axis"""
        return self.__bendingStiffnessW

    @bendingStiffnessW.setter
    def bendingStiffnessW(self, value: float):
        """Set bendingStiffnessW"""
        self.__bendingStiffnessW = float(value)

    @property
    def shearStiffnessW(self) -> float:
        """Shear stiffness in principal W-direction. Infinite shear stiffness if equal to zero"""
        return self.__shearStiffnessW

    @shearStiffnessW.setter
    def shearStiffnessW(self, value: float):
        """Set shearStiffnessW"""
        self.__shearStiffnessW = float(value)

    @property
    def shearStiffnessV(self) -> float:
        """Shear stiffness in principal V-direction. Infinite shear stiffness if equal to zero"""
        return self.__shearStiffnessV

    @shearStiffnessV.setter
    def shearStiffnessV(self, value: float):
        """Set shearStiffnessV"""
        self.__shearStiffnessV = float(value)
