# This an autogenerated file
# 
# Generated with GeotechnicalLineSpecificationItem
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.geotechnicallinespecificationitem import GeotechnicalLineSpecificationItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .geotechnical import GeoTechnical
    from .arline import ARLine

class GeotechnicalLineSpecificationItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    geotechnical : GeoTechnical
    line : ARLine
    seabedZCoordinate : float
         Global Z coordinate of seafloor(default 0.0)
    """

    def __init__(self , description="", seabedZCoordinate=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.geotechnical = None
        self.line = None
        self.seabedZCoordinate = seabedZCoordinate
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GeotechnicalLineSpecificationItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def geotechnical(self) -> GeoTechnical:
        """"""
        return self.__geotechnical

    @geotechnical.setter
    def geotechnical(self, value: GeoTechnical):
        """Set geotechnical"""
        self.__geotechnical = value

    @property
    def line(self) -> ARLine:
        """"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def seabedZCoordinate(self) -> float:
        """Global Z coordinate of seafloor"""
        return self.__seabedZCoordinate

    @seabedZCoordinate.setter
    def seabedZCoordinate(self, value: float):
        """Set seabedZCoordinate"""
        self.__seabedZCoordinate = float(value)
