# This an autogenerated file
# 
# Generated with ISO_13628_7CombinedLoading
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.iso_13628_7combinedloading import ISO_13628_7CombinedLoadingBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .combinedloading import CombinedLoading
from .combinedloadingproperties import CombinedLoadingProperties

class ISO_13628_7CombinedLoading(CombinedLoading):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    refPointPressure : float
         Internal design pressure at vertical reference position(default 0.0)
    referencePoint : float
         Vertical reference position for internal pressure. \nGiven as the Z coordinate in global coordinate system.(default 0.0)
    limitTimeInterval : bool
         Specify time window to be applied for assessment of utilization. In case 'end time' exceeds the time series duration, the end of the time series will be used as the end time(default False)
    startTime : float
         (default 0.0)
    endTime : float
         (default 0.0)
    addIntermediateResults : bool
         Add intermediate element results to the output(default False)
    properties : List[CombinedLoadingProperties]
         Specification of nodes for displacement storage
    useDistributionFitting : bool
         Calculate characteristic extreme values of utilization factors using Gumbel distribution fitting(default False)
    seastateReturnPeriod : float
         Return period used for estimating the characteristic extreme value(default 3.0)
    percentile : float
         Specify percentile in extreme value distribution. \nThe value 0.57038 corresponds to the expected extreme, and 0.9 corresponds to 90% estimate of the extreme response(default 0.57038)
    designFactor : float
         Design factor(default 0.8)
    """

    def __init__(self , description="", refPointPressure=0.0, referencePoint=0.0, limitTimeInterval=False, startTime=0.0, endTime=0.0, addIntermediateResults=False, useDistributionFitting=False, seastateReturnPeriod=3.0, percentile=0.57038, designFactor=0.8, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.refPointPressure = refPointPressure
        self.referencePoint = referencePoint
        self.limitTimeInterval = limitTimeInterval
        self.startTime = startTime
        self.endTime = endTime
        self.addIntermediateResults = addIntermediateResults
        self.properties = list()
        self.useDistributionFitting = useDistributionFitting
        self.seastateReturnPeriod = seastateReturnPeriod
        self.percentile = percentile
        self.designFactor = designFactor
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ISO_13628_7CombinedLoadingBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def refPointPressure(self) -> float:
        """Internal design pressure at vertical reference position"""
        return self.__refPointPressure

    @refPointPressure.setter
    def refPointPressure(self, value: float):
        """Set refPointPressure"""
        self.__refPointPressure = float(value)

    @property
    def referencePoint(self) -> float:
        """Vertical reference position for internal pressure. 
Given as the Z coordinate in global coordinate system."""
        return self.__referencePoint

    @referencePoint.setter
    def referencePoint(self, value: float):
        """Set referencePoint"""
        self.__referencePoint = float(value)

    @property
    def limitTimeInterval(self) -> bool:
        """Specify time window to be applied for assessment of utilization. In case 'end time' exceeds the time series duration, the end of the time series will be used as the end time"""
        return self.__limitTimeInterval

    @limitTimeInterval.setter
    def limitTimeInterval(self, value: bool):
        """Set limitTimeInterval"""
        self.__limitTimeInterval = bool(value)

    @property
    def startTime(self) -> float:
        """"""
        return self.__startTime

    @startTime.setter
    def startTime(self, value: float):
        """Set startTime"""
        self.__startTime = float(value)

    @property
    def endTime(self) -> float:
        """"""
        return self.__endTime

    @endTime.setter
    def endTime(self, value: float):
        """Set endTime"""
        self.__endTime = float(value)

    @property
    def addIntermediateResults(self) -> bool:
        """Add intermediate element results to the output"""
        return self.__addIntermediateResults

    @addIntermediateResults.setter
    def addIntermediateResults(self, value: bool):
        """Set addIntermediateResults"""
        self.__addIntermediateResults = bool(value)

    @property
    def properties(self) -> List[CombinedLoadingProperties]:
        """Specification of nodes for displacement storage"""
        return self.__properties

    @properties.setter
    def properties(self, value: List[CombinedLoadingProperties]):
        """Set properties"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__properties = value

    @property
    def useDistributionFitting(self) -> bool:
        """Calculate characteristic extreme values of utilization factors using Gumbel distribution fitting"""
        return self.__useDistributionFitting

    @useDistributionFitting.setter
    def useDistributionFitting(self, value: bool):
        """Set useDistributionFitting"""
        self.__useDistributionFitting = bool(value)

    @property
    def seastateReturnPeriod(self) -> float:
        """Return period used for estimating the characteristic extreme value"""
        return self.__seastateReturnPeriod

    @seastateReturnPeriod.setter
    def seastateReturnPeriod(self, value: float):
        """Set seastateReturnPeriod"""
        self.__seastateReturnPeriod = float(value)

    @property
    def percentile(self) -> float:
        """Specify percentile in extreme value distribution. 
The value 0.57038 corresponds to the expected extreme, and 0.9 corresponds to 90% estimate of the extreme response"""
        return self.__percentile

    @percentile.setter
    def percentile(self, value: float):
        """Set percentile"""
        self.__percentile = float(value)

    @property
    def designFactor(self) -> float:
        """Design factor"""
        return self.__designFactor

    @designFactor.setter
    def designFactor(self, value: float):
        """Set designFactor"""
        self.__designFactor = float(value)
