# This an autogenerated file
# 
# Generated with MassFrequencyProperty
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.massfrequencyproperty import MassFrequencyPropertyBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class MassFrequencyProperty(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    nonDimensionalFrequency : float
         Non-dimensional frequency(default 0.0)
    addedMassCoefficient : float
         Added mass coefficient(default 0.0)
    """

    def __init__(self , description="", nonDimensionalFrequency=0.0, addedMassCoefficient=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.nonDimensionalFrequency = nonDimensionalFrequency
        self.addedMassCoefficient = addedMassCoefficient
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return MassFrequencyPropertyBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def nonDimensionalFrequency(self) -> float:
        """Non-dimensional frequency"""
        return self.__nonDimensionalFrequency

    @nonDimensionalFrequency.setter
    def nonDimensionalFrequency(self, value: float):
        """Set nonDimensionalFrequency"""
        self.__nonDimensionalFrequency = float(value)

    @property
    def addedMassCoefficient(self) -> float:
        """Added mass coefficient"""
        return self.__addedMassCoefficient

    @addedMassCoefficient.setter
    def addedMassCoefficient(self, value: float):
        """Set addedMassCoefficient"""
        self.__addedMassCoefficient = float(value)
