# This an autogenerated file
# 
# Generated with RegularLineType
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.regularlinetype import RegularLineTypeBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .arlinetype import ARLineType
from .regularsegment import RegularSegment
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .internalfluidtype import InternalFluidType
    from .nodalcomponenttype import NodalComponentType

class RegularLineType(ARLineType):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    internalFluid : InternalFluidType
         Internal fluid component type.
    endComponent : NodalComponentType
         Nodal component type number for attached body or connector at end 2 of rthe last segment.
    segments : List[RegularSegment]
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.internalFluid = None
        self.endComponent = None
        self.segments = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return RegularLineTypeBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def internalFluid(self) -> InternalFluidType:
        """Internal fluid component type."""
        return self.__internalFluid

    @internalFluid.setter
    def internalFluid(self, value: InternalFluidType):
        """Set internalFluid"""
        self.__internalFluid = value

    @property
    def endComponent(self) -> NodalComponentType:
        """Nodal component type number for attached body or connector at end 2 of rthe last segment."""
        return self.__endComponent

    @endComponent.setter
    def endComponent(self, value: NodalComponentType):
        """Set endComponent"""
        self.__endComponent = value

    @property
    def segments(self) -> List[RegularSegment]:
        """"""
        return self.__segments

    @segments.setter
    def segments(self, value: List[RegularSegment]):
        """Set segments"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__segments = value
