# This an autogenerated file
# 
# Generated with Sand
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.sand import SandBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .soil import Soil
from .soildampingitem import SoilDampingItem

class Sand(Soil):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    strainVelocityExponent : float
         Strain velocity exponent for damping model(default 1.0)
    calculateDamping : bool
         Calculate damping coefficients(default False)
    dampingItems : List[SoilDampingItem]
    upperWeight : float
         (default 0.0)
    lowerWeight : float
         (default 0.0)
    displacement : float
         Target displacement for generating equivalent damping coefficient(default 0.0)
    frequency : float
         Target frequency for generating equivalent damping coefficient(default 0.0)
    initialShearModulus : float
         Initial shear modulus of soil(default 0.0)
    upperFrictionAngle : float
         Angle of internal friction of sand(default 0.0)
    lowerFrictionAngle : float
         Angle of internal friction of sand(default 0.0)
    angleOfSoilFriction : float
         Angle of soil friction on pile wall(default 15.0)
    limitingSkinFriction : float
         Limiting unit skin friction(default 48000.0)
    bearingFactor : float
         Bearing factor(default 8.0)
    limitingTipResistance : float
         Limiting tip resistance(default 1900000.0)
    """

    def __init__(self , description="", strainVelocityExponent=1.0, calculateDamping=False, upperWeight=0.0, lowerWeight=0.0, displacement=0.0, frequency=0.0, initialShearModulus=0.0, upperFrictionAngle=0.0, lowerFrictionAngle=0.0, angleOfSoilFriction=15.0, limitingSkinFriction=48000.0, bearingFactor=8.0, limitingTipResistance=1900000.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.strainVelocityExponent = strainVelocityExponent
        self.calculateDamping = calculateDamping
        self.dampingItems = list()
        self.upperWeight = upperWeight
        self.lowerWeight = lowerWeight
        self.displacement = displacement
        self.frequency = frequency
        self.initialShearModulus = initialShearModulus
        self.upperFrictionAngle = upperFrictionAngle
        self.lowerFrictionAngle = lowerFrictionAngle
        self.angleOfSoilFriction = angleOfSoilFriction
        self.limitingSkinFriction = limitingSkinFriction
        self.bearingFactor = bearingFactor
        self.limitingTipResistance = limitingTipResistance
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SandBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def strainVelocityExponent(self) -> float:
        """Strain velocity exponent for damping model"""
        return self.__strainVelocityExponent

    @strainVelocityExponent.setter
    def strainVelocityExponent(self, value: float):
        """Set strainVelocityExponent"""
        self.__strainVelocityExponent = float(value)

    @property
    def calculateDamping(self) -> bool:
        """Calculate damping coefficients"""
        return self.__calculateDamping

    @calculateDamping.setter
    def calculateDamping(self, value: bool):
        """Set calculateDamping"""
        self.__calculateDamping = bool(value)

    @property
    def dampingItems(self) -> List[SoilDampingItem]:
        """"""
        return self.__dampingItems

    @dampingItems.setter
    def dampingItems(self, value: List[SoilDampingItem]):
        """Set dampingItems"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__dampingItems = value

    @property
    def upperWeight(self) -> float:
        """"""
        return self.__upperWeight

    @upperWeight.setter
    def upperWeight(self, value: float):
        """Set upperWeight"""
        self.__upperWeight = float(value)

    @property
    def lowerWeight(self) -> float:
        """"""
        return self.__lowerWeight

    @lowerWeight.setter
    def lowerWeight(self, value: float):
        """Set lowerWeight"""
        self.__lowerWeight = float(value)

    @property
    def displacement(self) -> float:
        """Target displacement for generating equivalent damping coefficient"""
        return self.__displacement

    @displacement.setter
    def displacement(self, value: float):
        """Set displacement"""
        self.__displacement = float(value)

    @property
    def frequency(self) -> float:
        """Target frequency for generating equivalent damping coefficient"""
        return self.__frequency

    @frequency.setter
    def frequency(self, value: float):
        """Set frequency"""
        self.__frequency = float(value)

    @property
    def initialShearModulus(self) -> float:
        """Initial shear modulus of soil"""
        return self.__initialShearModulus

    @initialShearModulus.setter
    def initialShearModulus(self, value: float):
        """Set initialShearModulus"""
        self.__initialShearModulus = float(value)

    @property
    def upperFrictionAngle(self) -> float:
        """Angle of internal friction of sand"""
        return self.__upperFrictionAngle

    @upperFrictionAngle.setter
    def upperFrictionAngle(self, value: float):
        """Set upperFrictionAngle"""
        self.__upperFrictionAngle = float(value)

    @property
    def lowerFrictionAngle(self) -> float:
        """Angle of internal friction of sand"""
        return self.__lowerFrictionAngle

    @lowerFrictionAngle.setter
    def lowerFrictionAngle(self, value: float):
        """Set lowerFrictionAngle"""
        self.__lowerFrictionAngle = float(value)

    @property
    def angleOfSoilFriction(self) -> float:
        """Angle of soil friction on pile wall"""
        return self.__angleOfSoilFriction

    @angleOfSoilFriction.setter
    def angleOfSoilFriction(self, value: float):
        """Set angleOfSoilFriction"""
        self.__angleOfSoilFriction = float(value)

    @property
    def limitingSkinFriction(self) -> float:
        """Limiting unit skin friction"""
        return self.__limitingSkinFriction

    @limitingSkinFriction.setter
    def limitingSkinFriction(self, value: float):
        """Set limitingSkinFriction"""
        self.__limitingSkinFriction = float(value)

    @property
    def bearingFactor(self) -> float:
        """Bearing factor"""
        return self.__bearingFactor

    @bearingFactor.setter
    def bearingFactor(self, value: float):
        """Set bearingFactor"""
        self.__bearingFactor = float(value)

    @property
    def limitingTipResistance(self) -> float:
        """Limiting tip resistance"""
        return self.__limitingTipResistance

    @limitingTipResistance.setter
    def limitingTipResistance(self, value: float):
        """Set limitingTipResistance"""
        self.__limitingTipResistance = float(value)
