# This an autogenerated file
# 
# Generated with SoilItem
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.soilitem import SoilItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .soil import Soil

class SoilItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    soilMaterial : Soil
         Soil material reference to valid material of type clay or sand
    lowerZ : float
         The distance from mudline to lower end of soil layer(default 0.0)
    """

    def __init__(self , description="", lowerZ=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.soilMaterial = None
        self.lowerZ = lowerZ
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SoilItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def soilMaterial(self) -> Soil:
        """Soil material reference to valid material of type clay or sand"""
        return self.__soilMaterial

    @soilMaterial.setter
    def soilMaterial(self, value: Soil):
        """Set soilMaterial"""
        self.__soilMaterial = value

    @property
    def lowerZ(self) -> float:
        """The distance from mudline to lower end of soil layer"""
        return self.__lowerZ

    @lowerZ.setter
    def lowerZ(self, value: float):
        """Set lowerZ"""
        self.__lowerZ = float(value)
