# This an autogenerated file
# 
# Generated with NumberColumn
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.numbercolumn import NumberColumnBlueprint
from numpy import ndarray,asarray
from .column import Column
from .font import Font

class NumberColumn(Column):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    header : str
         (default None)
    label : str
         (default None)
    headerfont : Font
    cells : ndarray of float
    format : str
         (default None)
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.header = None
        self.label = None
        self.headerfont = None
        self.cells = []
        self.format = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return NumberColumnBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def header(self) -> str:
        """"""
        return self.__header

    @header.setter
    def header(self, value: str):
        """Set header"""
        self.__header = value

    @property
    def label(self) -> str:
        """"""
        return self.__label

    @label.setter
    def label(self, value: str):
        """Set label"""
        self.__label = value

    @property
    def headerfont(self) -> Font:
        """"""
        return self.__headerfont

    @headerfont.setter
    def headerfont(self, value: Font):
        """Set headerfont"""
        self.__headerfont = value

    @property
    def cells(self) -> ndarray:
        """"""
        return self.__cells

    @cells.setter
    def cells(self, value: ndarray):
        """Set cells"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__cells = array

    @property
    def format(self) -> str:
        """"""
        return self.__format

    @format.setter
    def format(self, value: str):
        """Set format"""
        self.__format = value
