# This an autogenerated file
# 
# Generated with ScriptingPreference
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.scriptingpreference import ScriptingPreferenceBlueprint
from numpy import ndarray,asarray
from .scriptablevalue import ScriptableValue
from .simapreference import SIMAPreference

class ScriptingPreference(SIMAPreference):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    showScripts : bool
         (default False)
    javaScriptLocations : ndarray of str
    pythonHome : str
         Override python home folder(default None)
    pythonPaths : ndarray of str
    """

    def __init__(self , description="", showScripts=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.showScripts = showScripts
        self.javaScriptLocations = []
        self.pythonHome = None
        self.pythonPaths = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ScriptingPreferenceBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def showScripts(self) -> bool:
        """"""
        return self.__showScripts

    @showScripts.setter
    def showScripts(self, value: bool):
        """Set showScripts"""
        self.__showScripts = bool(value)

    @property
    def javaScriptLocations(self) -> ndarray:
        """"""
        return self.__javaScriptLocations

    @javaScriptLocations.setter
    def javaScriptLocations(self, value: ndarray):
        """Set javaScriptLocations"""
        array = asarray(value, dtype=str)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__javaScriptLocations = array

    @property
    def pythonHome(self) -> str:
        """Override python home folder"""
        return self.__pythonHome

    @pythonHome.setter
    def pythonHome(self, value: str):
        """Set pythonHome"""
        self.__pythonHome = value

    @property
    def pythonPaths(self) -> ndarray:
        """"""
        return self.__pythonPaths

    @pythonPaths.setter
    def pythonPaths(self, value: ndarray):
        """Set pythonPaths"""
        array = asarray(value, dtype=str)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__pythonPaths = array
