# This an autogenerated file
# 
# Generated with SIMAScriptContext
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.simascriptcontext import SIMAScriptContextBlueprint
from typing import Dict
from .moao import MOAO
from .scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .moao import MOAO

class SIMAScriptContext(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    model : MOAO
         Model object to be directly available in script by given name
    name : str
         Variable name of object that will be available in the script when evaluating(default None)
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.model = None
        self.name = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMAScriptContextBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def model(self) -> MOAO:
        """Model object to be directly available in script by given name"""
        return self.__model

    @model.setter
    def model(self, value: MOAO):
        """Set model"""
        self.__model = value

    @property
    def name(self) -> str:
        """Variable name of object that will be available in the script when evaluating"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value
