# 
# Generated with SIMODynamicCalculationParametersBlueprint
from dmt.blueprint import Blueprint
from dmt.dimension import Dimension
from dmt.attribute import Attribute
from dmt.enum_attribute import EnumAttribute
from dmt.blueprint_attribute import BlueprintAttribute
from ...sima.blueprints.moao import MOAOBlueprint

class SIMODynamicCalculationParametersBlueprint(MOAOBlueprint):
    """"""

    def __init__(self, name="SIMODynamicCalculationParameters", package_path="sima/simo", description=""):
        super().__init__(name,package_path,description)
        self.add_attribute(Attribute("description","string","",default=""))
        self.add_attribute(BlueprintAttribute("scriptableValues","sima/sima/ScriptableValue","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("externalControlSetup","sima/simo/ExternalControlSetup","",True))
        self.add_attribute(BlueprintAttribute("multiEnvironmentSetup","sima/simo/MultiEnvironmentSetup","",True))
        self.add_attribute(Attribute("timeIncrement","number","Time increment for time series generation and storage",default=0.5))
        self.add_attribute(EnumAttribute("waveMethod","sima/simo/WaveMethod","Selected wave method"))
        self.add_attribute(EnumAttribute("integrationMethod","sima/simo/IntegrationMethod","Selected integration method"))
        self.add_attribute(Attribute("randomSeedWaves","integer","Random seed waves",default=1))
        self.add_attribute(Attribute("randomSeedWind","integer","Random seed wind",default=1))
        self.add_attribute(EnumAttribute("randomNumberGenerator","sima/simo/RandomGenerator",""))
        self.add_attribute(Attribute("headingCorrection","boolean","Use correction due to heading change",default=True))
        self.add_attribute(Attribute("maxHeadingChange","number","Max heading change",default=45.0))
        self.add_attribute(Attribute("largePatchLength","number","Large visualization wave patch length",default=2048.0))
        self.add_attribute(Attribute("smallPatchLength","number","Small visualization wave patch length",default=256.0))
        self.add_attribute(Attribute("cutFactorWaves","integer","Cut factor for wave components",default=100))
        self.add_attribute(Attribute("pointsLargePatch","integer","Number of points in large wave patch",default=256))
        self.add_attribute(Attribute("pointsSmallPatch","integer","Number of points in small wave patch",default=128))
        self.add_attribute(Attribute("writeVisFile","boolean","write visualization file?",default=False))
        self.add_attribute(BlueprintAttribute("waveTimeSeries","sima/simo/WaveTimeSeries","",True))
        self.add_attribute(Attribute("waveTimeSeriesFile","boolean","Wave time series from file",default=False))
        self.add_attribute(BlueprintAttribute("bodyWaveMethodOptions","sima/simo/BodyWaveMethodOption","",True,Dimension("*")))
        self.add_attribute(Attribute("hydroSystemPeriod","number","Hydrosystem filter period",default=0.0))
        self.add_attribute(EnumAttribute("hydroFilterMethod","sima/simo/HydroSystemFilterMethod","Hydro Filter Method"))
        self.add_attribute(Attribute("nWindSeaComponents","integer","Number of wind-sea components",default=2000))
        self.add_attribute(Attribute("nSwellSeaComponents","integer","Number of wind-sea components",default=400))
        self.add_attribute(EnumAttribute("windTimeSeriesMethod","sima/simo/WindTimeSeriesMethod","Wind Time Series Method"))
        self.add_attribute(EnumAttribute("windVelocityDimension","sima/simo/WindVelocityDimension","Wind Velocity Dimension"))
        self.add_attribute(EnumAttribute("windForceMethod","sima/simo/WindForceMethod","Wind Force Method"))
        self.add_attribute(EnumAttribute("windMethod","sima/simo/WindMethod",""))
        self.add_attribute(BlueprintAttribute("windSpectrumVerticalDomain","sima/simo/WindSpectrumVerticalDomain","",True))
        self.add_attribute(EnumAttribute("quadraticCurrentForceMethod","sima/simo/CurrentForceMethod","Quadratic Current Force Method"))
        self.add_attribute(EnumAttribute("linearCurrentForceMethod","sima/simo/CurrentForceMethod","Linear Current Force Method"))
        self.add_attribute(Attribute("exportResultsToWasim","boolean","",default=False))
        self.add_attribute(BlueprintAttribute("wasimResultExport","sima/simo/WasimResultExport","",True))
        self.add_attribute(Attribute("storeWindForces","boolean","Store wind forces?",default=False))
        self.add_attribute(Attribute("storeSumGeneralLineForces","boolean","Store sum general line forces?",default=False))
        self.add_attribute(Attribute("storeTotalForces","boolean","Store total forces?",default=False))
        self.add_attribute(Attribute("storeRetardationForces","boolean","Store retardation forces?",default=False))
        self.add_attribute(Attribute("storeHydrostaticStiffnessForces","boolean","Store hydrostatic stiffness forces?",default=False))
        self.add_attribute(Attribute("storeLinearDamping","boolean","Store linear damping?",default=False))
        self.add_attribute(Attribute("storeQuadraticDamping","boolean","Store quadratic damping?",default=False))
        self.add_attribute(Attribute("storeDistributedHydrodynamicForces","boolean","Store distributed hydrodynamic forces?",default=False))
        self.add_attribute(Attribute("storeFixedBodyAndSlenderElementStripResults","boolean","Store results for slender element strips and fixed body elements?",default=False))
        self.add_attribute(Attribute("storeWaveDriftDamping","boolean","Store wave-drift damping?",default=False))
        self.add_attribute(Attribute("storeLinearCurrentDrag","boolean","Store linear current drag?",default=False))
        self.add_attribute(Attribute("storeQuadraticCurrentDrag","boolean","Store quadratic current drag?",default=False))
        self.add_attribute(Attribute("storeSmallBodyHydrodynamicForces","boolean","Store small body hydrodynamic forces?",default=False))
        self.add_attribute(Attribute("storeResultantPositioningElementForces","boolean","Store resultant positioning element forces?",default=False))
        self.add_attribute(Attribute("storePositioningElementForceComponents","boolean","Store positioning element force components?",default=False))
        self.add_attribute(Attribute("storeTotalPositioningForces","boolean","Store total positioning element forces?",default=False))
        self.add_attribute(Attribute("storeThrusterForces","boolean","Store thruster forces?",default=False))
        self.add_attribute(Attribute("storeSumThrusterForces","boolean","Store sum thruster forces?",default=False))
        self.add_attribute(Attribute("storeDynamicPositioningEstimators","boolean","Store dynamic positioning estimators?",default=False))
        self.add_attribute(Attribute("storeSumSpecifiedForces","boolean","Store sum specified forces?",default=False))
        self.add_attribute(Attribute("storeSumExternalForces","boolean","Store sum external forces?",default=False))
        self.add_attribute(Attribute("storeSumCouplingForces","boolean","Store sum coupling forces?",default=False))
        self.add_attribute(Attribute("storeResultantCouplingElementForces","boolean","Store resultant coupling element forces?",default=False))
        self.add_attribute(Attribute("storeGlobalCouplingForceComponents","boolean","Store global coupling force components?",default=False))
        self.add_attribute(Attribute("storeLocalCouplingForceComponents","boolean","Store local coupling force components?",default=False))
        self.add_attribute(Attribute("storeGlobalLowFrequencyPosition","boolean","Store global low-frequency position?",default=False))
        self.add_attribute(Attribute("storeGlobalTotalPosition","boolean","Store global total position?",default=True))
        self.add_attribute(Attribute("storeGlobalAcceleration","boolean","Store global acceleration?",default=False))
        self.add_attribute(Attribute("storeLocalAccelerations","boolean","Store local acceleration?",default=False))
        self.add_attribute(Attribute("storeLocalVelocity","boolean","Store local velocity",default=False))
        self.add_attribute(Attribute("storeCatenarySystemForces","boolean","Store catenery system forces. Requires visualization storage",default=False))
        self.add_attribute(Attribute("storeCatenarySystemNodes","boolean","Store displacement of catenary system nodes. Requires visualization storage",default=False))
        self.add_attribute(Attribute("timeStep","number","Time integration step",default=0.5))
        self.add_attribute(Attribute("simulationLength","number","Simulation length",default=11000.0))
        self.add_attribute(Attribute("simulationStartTime","number","Time (in generated time series) that dynamic simulation will start from",default=0.0))
        self.add_attribute(Attribute("rampDuration","number","Determines the ramp duration in seconds",default=2.5))
        self.add_attribute(Attribute("requestedTimeSeriesLength","number","Length of generated time series",default=16384.0))