# This an autogenerated file
# 
# Generated with ControlSequenceItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.controlsequenceitem import ControlSequenceItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class ControlSequenceItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    time : float
         Time when signal is activated(default 0.0)
    thrust : float
         Thrust demand(default 0.0)
    direction : float
         Demanded thrust force direction(default 0.0)
    acceptDPSystemInput : bool
         Should signals from DP system be accepted?(default False)
    """

    def __init__(self , description="", time=0.0, thrust=0.0, direction=0.0, acceptDPSystemInput=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.time = time
        self.thrust = thrust
        self.direction = direction
        self.acceptDPSystemInput = acceptDPSystemInput
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ControlSequenceItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def time(self) -> float:
        """Time when signal is activated"""
        return self.__time

    @time.setter
    def time(self, value: float):
        """Set time"""
        self.__time = float(value)

    @property
    def thrust(self) -> float:
        """Thrust demand"""
        return self.__thrust

    @thrust.setter
    def thrust(self, value: float):
        """Set thrust"""
        self.__thrust = float(value)

    @property
    def direction(self) -> float:
        """Demanded thrust force direction"""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def acceptDPSystemInput(self) -> bool:
        """Should signals from DP system be accepted?"""
        return self.__acceptDPSystemInput

    @acceptDPSystemInput.setter
    def acceptDPSystemInput(self, value: bool):
        """Set acceptDPSystemInput"""
        self.__acceptDPSystemInput = bool(value)
