# This an autogenerated file
# 
# Generated with CouplingElementResult
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.couplingelementresult import CouplingElementResultBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .forceresult import ForceResult

class CouplingElementResult(ForceResult):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         Force name(default None)
    fx : float
         Statically calculated force(default 0.0)
    fy : float
         Statically calculated force(default 0.0)
    fz : float
         Statically calculated force(default 0.0)
    mx : float
         Statically calculated moment(default 0.0)
    my : float
         Statically calculated moment(default 0.0)
    mz : float
         Statically calculated moment(default 0.0)
    mass : float
         Mass of object(default 0.0)
    coupling : str
         Coupling(default None)
    branch : str
         Connection(default None)
    """

    def __init__(self , description="", fx=0.0, fy=0.0, fz=0.0, mx=0.0, my=0.0, mz=0.0, mass=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.fx = fx
        self.fy = fy
        self.fz = fz
        self.mx = mx
        self.my = my
        self.mz = mz
        self.mass = mass
        self.coupling = None
        self.branch = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return CouplingElementResultBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """Force name"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def fx(self) -> float:
        """Statically calculated force"""
        return self.__fx

    @fx.setter
    def fx(self, value: float):
        """Set fx"""
        self.__fx = float(value)

    @property
    def fy(self) -> float:
        """Statically calculated force"""
        return self.__fy

    @fy.setter
    def fy(self, value: float):
        """Set fy"""
        self.__fy = float(value)

    @property
    def fz(self) -> float:
        """Statically calculated force"""
        return self.__fz

    @fz.setter
    def fz(self, value: float):
        """Set fz"""
        self.__fz = float(value)

    @property
    def mx(self) -> float:
        """Statically calculated moment"""
        return self.__mx

    @mx.setter
    def mx(self, value: float):
        """Set mx"""
        self.__mx = float(value)

    @property
    def my(self) -> float:
        """Statically calculated moment"""
        return self.__my

    @my.setter
    def my(self, value: float):
        """Set my"""
        self.__my = float(value)

    @property
    def mz(self) -> float:
        """Statically calculated moment"""
        return self.__mz

    @mz.setter
    def mz(self, value: float):
        """Set mz"""
        self.__mz = float(value)

    @property
    def mass(self) -> float:
        """Mass of object"""
        return self.__mass

    @mass.setter
    def mass(self, value: float):
        """Set mass"""
        self.__mass = float(value)

    @property
    def coupling(self) -> str:
        """Coupling"""
        return self.__coupling

    @coupling.setter
    def coupling(self, value: str):
        """Set coupling"""
        self.__coupling = value

    @property
    def branch(self) -> str:
        """Connection"""
        return self.__branch

    @branch.setter
    def branch(self, value: str):
        """Set branch"""
        self.__branch = value
