# This an autogenerated file
# 
# Generated with EquilibriumGridDefinition
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.equilibriumgriddefinition import EquilibriumGridDefinitionBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .equilibriumgriddefinitionrow import EquilibriumGridDefinitionRow
from .equilibriumgridtype import EquilibriumGridType
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .simobody import SIMOBody

class EquilibriumGridDefinition(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    roll : EquilibriumGridDefinitionRow
    pitch : EquilibriumGridDefinitionRow
    body : SIMOBody
         Body for which the grid will be defined
    typeOfGrid : EquilibriumGridType
    """

    def __init__(self , description="", typeOfGrid=EquilibriumGridType.ROLL_AND_PITCH_ANGLES, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.roll = None
        self.pitch = None
        self.body = None
        self.typeOfGrid = typeOfGrid
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return EquilibriumGridDefinitionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def roll(self) -> EquilibriumGridDefinitionRow:
        """"""
        return self.__roll

    @roll.setter
    def roll(self, value: EquilibriumGridDefinitionRow):
        """Set roll"""
        self.__roll = value

    @property
    def pitch(self) -> EquilibriumGridDefinitionRow:
        """"""
        return self.__pitch

    @pitch.setter
    def pitch(self, value: EquilibriumGridDefinitionRow):
        """Set pitch"""
        self.__pitch = value

    @property
    def body(self) -> SIMOBody:
        """Body for which the grid will be defined"""
        return self.__body

    @body.setter
    def body(self, value: SIMOBody):
        """Set body"""
        self.__body = value

    @property
    def typeOfGrid(self) -> EquilibriumGridType:
        """"""
        return self.__typeOfGrid

    @typeOfGrid.setter
    def typeOfGrid(self, value: EquilibriumGridType):
        """Set typeOfGrid"""
        self.__typeOfGrid = value
