# This an autogenerated file
# 
# Generated with HydrodynamicCoupling
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.hydrodynamiccoupling import HydrodynamicCouplingBlueprint
from typing import Dict
from ..hydro import CoupledRadiationDataGroup
from ..sima import NamedObject
from ..sima import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .simobody import SIMOBody

class HydrodynamicCoupling(NamedObject):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    body1 : SIMOBody
    body2 : SIMOBody
    radiationData : CoupledRadiationDataGroup
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.body1 = None
        self.body2 = None
        self.radiationData = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return HydrodynamicCouplingBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def body1(self) -> SIMOBody:
        """"""
        return self.__body1

    @body1.setter
    def body1(self, value: SIMOBody):
        """Set body1"""
        self.__body1 = value

    @property
    def body2(self) -> SIMOBody:
        """"""
        return self.__body2

    @body2.setter
    def body2(self, value: SIMOBody):
        """Set body2"""
        self.__body2 = value

    @property
    def radiationData(self) -> CoupledRadiationDataGroup:
        """"""
        return self.__radiationData

    @radiationData.setter
    def radiationData(self, value: CoupledRadiationDataGroup):
        """Set radiationData"""
        self.__radiationData = value
