# This an autogenerated file
# 
# Generated with LineMeasurementItem
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.linemeasurementitem import LineMeasurementItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .lineend import LineEnd
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .lineforceprovider import LineForceProvider

class LineMeasurementItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : LineForceProvider
    lineEnd : LineEnd
         Line end to read measurements from
    """

    def __init__(self , description="", lineEnd=LineEnd.END1, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.line = None
        self.lineEnd = lineEnd
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return LineMeasurementItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> LineForceProvider:
        """"""
        return self.__line

    @line.setter
    def line(self, value: LineForceProvider):
        """Set line"""
        self.__line = value

    @property
    def lineEnd(self) -> LineEnd:
        """Line end to read measurements from"""
        return self.__lineEnd

    @lineEnd.setter
    def lineEnd(self, value: LineEnd):
        """Set lineEnd"""
        self.__lineEnd = value
