# This an autogenerated file
# 
# Generated with PhysicalConstants
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.physicalconstants import PhysicalConstantsBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class PhysicalConstants(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    airDensity : float
         Air density - rho air(default 1.25)
    waterDensity : float
         Water density - rho water(default 1025.0)
    kinematicViscosityWater : float
         Kinematic viscosity of water(default 1.188e-06)
    kinematicViscosityAir : float
         Kinematic viscosity of air(default 1.516e-05)
    accOfGravity : float
         Acceleration of gravity - g(default 9.81)
    """

    def __init__(self , description="", airDensity=1.25, waterDensity=1025.0, kinematicViscosityWater=1.188e-06, kinematicViscosityAir=1.516e-05, accOfGravity=9.81, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.airDensity = airDensity
        self.waterDensity = waterDensity
        self.kinematicViscosityWater = kinematicViscosityWater
        self.kinematicViscosityAir = kinematicViscosityAir
        self.accOfGravity = accOfGravity
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return PhysicalConstantsBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def airDensity(self) -> float:
        """Air density - rho air"""
        return self.__airDensity

    @airDensity.setter
    def airDensity(self, value: float):
        """Set airDensity"""
        self.__airDensity = float(value)

    @property
    def waterDensity(self) -> float:
        """Water density - rho water"""
        return self.__waterDensity

    @waterDensity.setter
    def waterDensity(self, value: float):
        """Set waterDensity"""
        self.__waterDensity = float(value)

    @property
    def kinematicViscosityWater(self) -> float:
        """Kinematic viscosity of water"""
        return self.__kinematicViscosityWater

    @kinematicViscosityWater.setter
    def kinematicViscosityWater(self, value: float):
        """Set kinematicViscosityWater"""
        self.__kinematicViscosityWater = float(value)

    @property
    def kinematicViscosityAir(self) -> float:
        """Kinematic viscosity of air"""
        return self.__kinematicViscosityAir

    @kinematicViscosityAir.setter
    def kinematicViscosityAir(self, value: float):
        """Set kinematicViscosityAir"""
        self.__kinematicViscosityAir = float(value)

    @property
    def accOfGravity(self) -> float:
        """Acceleration of gravity - g"""
        return self.__accOfGravity

    @accOfGravity.setter
    def accOfGravity(self, value: float):
        """Set accOfGravity"""
        self.__accOfGravity = float(value)
