# This an autogenerated file
# 
# Generated with SIMOQuadraticDampingMatrix
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.simoquadraticdampingmatrix import SIMOQuadraticDampingMatrixBlueprint
from numpy import ndarray,asarray
from ..hydro import QuadraticDampingMatrix
from ..sima import Named
from ..sima import ScriptableValue
from .dampingmatrixmotionmode import DampingMatrixMotionMode

class SIMOQuadraticDampingMatrix(QuadraticDampingMatrix,Named):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    values : ndarray of float
    name : str
         (default None)
    mode : DampingMatrixMotionMode
         Select which motions the damping matrix force should be calculated from. When 'default' is selected, low frequency motion is used for bodies of type '6 DOF - separated analysis' and total motion otherwise.
    """

    def __init__(self , description="", mode=DampingMatrixMotionMode.DEFAULT, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.values = []
        self.name = None
        self.mode = mode
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOQuadraticDampingMatrixBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__values = array

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def mode(self) -> DampingMatrixMotionMode:
        """Select which motions the damping matrix force should be calculated from. When 'default' is selected, low frequency motion is used for bodies of type '6 DOF - separated analysis' and total motion otherwise."""
        return self.__mode

    @mode.setter
    def mode(self, value: DampingMatrixMotionMode):
        """Set mode"""
        self.__mode = value
