# This an autogenerated file
# 
# Generated with ThrusterForbiddenZone
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.thrusterforbiddenzone import ThrusterForbiddenZoneBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class ThrusterForbiddenZone(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    zoneStart : float
         Start of forbidden zone of thrust force(default 0.0)
    zoneEnd : float
         End of forbidden zone of thrust force(default 0.0)
    """

    def __init__(self , description="", zoneStart=0.0, zoneEnd=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.zoneStart = zoneStart
        self.zoneEnd = zoneEnd
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ThrusterForbiddenZoneBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def zoneStart(self) -> float:
        """Start of forbidden zone of thrust force"""
        return self.__zoneStart

    @zoneStart.setter
    def zoneStart(self, value: float):
        """Set zoneStart"""
        self.__zoneStart = float(value)

    @property
    def zoneEnd(self) -> float:
        """End of forbidden zone of thrust force"""
        return self.__zoneEnd

    @zoneEnd.setter
    def zoneEnd(self, value: float):
        """Set zoneEnd"""
        self.__zoneEnd = float(value)
