# This an autogenerated file
# 
# Generated with ThrustTorqueCoefficient
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.thrusttorquecoefficient import ThrustTorqueCoefficientBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class ThrustTorqueCoefficient(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    advanceRatio : float
         Advance ratio(default 0.0)
    thrustCoefficient : float
         Thrust coefficient(default 0.0)
    torqueCoefficient : float
         Torque coefficient(default 0.0)
    """

    def __init__(self , description="", advanceRatio=0.0, thrustCoefficient=0.0, torqueCoefficient=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.advanceRatio = advanceRatio
        self.thrustCoefficient = thrustCoefficient
        self.torqueCoefficient = torqueCoefficient
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ThrustTorqueCoefficientBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def advanceRatio(self) -> float:
        """Advance ratio"""
        return self.__advanceRatio

    @advanceRatio.setter
    def advanceRatio(self, value: float):
        """Set advanceRatio"""
        self.__advanceRatio = float(value)

    @property
    def thrustCoefficient(self) -> float:
        """Thrust coefficient"""
        return self.__thrustCoefficient

    @thrustCoefficient.setter
    def thrustCoefficient(self, value: float):
        """Set thrustCoefficient"""
        self.__thrustCoefficient = float(value)

    @property
    def torqueCoefficient(self) -> float:
        """Torque coefficient"""
        return self.__torqueCoefficient

    @torqueCoefficient.setter
    def torqueCoefficient(self, value: float):
        """Set torqueCoefficient"""
        self.__torqueCoefficient = float(value)
