# This an autogenerated file
# 
# Generated with VerticalAxisWindTurbine
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.verticalaxiswindturbine import VerticalAxisWindTurbineBlueprint
from typing import Dict
from ..sima import NamedObject
from ..sima import ScriptableValue
from ..windturbine import VerticalAxisWindTurbineController
from .verticalbladeitem import VerticalBladeItem
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .momentcoupling import MomentCoupling

class VerticalAxisWindTurbine(NamedObject):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    controller : VerticalAxisWindTurbineController
    momentCoupling : MomentCoupling
    referenceHeight : float
         Reference height for calculation of wind(default 0.0)
    windArea : float
         Wind area admittance function(default 0.0)
    radius : float
         Blade radius at lowest node(default 0.0)
    elevation : float
         Elevation of the lowest node(default 0.0)
    offset : float
         Tangential offset of the first blade node(default 0.0)
    bladeItems : List[VerticalBladeItem]
    numBlades : int
         Number of blades(default 0)
    numAzimuthalElements : int
         Number of azimuthal elements for aerodynamic calculation(default 0)
    prandtlFactor : float
         Prandtl factor(default -1.0)
    """

    def __init__(self , description="", referenceHeight=0.0, windArea=0.0, radius=0.0, elevation=0.0, offset=0.0, numBlades=0, numAzimuthalElements=0, prandtlFactor=-1.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.controller = None
        self.momentCoupling = None
        self.referenceHeight = referenceHeight
        self.windArea = windArea
        self.radius = radius
        self.elevation = elevation
        self.offset = offset
        self.bladeItems = list()
        self.numBlades = numBlades
        self.numAzimuthalElements = numAzimuthalElements
        self.prandtlFactor = prandtlFactor
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return VerticalAxisWindTurbineBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def controller(self) -> VerticalAxisWindTurbineController:
        """"""
        return self.__controller

    @controller.setter
    def controller(self, value: VerticalAxisWindTurbineController):
        """Set controller"""
        self.__controller = value

    @property
    def momentCoupling(self) -> MomentCoupling:
        """"""
        return self.__momentCoupling

    @momentCoupling.setter
    def momentCoupling(self, value: MomentCoupling):
        """Set momentCoupling"""
        self.__momentCoupling = value

    @property
    def referenceHeight(self) -> float:
        """Reference height for calculation of wind"""
        return self.__referenceHeight

    @referenceHeight.setter
    def referenceHeight(self, value: float):
        """Set referenceHeight"""
        self.__referenceHeight = float(value)

    @property
    def windArea(self) -> float:
        """Wind area admittance function"""
        return self.__windArea

    @windArea.setter
    def windArea(self, value: float):
        """Set windArea"""
        self.__windArea = float(value)

    @property
    def radius(self) -> float:
        """Blade radius at lowest node"""
        return self.__radius

    @radius.setter
    def radius(self, value: float):
        """Set radius"""
        self.__radius = float(value)

    @property
    def elevation(self) -> float:
        """Elevation of the lowest node"""
        return self.__elevation

    @elevation.setter
    def elevation(self, value: float):
        """Set elevation"""
        self.__elevation = float(value)

    @property
    def offset(self) -> float:
        """Tangential offset of the first blade node"""
        return self.__offset

    @offset.setter
    def offset(self, value: float):
        """Set offset"""
        self.__offset = float(value)

    @property
    def bladeItems(self) -> List[VerticalBladeItem]:
        """"""
        return self.__bladeItems

    @bladeItems.setter
    def bladeItems(self, value: List[VerticalBladeItem]):
        """Set bladeItems"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__bladeItems = value

    @property
    def numBlades(self) -> int:
        """Number of blades"""
        return self.__numBlades

    @numBlades.setter
    def numBlades(self, value: int):
        """Set numBlades"""
        self.__numBlades = int(value)

    @property
    def numAzimuthalElements(self) -> int:
        """Number of azimuthal elements for aerodynamic calculation"""
        return self.__numAzimuthalElements

    @numAzimuthalElements.setter
    def numAzimuthalElements(self, value: int):
        """Set numAzimuthalElements"""
        self.__numAzimuthalElements = int(value)

    @property
    def prandtlFactor(self) -> float:
        """Prandtl factor"""
        return self.__prandtlFactor

    @prandtlFactor.setter
    def prandtlFactor(self, value: float):
        """Set prandtlFactor"""
        self.__prandtlFactor = float(value)
