# This an autogenerated file
# 
# Generated with VolumeBoxItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.volumeboxitem import VolumeBoxItemBlueprint
from typing import Dict
from ..sima import Point3
from ..sima import ScriptableValue
from .volume import Volume
from .volumemassportion import VolumeMassPortion

class VolumeBoxItem(VolumeMassPortion):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    volume : Volume
         Add or subtract volume
    centerPoint : Point3
         Location of center of bottom plane in local coordinates
    lengthX : float
         Length of box i x-direction(default 0.0)
    lengthY : float
         Length of box i y-direction(default 0.0)
    lengthZ : float
         Length of box i z-direction(default 0.0)
    """

    def __init__(self , description="", volume=Volume.ADD, lengthX=0.0, lengthY=0.0, lengthZ=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.volume = volume
        self.centerPoint = None
        self.lengthX = lengthX
        self.lengthY = lengthY
        self.lengthZ = lengthZ
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return VolumeBoxItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def volume(self) -> Volume:
        """Add or subtract volume"""
        return self.__volume

    @volume.setter
    def volume(self, value: Volume):
        """Set volume"""
        self.__volume = value

    @property
    def centerPoint(self) -> Point3:
        """Location of center of bottom plane in local coordinates"""
        return self.__centerPoint

    @centerPoint.setter
    def centerPoint(self, value: Point3):
        """Set centerPoint"""
        self.__centerPoint = value

    @property
    def lengthX(self) -> float:
        """Length of box i x-direction"""
        return self.__lengthX

    @lengthX.setter
    def lengthX(self, value: float):
        """Set lengthX"""
        self.__lengthX = float(value)

    @property
    def lengthY(self) -> float:
        """Length of box i y-direction"""
        return self.__lengthY

    @lengthY.setter
    def lengthY(self, value: float):
        """Set lengthY"""
        self.__lengthY = float(value)

    @property
    def lengthZ(self) -> float:
        """Length of box i z-direction"""
        return self.__lengthZ

    @lengthZ.setter
    def lengthZ(self, value: float):
        """Set lengthZ"""
        self.__lengthZ = float(value)
