# This an autogenerated file
# 
# Generated with WamitFirstOrderWaveForceTransferFunction
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.wamitfirstorderwaveforcetransferfunction import WamitFirstOrderWaveForceTransferFunctionBlueprint
from numpy import ndarray,asarray
from ..hydro import DirectionDependentComplexValues
from ..hydro import DirectionSymmetry
from ..hydro import FirstOrderWaveForceTransferFunction
from ..sima import Named
from ..sima import ScriptableValue

class WamitFirstOrderWaveForceTransferFunction(FirstOrderWaveForceTransferFunction,Named):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray of float
    frequencies : ndarray of float
    symmetry : DirectionSymmetry
    fx : DirectionDependentComplexValues
    fy : DirectionDependentComplexValues
    fz : DirectionDependentComplexValues
    mx : DirectionDependentComplexValues
    my : DirectionDependentComplexValues
    mz : DirectionDependentComplexValues
    name : str
         (default None)
    """

    def __init__(self , description="", symmetry=DirectionSymmetry.NO_SYMMETRY, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.directions = []
        self.frequencies = []
        self.symmetry = symmetry
        self.fx = None
        self.fy = None
        self.fz = None
        self.mx = None
        self.my = None
        self.mz = None
        self.name = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WamitFirstOrderWaveForceTransferFunctionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__directions = array

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__frequencies = array

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def fx(self) -> DirectionDependentComplexValues:
        """"""
        return self.__fx

    @fx.setter
    def fx(self, value: DirectionDependentComplexValues):
        """Set fx"""
        self.__fx = value

    @property
    def fy(self) -> DirectionDependentComplexValues:
        """"""
        return self.__fy

    @fy.setter
    def fy(self, value: DirectionDependentComplexValues):
        """Set fy"""
        self.__fy = value

    @property
    def fz(self) -> DirectionDependentComplexValues:
        """"""
        return self.__fz

    @fz.setter
    def fz(self, value: DirectionDependentComplexValues):
        """Set fz"""
        self.__fz = value

    @property
    def mx(self) -> DirectionDependentComplexValues:
        """"""
        return self.__mx

    @mx.setter
    def mx(self, value: DirectionDependentComplexValues):
        """Set mx"""
        self.__mx = value

    @property
    def my(self) -> DirectionDependentComplexValues:
        """"""
        return self.__my

    @my.setter
    def my(self, value: DirectionDependentComplexValues):
        """Set my"""
        self.__my = value

    @property
    def mz(self) -> DirectionDependentComplexValues:
        """"""
        return self.__mz

    @mz.setter
    def mz(self, value: DirectionDependentComplexValues):
        """Set mz"""
        self.__mz = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value
