# This an autogenerated file
# 
# Generated with GainSchedulingItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.gainschedulingitem import GainSchedulingItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class GainSchedulingItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    rotorSpeed : float
         Rotor speed(default 0.0)
    gainCorrectionFactor : float
         Gain correction factor(default 0.0)
    """

    def __init__(self , description="", rotorSpeed=0.0, gainCorrectionFactor=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.rotorSpeed = rotorSpeed
        self.gainCorrectionFactor = gainCorrectionFactor
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GainSchedulingItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def rotorSpeed(self) -> float:
        """Rotor speed"""
        return self.__rotorSpeed

    @rotorSpeed.setter
    def rotorSpeed(self, value: float):
        """Set rotorSpeed"""
        self.__rotorSpeed = float(value)

    @property
    def gainCorrectionFactor(self) -> float:
        """Gain correction factor"""
        return self.__gainCorrectionFactor

    @gainCorrectionFactor.setter
    def gainCorrectionFactor(self, value: float):
        """Set gainCorrectionFactor"""
        self.__gainCorrectionFactor = float(value)
