#!python
# cython: language_level=3
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
cdef public bint TYPE_CHECKING = False
cdef public numpy.int32_t SIED_D = 1
cdef public numpy.int32_t SIED_L = 2
cdef public numpy.int32_t VERS = 3
cdef public numpy.int32_t ACKER = 4
cdef public numpy.int32_t WEINB = 5
cdef public numpy.int32_t OBSTB = 6
cdef public numpy.int32_t BODEN = 7
cdef public numpy.int32_t GLETS = 8
cdef public numpy.int32_t GRUE_I = 9
cdef public numpy.int32_t FEUCHT = 10
cdef public numpy.int32_t GRUE_E = 11
cdef public numpy.int32_t BAUMB = 12
cdef public numpy.int32_t NADELW = 13
cdef public numpy.int32_t LAUBW = 14
cdef public numpy.int32_t MISCHW = 15
cdef public numpy.int32_t WASSER = 16
cdef public numpy.int32_t FLUSS = 17
cdef public numpy.int32_t SEE = 18
@cython.final
cdef class Parameters:
    cdef public ControlParameters control
    cdef public DerivedParameters derived
    cdef public FixedParameters fixed
@cython.final
cdef class ControlParameters:
    cdef public double ft
    cdef public numpy.int32_t nhru
    cdef public numpy.int32_t[:] lnk
    cdef public double[:] fhru
    cdef public double[:] kg
    cdef public double[:] kt
    cdef public double p1strahl
    cdef public double p2strahl
    cdef public double[:,:] albedo
    cdef public double albedo0snow
    cdef public double snowagingfactor
    cdef public double turb0
    cdef public double turb1
    cdef public double emissivity
    cdef public double measuringheightwindspeed
    cdef public double p1wind
    cdef public double p2wind
    cdef public double[:,:] lai
    cdef public double hinz
    cdef public double[:] trefn
    cdef public double[:] tgr
    cdef public double[:] tsp
    cdef public double[:] pwmax
    cdef public numpy.int32_t refreezeflag
    cdef public double ktschnee
    cdef public double[:] wg2z
    cdef public double[:,:] cropheight
    cdef public double[:,:] surfaceresistance
    cdef public double[:] wmax
    cdef public double[:] fk
    cdef public double[:] pwp
    cdef public double[:] py
    cdef public double[:] bsf
    cdef public double fvf
    cdef public double bsff
    cdef public double[:] dmin
    cdef public double[:] dmax
    cdef public double[:] beta
    cdef public double[:] fbeta
    cdef public double[:] kapmax
    cdef public double[:,:] kapgrenz
    cdef public bint rbeta
    cdef public double volbmax
    cdef public double gsbmax
    cdef public double gsbgrad1
    cdef public double gsbgrad2
    cdef public double a1
    cdef public double a2
    cdef public double tind
    cdef public double eqb
    cdef public double eqi1
    cdef public double eqi2
    cdef public double eqd1
    cdef public double eqd2
    cdef public bint negq
@cython.final
cdef class DerivedParameters:
    cdef public numpy.int32_t[:] moy
    cdef public double seconds
    cdef public double hours
    cdef public double days
    cdef public numpy.int32_t nmblogentries
    cdef public double[:] absfhru
    cdef public double[:,:] kinz
    cdef public double[:] heatoffusion
    cdef public double[:,:] fr
    cdef public double[:] nfk
    cdef public double kb
    cdef public double ki1
    cdef public double ki2
    cdef public double kd1
    cdef public double kd2
    cdef public double qbgamax
    cdef public double qfactor
@cython.final
cdef class FixedParameters:
    cdef public double cpwasser
    cdef public double cpeis
    cdef public double rschmelz
    cdef public double z
    cdef public double[:] bowa2z
    cdef public double lambdag
    cdef public double sigma
    cdef public double rdryair
    cdef public double rwatervapour
    cdef public double lw
    cdef public double lwe
    cdef public double cpluft
    cdef public double psy
    cdef public double psyinv
    cdef public double z0
    cdef public double fratm
    cdef public double cg
@cython.final
cdef class Sequences:
    cdef public InletSequences inlets
    cdef public InputSequences inputs
    cdef public FluxSequences fluxes
    cdef public StateSequences states
    cdef public LogSequences logs
    cdef public AideSequences aides
    cdef public OutletSequences outlets
    cdef public StateSequences old_states
    cdef public StateSequences new_states
@cython.final
cdef class InletSequences:
    cdef double **q
    cdef public int len_q
    cdef public numpy.int32_t[:] _q_ready
    cdef public int _q_ndim
    cdef public int _q_length
    cdef public int _q_length_0
    cpdef inline alloc(self, name, numpy.int32_t length):
        if name == "q":
            self._q_length_0 = length
            self._q_ready = numpy.full(length, 0, dtype=numpy.int32)
            self.q = <double**> PyMem_Malloc(length * sizeof(double*))
    cpdef inline dealloc(self, name):
        if name == "q":
            PyMem_Free(self.q)
    cpdef inline set_pointer1d(self, str name, pointerutils.Double value, int idx):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self.q[idx] = pointer.p_value
            self._q_ready[idx] = 1
    cpdef get_value(self, str name):
        cdef int idx
        if name == "q":
            values = numpy.empty(self.len_q)
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                values[idx] = self.q[idx][0]
            return values
    cpdef set_value(self, str name, value):
        if name == "q":
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                self.q[idx][0] = value[idx]
@cython.final
cdef class InputSequences:
    cdef public double nied
    cdef public int _nied_ndim
    cdef public int _nied_length
    cdef public bint _nied_ramflag
    cdef public double[:] _nied_array
    cdef public bint _nied_diskflag_reading
    cdef public bint _nied_diskflag_writing
    cdef public double[:] _nied_ncarray
    cdef public bint _nied_inputflag
    cdef double *_nied_inputpointer
    cdef public double teml
    cdef public int _teml_ndim
    cdef public int _teml_length
    cdef public bint _teml_ramflag
    cdef public double[:] _teml_array
    cdef public bint _teml_diskflag_reading
    cdef public bint _teml_diskflag_writing
    cdef public double[:] _teml_ncarray
    cdef public bint _teml_inputflag
    cdef double *_teml_inputpointer
    cdef public double sunshineduration
    cdef public int _sunshineduration_ndim
    cdef public int _sunshineduration_length
    cdef public bint _sunshineduration_ramflag
    cdef public double[:] _sunshineduration_array
    cdef public bint _sunshineduration_diskflag_reading
    cdef public bint _sunshineduration_diskflag_writing
    cdef public double[:] _sunshineduration_ncarray
    cdef public bint _sunshineduration_inputflag
    cdef double *_sunshineduration_inputpointer
    cdef public double possiblesunshineduration
    cdef public int _possiblesunshineduration_ndim
    cdef public int _possiblesunshineduration_length
    cdef public bint _possiblesunshineduration_ramflag
    cdef public double[:] _possiblesunshineduration_array
    cdef public bint _possiblesunshineduration_diskflag_reading
    cdef public bint _possiblesunshineduration_diskflag_writing
    cdef public double[:] _possiblesunshineduration_ncarray
    cdef public bint _possiblesunshineduration_inputflag
    cdef double *_possiblesunshineduration_inputpointer
    cdef public double globalradiation
    cdef public int _globalradiation_ndim
    cdef public int _globalradiation_length
    cdef public bint _globalradiation_ramflag
    cdef public double[:] _globalradiation_array
    cdef public bint _globalradiation_diskflag_reading
    cdef public bint _globalradiation_diskflag_writing
    cdef public double[:] _globalradiation_ncarray
    cdef public bint _globalradiation_inputflag
    cdef double *_globalradiation_inputpointer
    cdef public double relativehumidity
    cdef public int _relativehumidity_ndim
    cdef public int _relativehumidity_length
    cdef public bint _relativehumidity_ramflag
    cdef public double[:] _relativehumidity_array
    cdef public bint _relativehumidity_diskflag_reading
    cdef public bint _relativehumidity_diskflag_writing
    cdef public double[:] _relativehumidity_ncarray
    cdef public bint _relativehumidity_inputflag
    cdef double *_relativehumidity_inputpointer
    cdef public double windspeed
    cdef public int _windspeed_ndim
    cdef public int _windspeed_length
    cdef public bint _windspeed_ramflag
    cdef public double[:] _windspeed_array
    cdef public bint _windspeed_diskflag_reading
    cdef public bint _windspeed_diskflag_writing
    cdef public double[:] _windspeed_ncarray
    cdef public bint _windspeed_inputflag
    cdef double *_windspeed_inputpointer
    cdef public double atmosphericpressure
    cdef public int _atmosphericpressure_ndim
    cdef public int _atmosphericpressure_length
    cdef public bint _atmosphericpressure_ramflag
    cdef public double[:] _atmosphericpressure_array
    cdef public bint _atmosphericpressure_diskflag_reading
    cdef public bint _atmosphericpressure_diskflag_writing
    cdef public double[:] _atmosphericpressure_ncarray
    cdef public bint _atmosphericpressure_inputflag
    cdef double *_atmosphericpressure_inputpointer
    cpdef inline void load_data(self, int idx)  nogil:
        cdef int k
        if self._nied_inputflag:
            self.nied = self._nied_inputpointer[0]
        elif self._nied_diskflag_reading:
            self.nied = self._nied_ncarray[0]
        elif self._nied_ramflag:
            self.nied = self._nied_array[idx]
        if self._teml_inputflag:
            self.teml = self._teml_inputpointer[0]
        elif self._teml_diskflag_reading:
            self.teml = self._teml_ncarray[0]
        elif self._teml_ramflag:
            self.teml = self._teml_array[idx]
        if self._sunshineduration_inputflag:
            self.sunshineduration = self._sunshineduration_inputpointer[0]
        elif self._sunshineduration_diskflag_reading:
            self.sunshineduration = self._sunshineduration_ncarray[0]
        elif self._sunshineduration_ramflag:
            self.sunshineduration = self._sunshineduration_array[idx]
        if self._possiblesunshineduration_inputflag:
            self.possiblesunshineduration = self._possiblesunshineduration_inputpointer[0]
        elif self._possiblesunshineduration_diskflag_reading:
            self.possiblesunshineduration = self._possiblesunshineduration_ncarray[0]
        elif self._possiblesunshineduration_ramflag:
            self.possiblesunshineduration = self._possiblesunshineduration_array[idx]
        if self._globalradiation_inputflag:
            self.globalradiation = self._globalradiation_inputpointer[0]
        elif self._globalradiation_diskflag_reading:
            self.globalradiation = self._globalradiation_ncarray[0]
        elif self._globalradiation_ramflag:
            self.globalradiation = self._globalradiation_array[idx]
        if self._relativehumidity_inputflag:
            self.relativehumidity = self._relativehumidity_inputpointer[0]
        elif self._relativehumidity_diskflag_reading:
            self.relativehumidity = self._relativehumidity_ncarray[0]
        elif self._relativehumidity_ramflag:
            self.relativehumidity = self._relativehumidity_array[idx]
        if self._windspeed_inputflag:
            self.windspeed = self._windspeed_inputpointer[0]
        elif self._windspeed_diskflag_reading:
            self.windspeed = self._windspeed_ncarray[0]
        elif self._windspeed_ramflag:
            self.windspeed = self._windspeed_array[idx]
        if self._atmosphericpressure_inputflag:
            self.atmosphericpressure = self._atmosphericpressure_inputpointer[0]
        elif self._atmosphericpressure_diskflag_reading:
            self.atmosphericpressure = self._atmosphericpressure_ncarray[0]
        elif self._atmosphericpressure_ramflag:
            self.atmosphericpressure = self._atmosphericpressure_array[idx]
    cpdef inline void save_data(self, int idx)  nogil:
        cdef int k
        if self._nied_diskflag_writing:
            self._nied_ncarray[0] = self.nied
        if self._nied_ramflag:
            self._nied_array[idx] = self.nied
        if self._teml_diskflag_writing:
            self._teml_ncarray[0] = self.teml
        if self._teml_ramflag:
            self._teml_array[idx] = self.teml
        if self._sunshineduration_diskflag_writing:
            self._sunshineduration_ncarray[0] = self.sunshineduration
        if self._sunshineduration_ramflag:
            self._sunshineduration_array[idx] = self.sunshineduration
        if self._possiblesunshineduration_diskflag_writing:
            self._possiblesunshineduration_ncarray[0] = self.possiblesunshineduration
        if self._possiblesunshineduration_ramflag:
            self._possiblesunshineduration_array[idx] = self.possiblesunshineduration
        if self._globalradiation_diskflag_writing:
            self._globalradiation_ncarray[0] = self.globalradiation
        if self._globalradiation_ramflag:
            self._globalradiation_array[idx] = self.globalradiation
        if self._relativehumidity_diskflag_writing:
            self._relativehumidity_ncarray[0] = self.relativehumidity
        if self._relativehumidity_ramflag:
            self._relativehumidity_array[idx] = self.relativehumidity
        if self._windspeed_diskflag_writing:
            self._windspeed_ncarray[0] = self.windspeed
        if self._windspeed_ramflag:
            self._windspeed_array[idx] = self.windspeed
        if self._atmosphericpressure_diskflag_writing:
            self._atmosphericpressure_ncarray[0] = self.atmosphericpressure
        if self._atmosphericpressure_ramflag:
            self._atmosphericpressure_array[idx] = self.atmosphericpressure
    cpdef inline set_pointerinput(self, str name, pointerutils.PDouble value):
        if name == "nied":
            self._nied_inputpointer = value.p_value
        if name == "teml":
            self._teml_inputpointer = value.p_value
        if name == "sunshineduration":
            self._sunshineduration_inputpointer = value.p_value
        if name == "possiblesunshineduration":
            self._possiblesunshineduration_inputpointer = value.p_value
        if name == "globalradiation":
            self._globalradiation_inputpointer = value.p_value
        if name == "relativehumidity":
            self._relativehumidity_inputpointer = value.p_value
        if name == "windspeed":
            self._windspeed_inputpointer = value.p_value
        if name == "atmosphericpressure":
            self._atmosphericpressure_inputpointer = value.p_value
@cython.final
cdef class FluxSequences:
    cdef public double qz
    cdef public int _qz_ndim
    cdef public int _qz_length
    cdef public bint _qz_ramflag
    cdef public double[:] _qz_array
    cdef public bint _qz_diskflag_reading
    cdef public bint _qz_diskflag_writing
    cdef public double[:] _qz_ncarray
    cdef public bint _qz_outputflag
    cdef double *_qz_outputpointer
    cdef public double qzh
    cdef public int _qzh_ndim
    cdef public int _qzh_length
    cdef public bint _qzh_ramflag
    cdef public double[:] _qzh_array
    cdef public bint _qzh_diskflag_reading
    cdef public bint _qzh_diskflag_writing
    cdef public double[:] _qzh_ncarray
    cdef public bint _qzh_outputflag
    cdef double *_qzh_outputpointer
    cdef public double temltag
    cdef public int _temltag_ndim
    cdef public int _temltag_length
    cdef public bint _temltag_ramflag
    cdef public double[:] _temltag_array
    cdef public bint _temltag_diskflag_reading
    cdef public bint _temltag_diskflag_writing
    cdef public double[:] _temltag_ncarray
    cdef public bint _temltag_outputflag
    cdef double *_temltag_outputpointer
    cdef public double dailyrelativehumidity
    cdef public int _dailyrelativehumidity_ndim
    cdef public int _dailyrelativehumidity_length
    cdef public bint _dailyrelativehumidity_ramflag
    cdef public double[:] _dailyrelativehumidity_array
    cdef public bint _dailyrelativehumidity_diskflag_reading
    cdef public bint _dailyrelativehumidity_diskflag_writing
    cdef public double[:] _dailyrelativehumidity_ncarray
    cdef public bint _dailyrelativehumidity_outputflag
    cdef double *_dailyrelativehumidity_outputpointer
    cdef public double dailysunshineduration
    cdef public int _dailysunshineduration_ndim
    cdef public int _dailysunshineduration_length
    cdef public bint _dailysunshineduration_ramflag
    cdef public double[:] _dailysunshineduration_array
    cdef public bint _dailysunshineduration_diskflag_reading
    cdef public bint _dailysunshineduration_diskflag_writing
    cdef public double[:] _dailysunshineduration_ncarray
    cdef public bint _dailysunshineduration_outputflag
    cdef double *_dailysunshineduration_outputpointer
    cdef public double dailypossiblesunshineduration
    cdef public int _dailypossiblesunshineduration_ndim
    cdef public int _dailypossiblesunshineduration_length
    cdef public bint _dailypossiblesunshineduration_ramflag
    cdef public double[:] _dailypossiblesunshineduration_array
    cdef public bint _dailypossiblesunshineduration_diskflag_reading
    cdef public bint _dailypossiblesunshineduration_diskflag_writing
    cdef public double[:] _dailypossiblesunshineduration_ncarray
    cdef public bint _dailypossiblesunshineduration_outputflag
    cdef double *_dailypossiblesunshineduration_outputpointer
    cdef public double dailyglobalradiation
    cdef public int _dailyglobalradiation_ndim
    cdef public int _dailyglobalradiation_length
    cdef public bint _dailyglobalradiation_ramflag
    cdef public double[:] _dailyglobalradiation_array
    cdef public bint _dailyglobalradiation_diskflag_reading
    cdef public bint _dailyglobalradiation_diskflag_writing
    cdef public double[:] _dailyglobalradiation_ncarray
    cdef public bint _dailyglobalradiation_outputflag
    cdef double *_dailyglobalradiation_outputpointer
    cdef public double[:] nkor
    cdef public int _nkor_ndim
    cdef public int _nkor_length
    cdef public int _nkor_length_0
    cdef public bint _nkor_ramflag
    cdef public double[:,:] _nkor_array
    cdef public bint _nkor_diskflag_reading
    cdef public bint _nkor_diskflag_writing
    cdef public double[:] _nkor_ncarray
    cdef public bint _nkor_outputflag
    cdef double *_nkor_outputpointer
    cdef public double[:] tkor
    cdef public int _tkor_ndim
    cdef public int _tkor_length
    cdef public int _tkor_length_0
    cdef public bint _tkor_ramflag
    cdef public double[:,:] _tkor_array
    cdef public bint _tkor_diskflag_reading
    cdef public bint _tkor_diskflag_writing
    cdef public double[:] _tkor_ncarray
    cdef public bint _tkor_outputflag
    cdef double *_tkor_outputpointer
    cdef public double[:] tkortag
    cdef public int _tkortag_ndim
    cdef public int _tkortag_length
    cdef public int _tkortag_length_0
    cdef public bint _tkortag_ramflag
    cdef public double[:,:] _tkortag_array
    cdef public bint _tkortag_diskflag_reading
    cdef public bint _tkortag_diskflag_writing
    cdef public double[:] _tkortag_ncarray
    cdef public bint _tkortag_outputflag
    cdef double *_tkortag_outputpointer
    cdef public double windspeed2m
    cdef public int _windspeed2m_ndim
    cdef public int _windspeed2m_length
    cdef public bint _windspeed2m_ramflag
    cdef public double[:] _windspeed2m_array
    cdef public bint _windspeed2m_diskflag_reading
    cdef public bint _windspeed2m_diskflag_writing
    cdef public double[:] _windspeed2m_ncarray
    cdef public bint _windspeed2m_outputflag
    cdef double *_windspeed2m_outputpointer
    cdef public double dailywindspeed2m
    cdef public int _dailywindspeed2m_ndim
    cdef public int _dailywindspeed2m_length
    cdef public bint _dailywindspeed2m_ramflag
    cdef public double[:] _dailywindspeed2m_array
    cdef public bint _dailywindspeed2m_diskflag_reading
    cdef public bint _dailywindspeed2m_diskflag_writing
    cdef public double[:] _dailywindspeed2m_ncarray
    cdef public bint _dailywindspeed2m_outputflag
    cdef double *_dailywindspeed2m_outputpointer
    cdef public double[:] reducedwindspeed2m
    cdef public int _reducedwindspeed2m_ndim
    cdef public int _reducedwindspeed2m_length
    cdef public int _reducedwindspeed2m_length_0
    cdef public bint _reducedwindspeed2m_ramflag
    cdef public double[:,:] _reducedwindspeed2m_array
    cdef public bint _reducedwindspeed2m_diskflag_reading
    cdef public bint _reducedwindspeed2m_diskflag_writing
    cdef public double[:] _reducedwindspeed2m_ncarray
    cdef public bint _reducedwindspeed2m_outputflag
    cdef double *_reducedwindspeed2m_outputpointer
    cdef public double windspeed10m
    cdef public int _windspeed10m_ndim
    cdef public int _windspeed10m_length
    cdef public bint _windspeed10m_ramflag
    cdef public double[:] _windspeed10m_array
    cdef public bint _windspeed10m_diskflag_reading
    cdef public bint _windspeed10m_diskflag_writing
    cdef public double[:] _windspeed10m_ncarray
    cdef public bint _windspeed10m_outputflag
    cdef double *_windspeed10m_outputpointer
    cdef public double[:] saturationvapourpressure
    cdef public int _saturationvapourpressure_ndim
    cdef public int _saturationvapourpressure_length
    cdef public int _saturationvapourpressure_length_0
    cdef public bint _saturationvapourpressure_ramflag
    cdef public double[:,:] _saturationvapourpressure_array
    cdef public bint _saturationvapourpressure_diskflag_reading
    cdef public bint _saturationvapourpressure_diskflag_writing
    cdef public double[:] _saturationvapourpressure_ncarray
    cdef public bint _saturationvapourpressure_outputflag
    cdef double *_saturationvapourpressure_outputpointer
    cdef public double[:] dailysaturationvapourpressure
    cdef public int _dailysaturationvapourpressure_ndim
    cdef public int _dailysaturationvapourpressure_length
    cdef public int _dailysaturationvapourpressure_length_0
    cdef public bint _dailysaturationvapourpressure_ramflag
    cdef public double[:,:] _dailysaturationvapourpressure_array
    cdef public bint _dailysaturationvapourpressure_diskflag_reading
    cdef public bint _dailysaturationvapourpressure_diskflag_writing
    cdef public double[:] _dailysaturationvapourpressure_ncarray
    cdef public bint _dailysaturationvapourpressure_outputflag
    cdef double *_dailysaturationvapourpressure_outputpointer
    cdef public double[:] saturationvapourpressuresnow
    cdef public int _saturationvapourpressuresnow_ndim
    cdef public int _saturationvapourpressuresnow_length
    cdef public int _saturationvapourpressuresnow_length_0
    cdef public bint _saturationvapourpressuresnow_ramflag
    cdef public double[:,:] _saturationvapourpressuresnow_array
    cdef public bint _saturationvapourpressuresnow_diskflag_reading
    cdef public bint _saturationvapourpressuresnow_diskflag_writing
    cdef public double[:] _saturationvapourpressuresnow_ncarray
    cdef public bint _saturationvapourpressuresnow_outputflag
    cdef double *_saturationvapourpressuresnow_outputpointer
    cdef public double[:] saturationvapourpressureslope
    cdef public int _saturationvapourpressureslope_ndim
    cdef public int _saturationvapourpressureslope_length
    cdef public int _saturationvapourpressureslope_length_0
    cdef public bint _saturationvapourpressureslope_ramflag
    cdef public double[:,:] _saturationvapourpressureslope_array
    cdef public bint _saturationvapourpressureslope_diskflag_reading
    cdef public bint _saturationvapourpressureslope_diskflag_writing
    cdef public double[:] _saturationvapourpressureslope_ncarray
    cdef public bint _saturationvapourpressureslope_outputflag
    cdef double *_saturationvapourpressureslope_outputpointer
    cdef public double[:] dailysaturationvapourpressureslope
    cdef public int _dailysaturationvapourpressureslope_ndim
    cdef public int _dailysaturationvapourpressureslope_length
    cdef public int _dailysaturationvapourpressureslope_length_0
    cdef public bint _dailysaturationvapourpressureslope_ramflag
    cdef public double[:,:] _dailysaturationvapourpressureslope_array
    cdef public bint _dailysaturationvapourpressureslope_diskflag_reading
    cdef public bint _dailysaturationvapourpressureslope_diskflag_writing
    cdef public double[:] _dailysaturationvapourpressureslope_ncarray
    cdef public bint _dailysaturationvapourpressureslope_outputflag
    cdef double *_dailysaturationvapourpressureslope_outputpointer
    cdef public double[:] actualvapourpressure
    cdef public int _actualvapourpressure_ndim
    cdef public int _actualvapourpressure_length
    cdef public int _actualvapourpressure_length_0
    cdef public bint _actualvapourpressure_ramflag
    cdef public double[:,:] _actualvapourpressure_array
    cdef public bint _actualvapourpressure_diskflag_reading
    cdef public bint _actualvapourpressure_diskflag_writing
    cdef public double[:] _actualvapourpressure_ncarray
    cdef public bint _actualvapourpressure_outputflag
    cdef double *_actualvapourpressure_outputpointer
    cdef public double[:] dailyactualvapourpressure
    cdef public int _dailyactualvapourpressure_ndim
    cdef public int _dailyactualvapourpressure_length
    cdef public int _dailyactualvapourpressure_length_0
    cdef public bint _dailyactualvapourpressure_ramflag
    cdef public double[:,:] _dailyactualvapourpressure_array
    cdef public bint _dailyactualvapourpressure_diskflag_reading
    cdef public bint _dailyactualvapourpressure_diskflag_writing
    cdef public double[:] _dailyactualvapourpressure_ncarray
    cdef public bint _dailyactualvapourpressure_outputflag
    cdef double *_dailyactualvapourpressure_outputpointer
    cdef public double[:] dryairpressure
    cdef public int _dryairpressure_ndim
    cdef public int _dryairpressure_length
    cdef public int _dryairpressure_length_0
    cdef public bint _dryairpressure_ramflag
    cdef public double[:,:] _dryairpressure_array
    cdef public bint _dryairpressure_diskflag_reading
    cdef public bint _dryairpressure_diskflag_writing
    cdef public double[:] _dryairpressure_ncarray
    cdef public bint _dryairpressure_outputflag
    cdef double *_dryairpressure_outputpointer
    cdef public double[:] densityair
    cdef public int _densityair_ndim
    cdef public int _densityair_length
    cdef public int _densityair_length_0
    cdef public bint _densityair_ramflag
    cdef public double[:,:] _densityair_array
    cdef public bint _densityair_diskflag_reading
    cdef public bint _densityair_diskflag_writing
    cdef public double[:] _densityair_ncarray
    cdef public bint _densityair_outputflag
    cdef double *_densityair_outputpointer
    cdef public double[:] g
    cdef public int _g_ndim
    cdef public int _g_length
    cdef public int _g_length_0
    cdef public bint _g_ramflag
    cdef public double[:,:] _g_array
    cdef public bint _g_diskflag_reading
    cdef public bint _g_diskflag_writing
    cdef public double[:] _g_ncarray
    cdef public bint _g_outputflag
    cdef double *_g_outputpointer
    cdef public double[:] tz
    cdef public int _tz_ndim
    cdef public int _tz_length
    cdef public int _tz_length_0
    cdef public bint _tz_ramflag
    cdef public double[:,:] _tz_array
    cdef public bint _tz_diskflag_reading
    cdef public bint _tz_diskflag_writing
    cdef public double[:] _tz_ncarray
    cdef public bint _tz_outputflag
    cdef double *_tz_outputpointer
    cdef public double[:] wg
    cdef public int _wg_ndim
    cdef public int _wg_length
    cdef public int _wg_length_0
    cdef public bint _wg_ramflag
    cdef public double[:,:] _wg_array
    cdef public bint _wg_diskflag_reading
    cdef public bint _wg_diskflag_writing
    cdef public double[:] _wg_ncarray
    cdef public bint _wg_outputflag
    cdef double *_wg_outputpointer
    cdef public double[:] netshortwaveradiation
    cdef public int _netshortwaveradiation_ndim
    cdef public int _netshortwaveradiation_length
    cdef public int _netshortwaveradiation_length_0
    cdef public bint _netshortwaveradiation_ramflag
    cdef public double[:,:] _netshortwaveradiation_array
    cdef public bint _netshortwaveradiation_diskflag_reading
    cdef public bint _netshortwaveradiation_diskflag_writing
    cdef public double[:] _netshortwaveradiation_ncarray
    cdef public bint _netshortwaveradiation_outputflag
    cdef double *_netshortwaveradiation_outputpointer
    cdef public double[:] netshortwaveradiationsnow
    cdef public int _netshortwaveradiationsnow_ndim
    cdef public int _netshortwaveradiationsnow_length
    cdef public int _netshortwaveradiationsnow_length_0
    cdef public bint _netshortwaveradiationsnow_ramflag
    cdef public double[:,:] _netshortwaveradiationsnow_array
    cdef public bint _netshortwaveradiationsnow_diskflag_reading
    cdef public bint _netshortwaveradiationsnow_diskflag_writing
    cdef public double[:] _netshortwaveradiationsnow_ncarray
    cdef public bint _netshortwaveradiationsnow_outputflag
    cdef double *_netshortwaveradiationsnow_outputpointer
    cdef public double[:] dailynetshortwaveradiation
    cdef public int _dailynetshortwaveradiation_ndim
    cdef public int _dailynetshortwaveradiation_length
    cdef public int _dailynetshortwaveradiation_length_0
    cdef public bint _dailynetshortwaveradiation_ramflag
    cdef public double[:,:] _dailynetshortwaveradiation_array
    cdef public bint _dailynetshortwaveradiation_diskflag_reading
    cdef public bint _dailynetshortwaveradiation_diskflag_writing
    cdef public double[:] _dailynetshortwaveradiation_ncarray
    cdef public bint _dailynetshortwaveradiation_outputflag
    cdef double *_dailynetshortwaveradiation_outputpointer
    cdef public double[:] dailynetlongwaveradiation
    cdef public int _dailynetlongwaveradiation_ndim
    cdef public int _dailynetlongwaveradiation_length
    cdef public int _dailynetlongwaveradiation_length_0
    cdef public bint _dailynetlongwaveradiation_ramflag
    cdef public double[:,:] _dailynetlongwaveradiation_array
    cdef public bint _dailynetlongwaveradiation_diskflag_reading
    cdef public bint _dailynetlongwaveradiation_diskflag_writing
    cdef public double[:] _dailynetlongwaveradiation_ncarray
    cdef public bint _dailynetlongwaveradiation_outputflag
    cdef double *_dailynetlongwaveradiation_outputpointer
    cdef public double[:] netlongwaveradiationsnow
    cdef public int _netlongwaveradiationsnow_ndim
    cdef public int _netlongwaveradiationsnow_length
    cdef public int _netlongwaveradiationsnow_length_0
    cdef public bint _netlongwaveradiationsnow_ramflag
    cdef public double[:,:] _netlongwaveradiationsnow_array
    cdef public bint _netlongwaveradiationsnow_diskflag_reading
    cdef public bint _netlongwaveradiationsnow_diskflag_writing
    cdef public double[:] _netlongwaveradiationsnow_ncarray
    cdef public bint _netlongwaveradiationsnow_outputflag
    cdef double *_netlongwaveradiationsnow_outputpointer
    cdef public double[:] netradiation
    cdef public int _netradiation_ndim
    cdef public int _netradiation_length
    cdef public int _netradiation_length_0
    cdef public bint _netradiation_ramflag
    cdef public double[:,:] _netradiation_array
    cdef public bint _netradiation_diskflag_reading
    cdef public bint _netradiation_diskflag_writing
    cdef public double[:] _netradiation_ncarray
    cdef public bint _netradiation_outputflag
    cdef double *_netradiation_outputpointer
    cdef public double[:] netradiationsnow
    cdef public int _netradiationsnow_ndim
    cdef public int _netradiationsnow_length
    cdef public int _netradiationsnow_length_0
    cdef public bint _netradiationsnow_ramflag
    cdef public double[:,:] _netradiationsnow_array
    cdef public bint _netradiationsnow_diskflag_reading
    cdef public bint _netradiationsnow_diskflag_writing
    cdef public double[:] _netradiationsnow_ncarray
    cdef public bint _netradiationsnow_outputflag
    cdef double *_netradiationsnow_outputpointer
    cdef public double[:] dailynetradiation
    cdef public int _dailynetradiation_ndim
    cdef public int _dailynetradiation_length
    cdef public int _dailynetradiation_length_0
    cdef public bint _dailynetradiation_ramflag
    cdef public double[:,:] _dailynetradiation_array
    cdef public bint _dailynetradiation_diskflag_reading
    cdef public bint _dailynetradiation_diskflag_writing
    cdef public double[:] _dailynetradiation_ncarray
    cdef public bint _dailynetradiation_outputflag
    cdef double *_dailynetradiation_outputpointer
    cdef public double[:] aerodynamicresistance
    cdef public int _aerodynamicresistance_ndim
    cdef public int _aerodynamicresistance_length
    cdef public int _aerodynamicresistance_length_0
    cdef public bint _aerodynamicresistance_ramflag
    cdef public double[:,:] _aerodynamicresistance_array
    cdef public bint _aerodynamicresistance_diskflag_reading
    cdef public bint _aerodynamicresistance_diskflag_writing
    cdef public double[:] _aerodynamicresistance_ncarray
    cdef public bint _aerodynamicresistance_outputflag
    cdef double *_aerodynamicresistance_outputpointer
    cdef public double[:] soilsurfaceresistance
    cdef public int _soilsurfaceresistance_ndim
    cdef public int _soilsurfaceresistance_length
    cdef public int _soilsurfaceresistance_length_0
    cdef public bint _soilsurfaceresistance_ramflag
    cdef public double[:,:] _soilsurfaceresistance_array
    cdef public bint _soilsurfaceresistance_diskflag_reading
    cdef public bint _soilsurfaceresistance_diskflag_writing
    cdef public double[:] _soilsurfaceresistance_ncarray
    cdef public bint _soilsurfaceresistance_outputflag
    cdef double *_soilsurfaceresistance_outputpointer
    cdef public double[:] landusesurfaceresistance
    cdef public int _landusesurfaceresistance_ndim
    cdef public int _landusesurfaceresistance_length
    cdef public int _landusesurfaceresistance_length_0
    cdef public bint _landusesurfaceresistance_ramflag
    cdef public double[:,:] _landusesurfaceresistance_array
    cdef public bint _landusesurfaceresistance_diskflag_reading
    cdef public bint _landusesurfaceresistance_diskflag_writing
    cdef public double[:] _landusesurfaceresistance_ncarray
    cdef public bint _landusesurfaceresistance_outputflag
    cdef double *_landusesurfaceresistance_outputpointer
    cdef public double[:] actualsurfaceresistance
    cdef public int _actualsurfaceresistance_ndim
    cdef public int _actualsurfaceresistance_length
    cdef public int _actualsurfaceresistance_length_0
    cdef public bint _actualsurfaceresistance_ramflag
    cdef public double[:,:] _actualsurfaceresistance_array
    cdef public bint _actualsurfaceresistance_diskflag_reading
    cdef public bint _actualsurfaceresistance_diskflag_writing
    cdef public double[:] _actualsurfaceresistance_ncarray
    cdef public bint _actualsurfaceresistance_outputflag
    cdef double *_actualsurfaceresistance_outputpointer
    cdef public double[:] nbes
    cdef public int _nbes_ndim
    cdef public int _nbes_length
    cdef public int _nbes_length_0
    cdef public bint _nbes_ramflag
    cdef public double[:,:] _nbes_array
    cdef public bint _nbes_diskflag_reading
    cdef public bint _nbes_diskflag_writing
    cdef public double[:] _nbes_ncarray
    cdef public bint _nbes_outputflag
    cdef double *_nbes_outputpointer
    cdef public double[:] sbes
    cdef public int _sbes_ndim
    cdef public int _sbes_length
    cdef public int _sbes_length_0
    cdef public bint _sbes_ramflag
    cdef public double[:,:] _sbes_array
    cdef public bint _sbes_diskflag_reading
    cdef public bint _sbes_diskflag_writing
    cdef public double[:] _sbes_ncarray
    cdef public bint _sbes_outputflag
    cdef double *_sbes_outputpointer
    cdef public double[:] evpo
    cdef public int _evpo_ndim
    cdef public int _evpo_length
    cdef public int _evpo_length_0
    cdef public bint _evpo_ramflag
    cdef public double[:,:] _evpo_array
    cdef public bint _evpo_diskflag_reading
    cdef public bint _evpo_diskflag_writing
    cdef public double[:] _evpo_ncarray
    cdef public bint _evpo_outputflag
    cdef double *_evpo_outputpointer
    cdef public double[:] evi
    cdef public int _evi_ndim
    cdef public int _evi_length
    cdef public int _evi_length_0
    cdef public bint _evi_ramflag
    cdef public double[:,:] _evi_array
    cdef public bint _evi_diskflag_reading
    cdef public bint _evi_diskflag_writing
    cdef public double[:] _evi_ncarray
    cdef public bint _evi_outputflag
    cdef double *_evi_outputpointer
    cdef public double[:] evb
    cdef public int _evb_ndim
    cdef public int _evb_length
    cdef public int _evb_length_0
    cdef public bint _evb_ramflag
    cdef public double[:,:] _evb_array
    cdef public bint _evb_diskflag_reading
    cdef public bint _evb_diskflag_writing
    cdef public double[:] _evb_ncarray
    cdef public bint _evb_outputflag
    cdef double *_evb_outputpointer
    cdef public double[:] evs
    cdef public int _evs_ndim
    cdef public int _evs_length
    cdef public int _evs_length_0
    cdef public bint _evs_ramflag
    cdef public double[:,:] _evs_array
    cdef public bint _evs_diskflag_reading
    cdef public bint _evs_diskflag_writing
    cdef public double[:] _evs_ncarray
    cdef public bint _evs_outputflag
    cdef double *_evs_outputpointer
    cdef public double[:] wnied
    cdef public int _wnied_ndim
    cdef public int _wnied_length
    cdef public int _wnied_length_0
    cdef public bint _wnied_ramflag
    cdef public double[:,:] _wnied_array
    cdef public bint _wnied_diskflag_reading
    cdef public bint _wnied_diskflag_writing
    cdef public double[:] _wnied_ncarray
    cdef public bint _wnied_outputflag
    cdef double *_wnied_outputpointer
    cdef public double[:] tempssurface
    cdef public int _tempssurface_ndim
    cdef public int _tempssurface_length
    cdef public int _tempssurface_length_0
    cdef public bint _tempssurface_ramflag
    cdef public double[:,:] _tempssurface_array
    cdef public bint _tempssurface_diskflag_reading
    cdef public bint _tempssurface_diskflag_writing
    cdef public double[:] _tempssurface_ncarray
    cdef public bint _tempssurface_outputflag
    cdef double *_tempssurface_outputpointer
    cdef public double[:] actualalbedo
    cdef public int _actualalbedo_ndim
    cdef public int _actualalbedo_length
    cdef public int _actualalbedo_length_0
    cdef public bint _actualalbedo_ramflag
    cdef public double[:,:] _actualalbedo_array
    cdef public bint _actualalbedo_diskflag_reading
    cdef public bint _actualalbedo_diskflag_writing
    cdef public double[:] _actualalbedo_ncarray
    cdef public bint _actualalbedo_outputflag
    cdef double *_actualalbedo_outputpointer
    cdef public double[:] schmpot
    cdef public int _schmpot_ndim
    cdef public int _schmpot_length
    cdef public int _schmpot_length_0
    cdef public bint _schmpot_ramflag
    cdef public double[:,:] _schmpot_array
    cdef public bint _schmpot_diskflag_reading
    cdef public bint _schmpot_diskflag_writing
    cdef public double[:] _schmpot_ncarray
    cdef public bint _schmpot_outputflag
    cdef double *_schmpot_outputpointer
    cdef public double[:] schm
    cdef public int _schm_ndim
    cdef public int _schm_length
    cdef public int _schm_length_0
    cdef public bint _schm_ramflag
    cdef public double[:,:] _schm_array
    cdef public bint _schm_diskflag_reading
    cdef public bint _schm_diskflag_writing
    cdef public double[:] _schm_ncarray
    cdef public bint _schm_outputflag
    cdef double *_schm_outputpointer
    cdef public double[:] gefrpot
    cdef public int _gefrpot_ndim
    cdef public int _gefrpot_length
    cdef public int _gefrpot_length_0
    cdef public bint _gefrpot_ramflag
    cdef public double[:,:] _gefrpot_array
    cdef public bint _gefrpot_diskflag_reading
    cdef public bint _gefrpot_diskflag_writing
    cdef public double[:] _gefrpot_ncarray
    cdef public bint _gefrpot_outputflag
    cdef double *_gefrpot_outputpointer
    cdef public double[:] gefr
    cdef public int _gefr_ndim
    cdef public int _gefr_length
    cdef public int _gefr_length_0
    cdef public bint _gefr_ramflag
    cdef public double[:,:] _gefr_array
    cdef public bint _gefr_diskflag_reading
    cdef public bint _gefr_diskflag_writing
    cdef public double[:] _gefr_ncarray
    cdef public bint _gefr_outputflag
    cdef double *_gefr_outputpointer
    cdef public double[:] wlatsnow
    cdef public int _wlatsnow_ndim
    cdef public int _wlatsnow_length
    cdef public int _wlatsnow_length_0
    cdef public bint _wlatsnow_ramflag
    cdef public double[:,:] _wlatsnow_array
    cdef public bint _wlatsnow_diskflag_reading
    cdef public bint _wlatsnow_diskflag_writing
    cdef public double[:] _wlatsnow_ncarray
    cdef public bint _wlatsnow_outputflag
    cdef double *_wlatsnow_outputpointer
    cdef public double[:] wsenssnow
    cdef public int _wsenssnow_ndim
    cdef public int _wsenssnow_length
    cdef public int _wsenssnow_length_0
    cdef public bint _wsenssnow_ramflag
    cdef public double[:,:] _wsenssnow_array
    cdef public bint _wsenssnow_diskflag_reading
    cdef public bint _wsenssnow_diskflag_writing
    cdef public double[:] _wsenssnow_ncarray
    cdef public bint _wsenssnow_outputflag
    cdef double *_wsenssnow_outputpointer
    cdef public double[:] wsurf
    cdef public int _wsurf_ndim
    cdef public int _wsurf_length
    cdef public int _wsurf_length_0
    cdef public bint _wsurf_ramflag
    cdef public double[:,:] _wsurf_array
    cdef public bint _wsurf_diskflag_reading
    cdef public bint _wsurf_diskflag_writing
    cdef public double[:] _wsurf_ncarray
    cdef public bint _wsurf_outputflag
    cdef double *_wsurf_outputpointer
    cdef public double[:] sff
    cdef public int _sff_ndim
    cdef public int _sff_length
    cdef public int _sff_length_0
    cdef public bint _sff_ramflag
    cdef public double[:,:] _sff_array
    cdef public bint _sff_diskflag_reading
    cdef public bint _sff_diskflag_writing
    cdef public double[:] _sff_ncarray
    cdef public bint _sff_outputflag
    cdef double *_sff_outputpointer
    cdef public double[:] fvg
    cdef public int _fvg_ndim
    cdef public int _fvg_length
    cdef public int _fvg_length_0
    cdef public bint _fvg_ramflag
    cdef public double[:,:] _fvg_array
    cdef public bint _fvg_diskflag_reading
    cdef public bint _fvg_diskflag_writing
    cdef public double[:] _fvg_ncarray
    cdef public bint _fvg_outputflag
    cdef double *_fvg_outputpointer
    cdef public double[:] wada
    cdef public int _wada_ndim
    cdef public int _wada_length
    cdef public int _wada_length_0
    cdef public bint _wada_ramflag
    cdef public double[:,:] _wada_array
    cdef public bint _wada_diskflag_reading
    cdef public bint _wada_diskflag_writing
    cdef public double[:] _wada_ncarray
    cdef public bint _wada_outputflag
    cdef double *_wada_outputpointer
    cdef public double[:] qdb
    cdef public int _qdb_ndim
    cdef public int _qdb_length
    cdef public int _qdb_length_0
    cdef public bint _qdb_ramflag
    cdef public double[:,:] _qdb_array
    cdef public bint _qdb_diskflag_reading
    cdef public bint _qdb_diskflag_writing
    cdef public double[:] _qdb_ncarray
    cdef public bint _qdb_outputflag
    cdef double *_qdb_outputpointer
    cdef public double[:] qib1
    cdef public int _qib1_ndim
    cdef public int _qib1_length
    cdef public int _qib1_length_0
    cdef public bint _qib1_ramflag
    cdef public double[:,:] _qib1_array
    cdef public bint _qib1_diskflag_reading
    cdef public bint _qib1_diskflag_writing
    cdef public double[:] _qib1_ncarray
    cdef public bint _qib1_outputflag
    cdef double *_qib1_outputpointer
    cdef public double[:] qib2
    cdef public int _qib2_ndim
    cdef public int _qib2_length
    cdef public int _qib2_length_0
    cdef public bint _qib2_ramflag
    cdef public double[:,:] _qib2_array
    cdef public bint _qib2_diskflag_reading
    cdef public bint _qib2_diskflag_writing
    cdef public double[:] _qib2_ncarray
    cdef public bint _qib2_outputflag
    cdef double *_qib2_outputpointer
    cdef public double[:] qbb
    cdef public int _qbb_ndim
    cdef public int _qbb_length
    cdef public int _qbb_length_0
    cdef public bint _qbb_ramflag
    cdef public double[:,:] _qbb_array
    cdef public bint _qbb_diskflag_reading
    cdef public bint _qbb_diskflag_writing
    cdef public double[:] _qbb_ncarray
    cdef public bint _qbb_outputflag
    cdef double *_qbb_outputpointer
    cdef public double[:] qkap
    cdef public int _qkap_ndim
    cdef public int _qkap_length
    cdef public int _qkap_length_0
    cdef public bint _qkap_ramflag
    cdef public double[:,:] _qkap_array
    cdef public bint _qkap_diskflag_reading
    cdef public bint _qkap_diskflag_writing
    cdef public double[:] _qkap_ncarray
    cdef public bint _qkap_outputflag
    cdef double *_qkap_outputpointer
    cdef public double qdgz
    cdef public int _qdgz_ndim
    cdef public int _qdgz_length
    cdef public bint _qdgz_ramflag
    cdef public double[:] _qdgz_array
    cdef public bint _qdgz_diskflag_reading
    cdef public bint _qdgz_diskflag_writing
    cdef public double[:] _qdgz_ncarray
    cdef public bint _qdgz_outputflag
    cdef double *_qdgz_outputpointer
    cdef public double qah
    cdef public int _qah_ndim
    cdef public int _qah_length
    cdef public bint _qah_ramflag
    cdef public double[:] _qah_array
    cdef public bint _qah_diskflag_reading
    cdef public bint _qah_diskflag_writing
    cdef public double[:] _qah_ncarray
    cdef public bint _qah_outputflag
    cdef double *_qah_outputpointer
    cdef public double qa
    cdef public int _qa_ndim
    cdef public int _qa_length
    cdef public bint _qa_ramflag
    cdef public double[:] _qa_array
    cdef public bint _qa_diskflag_reading
    cdef public bint _qa_diskflag_writing
    cdef public double[:] _qa_ncarray
    cdef public bint _qa_outputflag
    cdef double *_qa_outputpointer
    cpdef inline void load_data(self, int idx)  nogil:
        cdef int jdx0
        cdef int k
        if self._qz_diskflag_reading:
            self.qz = self._qz_ncarray[0]
        elif self._qz_ramflag:
            self.qz = self._qz_array[idx]
        if self._qzh_diskflag_reading:
            self.qzh = self._qzh_ncarray[0]
        elif self._qzh_ramflag:
            self.qzh = self._qzh_array[idx]
        if self._temltag_diskflag_reading:
            self.temltag = self._temltag_ncarray[0]
        elif self._temltag_ramflag:
            self.temltag = self._temltag_array[idx]
        if self._dailyrelativehumidity_diskflag_reading:
            self.dailyrelativehumidity = self._dailyrelativehumidity_ncarray[0]
        elif self._dailyrelativehumidity_ramflag:
            self.dailyrelativehumidity = self._dailyrelativehumidity_array[idx]
        if self._dailysunshineduration_diskflag_reading:
            self.dailysunshineduration = self._dailysunshineduration_ncarray[0]
        elif self._dailysunshineduration_ramflag:
            self.dailysunshineduration = self._dailysunshineduration_array[idx]
        if self._dailypossiblesunshineduration_diskflag_reading:
            self.dailypossiblesunshineduration = self._dailypossiblesunshineduration_ncarray[0]
        elif self._dailypossiblesunshineduration_ramflag:
            self.dailypossiblesunshineduration = self._dailypossiblesunshineduration_array[idx]
        if self._dailyglobalradiation_diskflag_reading:
            self.dailyglobalradiation = self._dailyglobalradiation_ncarray[0]
        elif self._dailyglobalradiation_ramflag:
            self.dailyglobalradiation = self._dailyglobalradiation_array[idx]
        if self._nkor_diskflag_reading:
            k = 0
            for jdx0 in range(self._nkor_length_0):
                self.nkor[jdx0] = self._nkor_ncarray[k]
                k += 1
        elif self._nkor_ramflag:
            for jdx0 in range(self._nkor_length_0):
                self.nkor[jdx0] = self._nkor_array[idx, jdx0]
        if self._tkor_diskflag_reading:
            k = 0
            for jdx0 in range(self._tkor_length_0):
                self.tkor[jdx0] = self._tkor_ncarray[k]
                k += 1
        elif self._tkor_ramflag:
            for jdx0 in range(self._tkor_length_0):
                self.tkor[jdx0] = self._tkor_array[idx, jdx0]
        if self._tkortag_diskflag_reading:
            k = 0
            for jdx0 in range(self._tkortag_length_0):
                self.tkortag[jdx0] = self._tkortag_ncarray[k]
                k += 1
        elif self._tkortag_ramflag:
            for jdx0 in range(self._tkortag_length_0):
                self.tkortag[jdx0] = self._tkortag_array[idx, jdx0]
        if self._windspeed2m_diskflag_reading:
            self.windspeed2m = self._windspeed2m_ncarray[0]
        elif self._windspeed2m_ramflag:
            self.windspeed2m = self._windspeed2m_array[idx]
        if self._dailywindspeed2m_diskflag_reading:
            self.dailywindspeed2m = self._dailywindspeed2m_ncarray[0]
        elif self._dailywindspeed2m_ramflag:
            self.dailywindspeed2m = self._dailywindspeed2m_array[idx]
        if self._reducedwindspeed2m_diskflag_reading:
            k = 0
            for jdx0 in range(self._reducedwindspeed2m_length_0):
                self.reducedwindspeed2m[jdx0] = self._reducedwindspeed2m_ncarray[k]
                k += 1
        elif self._reducedwindspeed2m_ramflag:
            for jdx0 in range(self._reducedwindspeed2m_length_0):
                self.reducedwindspeed2m[jdx0] = self._reducedwindspeed2m_array[idx, jdx0]
        if self._windspeed10m_diskflag_reading:
            self.windspeed10m = self._windspeed10m_ncarray[0]
        elif self._windspeed10m_ramflag:
            self.windspeed10m = self._windspeed10m_array[idx]
        if self._saturationvapourpressure_diskflag_reading:
            k = 0
            for jdx0 in range(self._saturationvapourpressure_length_0):
                self.saturationvapourpressure[jdx0] = self._saturationvapourpressure_ncarray[k]
                k += 1
        elif self._saturationvapourpressure_ramflag:
            for jdx0 in range(self._saturationvapourpressure_length_0):
                self.saturationvapourpressure[jdx0] = self._saturationvapourpressure_array[idx, jdx0]
        if self._dailysaturationvapourpressure_diskflag_reading:
            k = 0
            for jdx0 in range(self._dailysaturationvapourpressure_length_0):
                self.dailysaturationvapourpressure[jdx0] = self._dailysaturationvapourpressure_ncarray[k]
                k += 1
        elif self._dailysaturationvapourpressure_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressure_length_0):
                self.dailysaturationvapourpressure[jdx0] = self._dailysaturationvapourpressure_array[idx, jdx0]
        if self._saturationvapourpressuresnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._saturationvapourpressuresnow_length_0):
                self.saturationvapourpressuresnow[jdx0] = self._saturationvapourpressuresnow_ncarray[k]
                k += 1
        elif self._saturationvapourpressuresnow_ramflag:
            for jdx0 in range(self._saturationvapourpressuresnow_length_0):
                self.saturationvapourpressuresnow[jdx0] = self._saturationvapourpressuresnow_array[idx, jdx0]
        if self._saturationvapourpressureslope_diskflag_reading:
            k = 0
            for jdx0 in range(self._saturationvapourpressureslope_length_0):
                self.saturationvapourpressureslope[jdx0] = self._saturationvapourpressureslope_ncarray[k]
                k += 1
        elif self._saturationvapourpressureslope_ramflag:
            for jdx0 in range(self._saturationvapourpressureslope_length_0):
                self.saturationvapourpressureslope[jdx0] = self._saturationvapourpressureslope_array[idx, jdx0]
        if self._dailysaturationvapourpressureslope_diskflag_reading:
            k = 0
            for jdx0 in range(self._dailysaturationvapourpressureslope_length_0):
                self.dailysaturationvapourpressureslope[jdx0] = self._dailysaturationvapourpressureslope_ncarray[k]
                k += 1
        elif self._dailysaturationvapourpressureslope_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressureslope_length_0):
                self.dailysaturationvapourpressureslope[jdx0] = self._dailysaturationvapourpressureslope_array[idx, jdx0]
        if self._actualvapourpressure_diskflag_reading:
            k = 0
            for jdx0 in range(self._actualvapourpressure_length_0):
                self.actualvapourpressure[jdx0] = self._actualvapourpressure_ncarray[k]
                k += 1
        elif self._actualvapourpressure_ramflag:
            for jdx0 in range(self._actualvapourpressure_length_0):
                self.actualvapourpressure[jdx0] = self._actualvapourpressure_array[idx, jdx0]
        if self._dailyactualvapourpressure_diskflag_reading:
            k = 0
            for jdx0 in range(self._dailyactualvapourpressure_length_0):
                self.dailyactualvapourpressure[jdx0] = self._dailyactualvapourpressure_ncarray[k]
                k += 1
        elif self._dailyactualvapourpressure_ramflag:
            for jdx0 in range(self._dailyactualvapourpressure_length_0):
                self.dailyactualvapourpressure[jdx0] = self._dailyactualvapourpressure_array[idx, jdx0]
        if self._dryairpressure_diskflag_reading:
            k = 0
            for jdx0 in range(self._dryairpressure_length_0):
                self.dryairpressure[jdx0] = self._dryairpressure_ncarray[k]
                k += 1
        elif self._dryairpressure_ramflag:
            for jdx0 in range(self._dryairpressure_length_0):
                self.dryairpressure[jdx0] = self._dryairpressure_array[idx, jdx0]
        if self._densityair_diskflag_reading:
            k = 0
            for jdx0 in range(self._densityair_length_0):
                self.densityair[jdx0] = self._densityair_ncarray[k]
                k += 1
        elif self._densityair_ramflag:
            for jdx0 in range(self._densityair_length_0):
                self.densityair[jdx0] = self._densityair_array[idx, jdx0]
        if self._g_diskflag_reading:
            k = 0
            for jdx0 in range(self._g_length_0):
                self.g[jdx0] = self._g_ncarray[k]
                k += 1
        elif self._g_ramflag:
            for jdx0 in range(self._g_length_0):
                self.g[jdx0] = self._g_array[idx, jdx0]
        if self._tz_diskflag_reading:
            k = 0
            for jdx0 in range(self._tz_length_0):
                self.tz[jdx0] = self._tz_ncarray[k]
                k += 1
        elif self._tz_ramflag:
            for jdx0 in range(self._tz_length_0):
                self.tz[jdx0] = self._tz_array[idx, jdx0]
        if self._wg_diskflag_reading:
            k = 0
            for jdx0 in range(self._wg_length_0):
                self.wg[jdx0] = self._wg_ncarray[k]
                k += 1
        elif self._wg_ramflag:
            for jdx0 in range(self._wg_length_0):
                self.wg[jdx0] = self._wg_array[idx, jdx0]
        if self._netshortwaveradiation_diskflag_reading:
            k = 0
            for jdx0 in range(self._netshortwaveradiation_length_0):
                self.netshortwaveradiation[jdx0] = self._netshortwaveradiation_ncarray[k]
                k += 1
        elif self._netshortwaveradiation_ramflag:
            for jdx0 in range(self._netshortwaveradiation_length_0):
                self.netshortwaveradiation[jdx0] = self._netshortwaveradiation_array[idx, jdx0]
        if self._netshortwaveradiationsnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._netshortwaveradiationsnow_length_0):
                self.netshortwaveradiationsnow[jdx0] = self._netshortwaveradiationsnow_ncarray[k]
                k += 1
        elif self._netshortwaveradiationsnow_ramflag:
            for jdx0 in range(self._netshortwaveradiationsnow_length_0):
                self.netshortwaveradiationsnow[jdx0] = self._netshortwaveradiationsnow_array[idx, jdx0]
        if self._dailynetshortwaveradiation_diskflag_reading:
            k = 0
            for jdx0 in range(self._dailynetshortwaveradiation_length_0):
                self.dailynetshortwaveradiation[jdx0] = self._dailynetshortwaveradiation_ncarray[k]
                k += 1
        elif self._dailynetshortwaveradiation_ramflag:
            for jdx0 in range(self._dailynetshortwaveradiation_length_0):
                self.dailynetshortwaveradiation[jdx0] = self._dailynetshortwaveradiation_array[idx, jdx0]
        if self._dailynetlongwaveradiation_diskflag_reading:
            k = 0
            for jdx0 in range(self._dailynetlongwaveradiation_length_0):
                self.dailynetlongwaveradiation[jdx0] = self._dailynetlongwaveradiation_ncarray[k]
                k += 1
        elif self._dailynetlongwaveradiation_ramflag:
            for jdx0 in range(self._dailynetlongwaveradiation_length_0):
                self.dailynetlongwaveradiation[jdx0] = self._dailynetlongwaveradiation_array[idx, jdx0]
        if self._netlongwaveradiationsnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._netlongwaveradiationsnow_length_0):
                self.netlongwaveradiationsnow[jdx0] = self._netlongwaveradiationsnow_ncarray[k]
                k += 1
        elif self._netlongwaveradiationsnow_ramflag:
            for jdx0 in range(self._netlongwaveradiationsnow_length_0):
                self.netlongwaveradiationsnow[jdx0] = self._netlongwaveradiationsnow_array[idx, jdx0]
        if self._netradiation_diskflag_reading:
            k = 0
            for jdx0 in range(self._netradiation_length_0):
                self.netradiation[jdx0] = self._netradiation_ncarray[k]
                k += 1
        elif self._netradiation_ramflag:
            for jdx0 in range(self._netradiation_length_0):
                self.netradiation[jdx0] = self._netradiation_array[idx, jdx0]
        if self._netradiationsnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._netradiationsnow_length_0):
                self.netradiationsnow[jdx0] = self._netradiationsnow_ncarray[k]
                k += 1
        elif self._netradiationsnow_ramflag:
            for jdx0 in range(self._netradiationsnow_length_0):
                self.netradiationsnow[jdx0] = self._netradiationsnow_array[idx, jdx0]
        if self._dailynetradiation_diskflag_reading:
            k = 0
            for jdx0 in range(self._dailynetradiation_length_0):
                self.dailynetradiation[jdx0] = self._dailynetradiation_ncarray[k]
                k += 1
        elif self._dailynetradiation_ramflag:
            for jdx0 in range(self._dailynetradiation_length_0):
                self.dailynetradiation[jdx0] = self._dailynetradiation_array[idx, jdx0]
        if self._aerodynamicresistance_diskflag_reading:
            k = 0
            for jdx0 in range(self._aerodynamicresistance_length_0):
                self.aerodynamicresistance[jdx0] = self._aerodynamicresistance_ncarray[k]
                k += 1
        elif self._aerodynamicresistance_ramflag:
            for jdx0 in range(self._aerodynamicresistance_length_0):
                self.aerodynamicresistance[jdx0] = self._aerodynamicresistance_array[idx, jdx0]
        if self._soilsurfaceresistance_diskflag_reading:
            k = 0
            for jdx0 in range(self._soilsurfaceresistance_length_0):
                self.soilsurfaceresistance[jdx0] = self._soilsurfaceresistance_ncarray[k]
                k += 1
        elif self._soilsurfaceresistance_ramflag:
            for jdx0 in range(self._soilsurfaceresistance_length_0):
                self.soilsurfaceresistance[jdx0] = self._soilsurfaceresistance_array[idx, jdx0]
        if self._landusesurfaceresistance_diskflag_reading:
            k = 0
            for jdx0 in range(self._landusesurfaceresistance_length_0):
                self.landusesurfaceresistance[jdx0] = self._landusesurfaceresistance_ncarray[k]
                k += 1
        elif self._landusesurfaceresistance_ramflag:
            for jdx0 in range(self._landusesurfaceresistance_length_0):
                self.landusesurfaceresistance[jdx0] = self._landusesurfaceresistance_array[idx, jdx0]
        if self._actualsurfaceresistance_diskflag_reading:
            k = 0
            for jdx0 in range(self._actualsurfaceresistance_length_0):
                self.actualsurfaceresistance[jdx0] = self._actualsurfaceresistance_ncarray[k]
                k += 1
        elif self._actualsurfaceresistance_ramflag:
            for jdx0 in range(self._actualsurfaceresistance_length_0):
                self.actualsurfaceresistance[jdx0] = self._actualsurfaceresistance_array[idx, jdx0]
        if self._nbes_diskflag_reading:
            k = 0
            for jdx0 in range(self._nbes_length_0):
                self.nbes[jdx0] = self._nbes_ncarray[k]
                k += 1
        elif self._nbes_ramflag:
            for jdx0 in range(self._nbes_length_0):
                self.nbes[jdx0] = self._nbes_array[idx, jdx0]
        if self._sbes_diskflag_reading:
            k = 0
            for jdx0 in range(self._sbes_length_0):
                self.sbes[jdx0] = self._sbes_ncarray[k]
                k += 1
        elif self._sbes_ramflag:
            for jdx0 in range(self._sbes_length_0):
                self.sbes[jdx0] = self._sbes_array[idx, jdx0]
        if self._evpo_diskflag_reading:
            k = 0
            for jdx0 in range(self._evpo_length_0):
                self.evpo[jdx0] = self._evpo_ncarray[k]
                k += 1
        elif self._evpo_ramflag:
            for jdx0 in range(self._evpo_length_0):
                self.evpo[jdx0] = self._evpo_array[idx, jdx0]
        if self._evi_diskflag_reading:
            k = 0
            for jdx0 in range(self._evi_length_0):
                self.evi[jdx0] = self._evi_ncarray[k]
                k += 1
        elif self._evi_ramflag:
            for jdx0 in range(self._evi_length_0):
                self.evi[jdx0] = self._evi_array[idx, jdx0]
        if self._evb_diskflag_reading:
            k = 0
            for jdx0 in range(self._evb_length_0):
                self.evb[jdx0] = self._evb_ncarray[k]
                k += 1
        elif self._evb_ramflag:
            for jdx0 in range(self._evb_length_0):
                self.evb[jdx0] = self._evb_array[idx, jdx0]
        if self._evs_diskflag_reading:
            k = 0
            for jdx0 in range(self._evs_length_0):
                self.evs[jdx0] = self._evs_ncarray[k]
                k += 1
        elif self._evs_ramflag:
            for jdx0 in range(self._evs_length_0):
                self.evs[jdx0] = self._evs_array[idx, jdx0]
        if self._wnied_diskflag_reading:
            k = 0
            for jdx0 in range(self._wnied_length_0):
                self.wnied[jdx0] = self._wnied_ncarray[k]
                k += 1
        elif self._wnied_ramflag:
            for jdx0 in range(self._wnied_length_0):
                self.wnied[jdx0] = self._wnied_array[idx, jdx0]
        if self._tempssurface_diskflag_reading:
            k = 0
            for jdx0 in range(self._tempssurface_length_0):
                self.tempssurface[jdx0] = self._tempssurface_ncarray[k]
                k += 1
        elif self._tempssurface_ramflag:
            for jdx0 in range(self._tempssurface_length_0):
                self.tempssurface[jdx0] = self._tempssurface_array[idx, jdx0]
        if self._actualalbedo_diskflag_reading:
            k = 0
            for jdx0 in range(self._actualalbedo_length_0):
                self.actualalbedo[jdx0] = self._actualalbedo_ncarray[k]
                k += 1
        elif self._actualalbedo_ramflag:
            for jdx0 in range(self._actualalbedo_length_0):
                self.actualalbedo[jdx0] = self._actualalbedo_array[idx, jdx0]
        if self._schmpot_diskflag_reading:
            k = 0
            for jdx0 in range(self._schmpot_length_0):
                self.schmpot[jdx0] = self._schmpot_ncarray[k]
                k += 1
        elif self._schmpot_ramflag:
            for jdx0 in range(self._schmpot_length_0):
                self.schmpot[jdx0] = self._schmpot_array[idx, jdx0]
        if self._schm_diskflag_reading:
            k = 0
            for jdx0 in range(self._schm_length_0):
                self.schm[jdx0] = self._schm_ncarray[k]
                k += 1
        elif self._schm_ramflag:
            for jdx0 in range(self._schm_length_0):
                self.schm[jdx0] = self._schm_array[idx, jdx0]
        if self._gefrpot_diskflag_reading:
            k = 0
            for jdx0 in range(self._gefrpot_length_0):
                self.gefrpot[jdx0] = self._gefrpot_ncarray[k]
                k += 1
        elif self._gefrpot_ramflag:
            for jdx0 in range(self._gefrpot_length_0):
                self.gefrpot[jdx0] = self._gefrpot_array[idx, jdx0]
        if self._gefr_diskflag_reading:
            k = 0
            for jdx0 in range(self._gefr_length_0):
                self.gefr[jdx0] = self._gefr_ncarray[k]
                k += 1
        elif self._gefr_ramflag:
            for jdx0 in range(self._gefr_length_0):
                self.gefr[jdx0] = self._gefr_array[idx, jdx0]
        if self._wlatsnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._wlatsnow_length_0):
                self.wlatsnow[jdx0] = self._wlatsnow_ncarray[k]
                k += 1
        elif self._wlatsnow_ramflag:
            for jdx0 in range(self._wlatsnow_length_0):
                self.wlatsnow[jdx0] = self._wlatsnow_array[idx, jdx0]
        if self._wsenssnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._wsenssnow_length_0):
                self.wsenssnow[jdx0] = self._wsenssnow_ncarray[k]
                k += 1
        elif self._wsenssnow_ramflag:
            for jdx0 in range(self._wsenssnow_length_0):
                self.wsenssnow[jdx0] = self._wsenssnow_array[idx, jdx0]
        if self._wsurf_diskflag_reading:
            k = 0
            for jdx0 in range(self._wsurf_length_0):
                self.wsurf[jdx0] = self._wsurf_ncarray[k]
                k += 1
        elif self._wsurf_ramflag:
            for jdx0 in range(self._wsurf_length_0):
                self.wsurf[jdx0] = self._wsurf_array[idx, jdx0]
        if self._sff_diskflag_reading:
            k = 0
            for jdx0 in range(self._sff_length_0):
                self.sff[jdx0] = self._sff_ncarray[k]
                k += 1
        elif self._sff_ramflag:
            for jdx0 in range(self._sff_length_0):
                self.sff[jdx0] = self._sff_array[idx, jdx0]
        if self._fvg_diskflag_reading:
            k = 0
            for jdx0 in range(self._fvg_length_0):
                self.fvg[jdx0] = self._fvg_ncarray[k]
                k += 1
        elif self._fvg_ramflag:
            for jdx0 in range(self._fvg_length_0):
                self.fvg[jdx0] = self._fvg_array[idx, jdx0]
        if self._wada_diskflag_reading:
            k = 0
            for jdx0 in range(self._wada_length_0):
                self.wada[jdx0] = self._wada_ncarray[k]
                k += 1
        elif self._wada_ramflag:
            for jdx0 in range(self._wada_length_0):
                self.wada[jdx0] = self._wada_array[idx, jdx0]
        if self._qdb_diskflag_reading:
            k = 0
            for jdx0 in range(self._qdb_length_0):
                self.qdb[jdx0] = self._qdb_ncarray[k]
                k += 1
        elif self._qdb_ramflag:
            for jdx0 in range(self._qdb_length_0):
                self.qdb[jdx0] = self._qdb_array[idx, jdx0]
        if self._qib1_diskflag_reading:
            k = 0
            for jdx0 in range(self._qib1_length_0):
                self.qib1[jdx0] = self._qib1_ncarray[k]
                k += 1
        elif self._qib1_ramflag:
            for jdx0 in range(self._qib1_length_0):
                self.qib1[jdx0] = self._qib1_array[idx, jdx0]
        if self._qib2_diskflag_reading:
            k = 0
            for jdx0 in range(self._qib2_length_0):
                self.qib2[jdx0] = self._qib2_ncarray[k]
                k += 1
        elif self._qib2_ramflag:
            for jdx0 in range(self._qib2_length_0):
                self.qib2[jdx0] = self._qib2_array[idx, jdx0]
        if self._qbb_diskflag_reading:
            k = 0
            for jdx0 in range(self._qbb_length_0):
                self.qbb[jdx0] = self._qbb_ncarray[k]
                k += 1
        elif self._qbb_ramflag:
            for jdx0 in range(self._qbb_length_0):
                self.qbb[jdx0] = self._qbb_array[idx, jdx0]
        if self._qkap_diskflag_reading:
            k = 0
            for jdx0 in range(self._qkap_length_0):
                self.qkap[jdx0] = self._qkap_ncarray[k]
                k += 1
        elif self._qkap_ramflag:
            for jdx0 in range(self._qkap_length_0):
                self.qkap[jdx0] = self._qkap_array[idx, jdx0]
        if self._qdgz_diskflag_reading:
            self.qdgz = self._qdgz_ncarray[0]
        elif self._qdgz_ramflag:
            self.qdgz = self._qdgz_array[idx]
        if self._qah_diskflag_reading:
            self.qah = self._qah_ncarray[0]
        elif self._qah_ramflag:
            self.qah = self._qah_array[idx]
        if self._qa_diskflag_reading:
            self.qa = self._qa_ncarray[0]
        elif self._qa_ramflag:
            self.qa = self._qa_array[idx]
    cpdef inline void save_data(self, int idx)  nogil:
        cdef int jdx0
        cdef int k
        if self._qz_diskflag_writing:
            self._qz_ncarray[0] = self.qz
        if self._qz_ramflag:
            self._qz_array[idx] = self.qz
        if self._qzh_diskflag_writing:
            self._qzh_ncarray[0] = self.qzh
        if self._qzh_ramflag:
            self._qzh_array[idx] = self.qzh
        if self._temltag_diskflag_writing:
            self._temltag_ncarray[0] = self.temltag
        if self._temltag_ramflag:
            self._temltag_array[idx] = self.temltag
        if self._dailyrelativehumidity_diskflag_writing:
            self._dailyrelativehumidity_ncarray[0] = self.dailyrelativehumidity
        if self._dailyrelativehumidity_ramflag:
            self._dailyrelativehumidity_array[idx] = self.dailyrelativehumidity
        if self._dailysunshineduration_diskflag_writing:
            self._dailysunshineduration_ncarray[0] = self.dailysunshineduration
        if self._dailysunshineduration_ramflag:
            self._dailysunshineduration_array[idx] = self.dailysunshineduration
        if self._dailypossiblesunshineduration_diskflag_writing:
            self._dailypossiblesunshineduration_ncarray[0] = self.dailypossiblesunshineduration
        if self._dailypossiblesunshineduration_ramflag:
            self._dailypossiblesunshineduration_array[idx] = self.dailypossiblesunshineduration
        if self._dailyglobalradiation_diskflag_writing:
            self._dailyglobalradiation_ncarray[0] = self.dailyglobalradiation
        if self._dailyglobalradiation_ramflag:
            self._dailyglobalradiation_array[idx] = self.dailyglobalradiation
        if self._nkor_diskflag_writing:
            k = 0
            for jdx0 in range(self._nkor_length_0):
                self._nkor_ncarray[k] = self.nkor[jdx0]
                k += 1
        if self._nkor_ramflag:
            for jdx0 in range(self._nkor_length_0):
                self._nkor_array[idx, jdx0] = self.nkor[jdx0]
        if self._tkor_diskflag_writing:
            k = 0
            for jdx0 in range(self._tkor_length_0):
                self._tkor_ncarray[k] = self.tkor[jdx0]
                k += 1
        if self._tkor_ramflag:
            for jdx0 in range(self._tkor_length_0):
                self._tkor_array[idx, jdx0] = self.tkor[jdx0]
        if self._tkortag_diskflag_writing:
            k = 0
            for jdx0 in range(self._tkortag_length_0):
                self._tkortag_ncarray[k] = self.tkortag[jdx0]
                k += 1
        if self._tkortag_ramflag:
            for jdx0 in range(self._tkortag_length_0):
                self._tkortag_array[idx, jdx0] = self.tkortag[jdx0]
        if self._windspeed2m_diskflag_writing:
            self._windspeed2m_ncarray[0] = self.windspeed2m
        if self._windspeed2m_ramflag:
            self._windspeed2m_array[idx] = self.windspeed2m
        if self._dailywindspeed2m_diskflag_writing:
            self._dailywindspeed2m_ncarray[0] = self.dailywindspeed2m
        if self._dailywindspeed2m_ramflag:
            self._dailywindspeed2m_array[idx] = self.dailywindspeed2m
        if self._reducedwindspeed2m_diskflag_writing:
            k = 0
            for jdx0 in range(self._reducedwindspeed2m_length_0):
                self._reducedwindspeed2m_ncarray[k] = self.reducedwindspeed2m[jdx0]
                k += 1
        if self._reducedwindspeed2m_ramflag:
            for jdx0 in range(self._reducedwindspeed2m_length_0):
                self._reducedwindspeed2m_array[idx, jdx0] = self.reducedwindspeed2m[jdx0]
        if self._windspeed10m_diskflag_writing:
            self._windspeed10m_ncarray[0] = self.windspeed10m
        if self._windspeed10m_ramflag:
            self._windspeed10m_array[idx] = self.windspeed10m
        if self._saturationvapourpressure_diskflag_writing:
            k = 0
            for jdx0 in range(self._saturationvapourpressure_length_0):
                self._saturationvapourpressure_ncarray[k] = self.saturationvapourpressure[jdx0]
                k += 1
        if self._saturationvapourpressure_ramflag:
            for jdx0 in range(self._saturationvapourpressure_length_0):
                self._saturationvapourpressure_array[idx, jdx0] = self.saturationvapourpressure[jdx0]
        if self._dailysaturationvapourpressure_diskflag_writing:
            k = 0
            for jdx0 in range(self._dailysaturationvapourpressure_length_0):
                self._dailysaturationvapourpressure_ncarray[k] = self.dailysaturationvapourpressure[jdx0]
                k += 1
        if self._dailysaturationvapourpressure_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressure_length_0):
                self._dailysaturationvapourpressure_array[idx, jdx0] = self.dailysaturationvapourpressure[jdx0]
        if self._saturationvapourpressuresnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._saturationvapourpressuresnow_length_0):
                self._saturationvapourpressuresnow_ncarray[k] = self.saturationvapourpressuresnow[jdx0]
                k += 1
        if self._saturationvapourpressuresnow_ramflag:
            for jdx0 in range(self._saturationvapourpressuresnow_length_0):
                self._saturationvapourpressuresnow_array[idx, jdx0] = self.saturationvapourpressuresnow[jdx0]
        if self._saturationvapourpressureslope_diskflag_writing:
            k = 0
            for jdx0 in range(self._saturationvapourpressureslope_length_0):
                self._saturationvapourpressureslope_ncarray[k] = self.saturationvapourpressureslope[jdx0]
                k += 1
        if self._saturationvapourpressureslope_ramflag:
            for jdx0 in range(self._saturationvapourpressureslope_length_0):
                self._saturationvapourpressureslope_array[idx, jdx0] = self.saturationvapourpressureslope[jdx0]
        if self._dailysaturationvapourpressureslope_diskflag_writing:
            k = 0
            for jdx0 in range(self._dailysaturationvapourpressureslope_length_0):
                self._dailysaturationvapourpressureslope_ncarray[k] = self.dailysaturationvapourpressureslope[jdx0]
                k += 1
        if self._dailysaturationvapourpressureslope_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressureslope_length_0):
                self._dailysaturationvapourpressureslope_array[idx, jdx0] = self.dailysaturationvapourpressureslope[jdx0]
        if self._actualvapourpressure_diskflag_writing:
            k = 0
            for jdx0 in range(self._actualvapourpressure_length_0):
                self._actualvapourpressure_ncarray[k] = self.actualvapourpressure[jdx0]
                k += 1
        if self._actualvapourpressure_ramflag:
            for jdx0 in range(self._actualvapourpressure_length_0):
                self._actualvapourpressure_array[idx, jdx0] = self.actualvapourpressure[jdx0]
        if self._dailyactualvapourpressure_diskflag_writing:
            k = 0
            for jdx0 in range(self._dailyactualvapourpressure_length_0):
                self._dailyactualvapourpressure_ncarray[k] = self.dailyactualvapourpressure[jdx0]
                k += 1
        if self._dailyactualvapourpressure_ramflag:
            for jdx0 in range(self._dailyactualvapourpressure_length_0):
                self._dailyactualvapourpressure_array[idx, jdx0] = self.dailyactualvapourpressure[jdx0]
        if self._dryairpressure_diskflag_writing:
            k = 0
            for jdx0 in range(self._dryairpressure_length_0):
                self._dryairpressure_ncarray[k] = self.dryairpressure[jdx0]
                k += 1
        if self._dryairpressure_ramflag:
            for jdx0 in range(self._dryairpressure_length_0):
                self._dryairpressure_array[idx, jdx0] = self.dryairpressure[jdx0]
        if self._densityair_diskflag_writing:
            k = 0
            for jdx0 in range(self._densityair_length_0):
                self._densityair_ncarray[k] = self.densityair[jdx0]
                k += 1
        if self._densityair_ramflag:
            for jdx0 in range(self._densityair_length_0):
                self._densityair_array[idx, jdx0] = self.densityair[jdx0]
        if self._g_diskflag_writing:
            k = 0
            for jdx0 in range(self._g_length_0):
                self._g_ncarray[k] = self.g[jdx0]
                k += 1
        if self._g_ramflag:
            for jdx0 in range(self._g_length_0):
                self._g_array[idx, jdx0] = self.g[jdx0]
        if self._tz_diskflag_writing:
            k = 0
            for jdx0 in range(self._tz_length_0):
                self._tz_ncarray[k] = self.tz[jdx0]
                k += 1
        if self._tz_ramflag:
            for jdx0 in range(self._tz_length_0):
                self._tz_array[idx, jdx0] = self.tz[jdx0]
        if self._wg_diskflag_writing:
            k = 0
            for jdx0 in range(self._wg_length_0):
                self._wg_ncarray[k] = self.wg[jdx0]
                k += 1
        if self._wg_ramflag:
            for jdx0 in range(self._wg_length_0):
                self._wg_array[idx, jdx0] = self.wg[jdx0]
        if self._netshortwaveradiation_diskflag_writing:
            k = 0
            for jdx0 in range(self._netshortwaveradiation_length_0):
                self._netshortwaveradiation_ncarray[k] = self.netshortwaveradiation[jdx0]
                k += 1
        if self._netshortwaveradiation_ramflag:
            for jdx0 in range(self._netshortwaveradiation_length_0):
                self._netshortwaveradiation_array[idx, jdx0] = self.netshortwaveradiation[jdx0]
        if self._netshortwaveradiationsnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._netshortwaveradiationsnow_length_0):
                self._netshortwaveradiationsnow_ncarray[k] = self.netshortwaveradiationsnow[jdx0]
                k += 1
        if self._netshortwaveradiationsnow_ramflag:
            for jdx0 in range(self._netshortwaveradiationsnow_length_0):
                self._netshortwaveradiationsnow_array[idx, jdx0] = self.netshortwaveradiationsnow[jdx0]
        if self._dailynetshortwaveradiation_diskflag_writing:
            k = 0
            for jdx0 in range(self._dailynetshortwaveradiation_length_0):
                self._dailynetshortwaveradiation_ncarray[k] = self.dailynetshortwaveradiation[jdx0]
                k += 1
        if self._dailynetshortwaveradiation_ramflag:
            for jdx0 in range(self._dailynetshortwaveradiation_length_0):
                self._dailynetshortwaveradiation_array[idx, jdx0] = self.dailynetshortwaveradiation[jdx0]
        if self._dailynetlongwaveradiation_diskflag_writing:
            k = 0
            for jdx0 in range(self._dailynetlongwaveradiation_length_0):
                self._dailynetlongwaveradiation_ncarray[k] = self.dailynetlongwaveradiation[jdx0]
                k += 1
        if self._dailynetlongwaveradiation_ramflag:
            for jdx0 in range(self._dailynetlongwaveradiation_length_0):
                self._dailynetlongwaveradiation_array[idx, jdx0] = self.dailynetlongwaveradiation[jdx0]
        if self._netlongwaveradiationsnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._netlongwaveradiationsnow_length_0):
                self._netlongwaveradiationsnow_ncarray[k] = self.netlongwaveradiationsnow[jdx0]
                k += 1
        if self._netlongwaveradiationsnow_ramflag:
            for jdx0 in range(self._netlongwaveradiationsnow_length_0):
                self._netlongwaveradiationsnow_array[idx, jdx0] = self.netlongwaveradiationsnow[jdx0]
        if self._netradiation_diskflag_writing:
            k = 0
            for jdx0 in range(self._netradiation_length_0):
                self._netradiation_ncarray[k] = self.netradiation[jdx0]
                k += 1
        if self._netradiation_ramflag:
            for jdx0 in range(self._netradiation_length_0):
                self._netradiation_array[idx, jdx0] = self.netradiation[jdx0]
        if self._netradiationsnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._netradiationsnow_length_0):
                self._netradiationsnow_ncarray[k] = self.netradiationsnow[jdx0]
                k += 1
        if self._netradiationsnow_ramflag:
            for jdx0 in range(self._netradiationsnow_length_0):
                self._netradiationsnow_array[idx, jdx0] = self.netradiationsnow[jdx0]
        if self._dailynetradiation_diskflag_writing:
            k = 0
            for jdx0 in range(self._dailynetradiation_length_0):
                self._dailynetradiation_ncarray[k] = self.dailynetradiation[jdx0]
                k += 1
        if self._dailynetradiation_ramflag:
            for jdx0 in range(self._dailynetradiation_length_0):
                self._dailynetradiation_array[idx, jdx0] = self.dailynetradiation[jdx0]
        if self._aerodynamicresistance_diskflag_writing:
            k = 0
            for jdx0 in range(self._aerodynamicresistance_length_0):
                self._aerodynamicresistance_ncarray[k] = self.aerodynamicresistance[jdx0]
                k += 1
        if self._aerodynamicresistance_ramflag:
            for jdx0 in range(self._aerodynamicresistance_length_0):
                self._aerodynamicresistance_array[idx, jdx0] = self.aerodynamicresistance[jdx0]
        if self._soilsurfaceresistance_diskflag_writing:
            k = 0
            for jdx0 in range(self._soilsurfaceresistance_length_0):
                self._soilsurfaceresistance_ncarray[k] = self.soilsurfaceresistance[jdx0]
                k += 1
        if self._soilsurfaceresistance_ramflag:
            for jdx0 in range(self._soilsurfaceresistance_length_0):
                self._soilsurfaceresistance_array[idx, jdx0] = self.soilsurfaceresistance[jdx0]
        if self._landusesurfaceresistance_diskflag_writing:
            k = 0
            for jdx0 in range(self._landusesurfaceresistance_length_0):
                self._landusesurfaceresistance_ncarray[k] = self.landusesurfaceresistance[jdx0]
                k += 1
        if self._landusesurfaceresistance_ramflag:
            for jdx0 in range(self._landusesurfaceresistance_length_0):
                self._landusesurfaceresistance_array[idx, jdx0] = self.landusesurfaceresistance[jdx0]
        if self._actualsurfaceresistance_diskflag_writing:
            k = 0
            for jdx0 in range(self._actualsurfaceresistance_length_0):
                self._actualsurfaceresistance_ncarray[k] = self.actualsurfaceresistance[jdx0]
                k += 1
        if self._actualsurfaceresistance_ramflag:
            for jdx0 in range(self._actualsurfaceresistance_length_0):
                self._actualsurfaceresistance_array[idx, jdx0] = self.actualsurfaceresistance[jdx0]
        if self._nbes_diskflag_writing:
            k = 0
            for jdx0 in range(self._nbes_length_0):
                self._nbes_ncarray[k] = self.nbes[jdx0]
                k += 1
        if self._nbes_ramflag:
            for jdx0 in range(self._nbes_length_0):
                self._nbes_array[idx, jdx0] = self.nbes[jdx0]
        if self._sbes_diskflag_writing:
            k = 0
            for jdx0 in range(self._sbes_length_0):
                self._sbes_ncarray[k] = self.sbes[jdx0]
                k += 1
        if self._sbes_ramflag:
            for jdx0 in range(self._sbes_length_0):
                self._sbes_array[idx, jdx0] = self.sbes[jdx0]
        if self._evpo_diskflag_writing:
            k = 0
            for jdx0 in range(self._evpo_length_0):
                self._evpo_ncarray[k] = self.evpo[jdx0]
                k += 1
        if self._evpo_ramflag:
            for jdx0 in range(self._evpo_length_0):
                self._evpo_array[idx, jdx0] = self.evpo[jdx0]
        if self._evi_diskflag_writing:
            k = 0
            for jdx0 in range(self._evi_length_0):
                self._evi_ncarray[k] = self.evi[jdx0]
                k += 1
        if self._evi_ramflag:
            for jdx0 in range(self._evi_length_0):
                self._evi_array[idx, jdx0] = self.evi[jdx0]
        if self._evb_diskflag_writing:
            k = 0
            for jdx0 in range(self._evb_length_0):
                self._evb_ncarray[k] = self.evb[jdx0]
                k += 1
        if self._evb_ramflag:
            for jdx0 in range(self._evb_length_0):
                self._evb_array[idx, jdx0] = self.evb[jdx0]
        if self._evs_diskflag_writing:
            k = 0
            for jdx0 in range(self._evs_length_0):
                self._evs_ncarray[k] = self.evs[jdx0]
                k += 1
        if self._evs_ramflag:
            for jdx0 in range(self._evs_length_0):
                self._evs_array[idx, jdx0] = self.evs[jdx0]
        if self._wnied_diskflag_writing:
            k = 0
            for jdx0 in range(self._wnied_length_0):
                self._wnied_ncarray[k] = self.wnied[jdx0]
                k += 1
        if self._wnied_ramflag:
            for jdx0 in range(self._wnied_length_0):
                self._wnied_array[idx, jdx0] = self.wnied[jdx0]
        if self._tempssurface_diskflag_writing:
            k = 0
            for jdx0 in range(self._tempssurface_length_0):
                self._tempssurface_ncarray[k] = self.tempssurface[jdx0]
                k += 1
        if self._tempssurface_ramflag:
            for jdx0 in range(self._tempssurface_length_0):
                self._tempssurface_array[idx, jdx0] = self.tempssurface[jdx0]
        if self._actualalbedo_diskflag_writing:
            k = 0
            for jdx0 in range(self._actualalbedo_length_0):
                self._actualalbedo_ncarray[k] = self.actualalbedo[jdx0]
                k += 1
        if self._actualalbedo_ramflag:
            for jdx0 in range(self._actualalbedo_length_0):
                self._actualalbedo_array[idx, jdx0] = self.actualalbedo[jdx0]
        if self._schmpot_diskflag_writing:
            k = 0
            for jdx0 in range(self._schmpot_length_0):
                self._schmpot_ncarray[k] = self.schmpot[jdx0]
                k += 1
        if self._schmpot_ramflag:
            for jdx0 in range(self._schmpot_length_0):
                self._schmpot_array[idx, jdx0] = self.schmpot[jdx0]
        if self._schm_diskflag_writing:
            k = 0
            for jdx0 in range(self._schm_length_0):
                self._schm_ncarray[k] = self.schm[jdx0]
                k += 1
        if self._schm_ramflag:
            for jdx0 in range(self._schm_length_0):
                self._schm_array[idx, jdx0] = self.schm[jdx0]
        if self._gefrpot_diskflag_writing:
            k = 0
            for jdx0 in range(self._gefrpot_length_0):
                self._gefrpot_ncarray[k] = self.gefrpot[jdx0]
                k += 1
        if self._gefrpot_ramflag:
            for jdx0 in range(self._gefrpot_length_0):
                self._gefrpot_array[idx, jdx0] = self.gefrpot[jdx0]
        if self._gefr_diskflag_writing:
            k = 0
            for jdx0 in range(self._gefr_length_0):
                self._gefr_ncarray[k] = self.gefr[jdx0]
                k += 1
        if self._gefr_ramflag:
            for jdx0 in range(self._gefr_length_0):
                self._gefr_array[idx, jdx0] = self.gefr[jdx0]
        if self._wlatsnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._wlatsnow_length_0):
                self._wlatsnow_ncarray[k] = self.wlatsnow[jdx0]
                k += 1
        if self._wlatsnow_ramflag:
            for jdx0 in range(self._wlatsnow_length_0):
                self._wlatsnow_array[idx, jdx0] = self.wlatsnow[jdx0]
        if self._wsenssnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._wsenssnow_length_0):
                self._wsenssnow_ncarray[k] = self.wsenssnow[jdx0]
                k += 1
        if self._wsenssnow_ramflag:
            for jdx0 in range(self._wsenssnow_length_0):
                self._wsenssnow_array[idx, jdx0] = self.wsenssnow[jdx0]
        if self._wsurf_diskflag_writing:
            k = 0
            for jdx0 in range(self._wsurf_length_0):
                self._wsurf_ncarray[k] = self.wsurf[jdx0]
                k += 1
        if self._wsurf_ramflag:
            for jdx0 in range(self._wsurf_length_0):
                self._wsurf_array[idx, jdx0] = self.wsurf[jdx0]
        if self._sff_diskflag_writing:
            k = 0
            for jdx0 in range(self._sff_length_0):
                self._sff_ncarray[k] = self.sff[jdx0]
                k += 1
        if self._sff_ramflag:
            for jdx0 in range(self._sff_length_0):
                self._sff_array[idx, jdx0] = self.sff[jdx0]
        if self._fvg_diskflag_writing:
            k = 0
            for jdx0 in range(self._fvg_length_0):
                self._fvg_ncarray[k] = self.fvg[jdx0]
                k += 1
        if self._fvg_ramflag:
            for jdx0 in range(self._fvg_length_0):
                self._fvg_array[idx, jdx0] = self.fvg[jdx0]
        if self._wada_diskflag_writing:
            k = 0
            for jdx0 in range(self._wada_length_0):
                self._wada_ncarray[k] = self.wada[jdx0]
                k += 1
        if self._wada_ramflag:
            for jdx0 in range(self._wada_length_0):
                self._wada_array[idx, jdx0] = self.wada[jdx0]
        if self._qdb_diskflag_writing:
            k = 0
            for jdx0 in range(self._qdb_length_0):
                self._qdb_ncarray[k] = self.qdb[jdx0]
                k += 1
        if self._qdb_ramflag:
            for jdx0 in range(self._qdb_length_0):
                self._qdb_array[idx, jdx0] = self.qdb[jdx0]
        if self._qib1_diskflag_writing:
            k = 0
            for jdx0 in range(self._qib1_length_0):
                self._qib1_ncarray[k] = self.qib1[jdx0]
                k += 1
        if self._qib1_ramflag:
            for jdx0 in range(self._qib1_length_0):
                self._qib1_array[idx, jdx0] = self.qib1[jdx0]
        if self._qib2_diskflag_writing:
            k = 0
            for jdx0 in range(self._qib2_length_0):
                self._qib2_ncarray[k] = self.qib2[jdx0]
                k += 1
        if self._qib2_ramflag:
            for jdx0 in range(self._qib2_length_0):
                self._qib2_array[idx, jdx0] = self.qib2[jdx0]
        if self._qbb_diskflag_writing:
            k = 0
            for jdx0 in range(self._qbb_length_0):
                self._qbb_ncarray[k] = self.qbb[jdx0]
                k += 1
        if self._qbb_ramflag:
            for jdx0 in range(self._qbb_length_0):
                self._qbb_array[idx, jdx0] = self.qbb[jdx0]
        if self._qkap_diskflag_writing:
            k = 0
            for jdx0 in range(self._qkap_length_0):
                self._qkap_ncarray[k] = self.qkap[jdx0]
                k += 1
        if self._qkap_ramflag:
            for jdx0 in range(self._qkap_length_0):
                self._qkap_array[idx, jdx0] = self.qkap[jdx0]
        if self._qdgz_diskflag_writing:
            self._qdgz_ncarray[0] = self.qdgz
        if self._qdgz_ramflag:
            self._qdgz_array[idx] = self.qdgz
        if self._qah_diskflag_writing:
            self._qah_ncarray[0] = self.qah
        if self._qah_ramflag:
            self._qah_array[idx] = self.qah
        if self._qa_diskflag_writing:
            self._qa_ncarray[0] = self.qa
        if self._qa_ramflag:
            self._qa_array[idx] = self.qa
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "qz":
            self._qz_outputpointer = value.p_value
        if name == "qzh":
            self._qzh_outputpointer = value.p_value
        if name == "temltag":
            self._temltag_outputpointer = value.p_value
        if name == "dailyrelativehumidity":
            self._dailyrelativehumidity_outputpointer = value.p_value
        if name == "dailysunshineduration":
            self._dailysunshineduration_outputpointer = value.p_value
        if name == "dailypossiblesunshineduration":
            self._dailypossiblesunshineduration_outputpointer = value.p_value
        if name == "dailyglobalradiation":
            self._dailyglobalradiation_outputpointer = value.p_value
        if name == "windspeed2m":
            self._windspeed2m_outputpointer = value.p_value
        if name == "dailywindspeed2m":
            self._dailywindspeed2m_outputpointer = value.p_value
        if name == "windspeed10m":
            self._windspeed10m_outputpointer = value.p_value
        if name == "qdgz":
            self._qdgz_outputpointer = value.p_value
        if name == "qah":
            self._qah_outputpointer = value.p_value
        if name == "qa":
            self._qa_outputpointer = value.p_value
    cpdef inline void update_outputs(self) nogil:
        if self._qz_outputflag:
            self._qz_outputpointer[0] = self.qz
        if self._qzh_outputflag:
            self._qzh_outputpointer[0] = self.qzh
        if self._temltag_outputflag:
            self._temltag_outputpointer[0] = self.temltag
        if self._dailyrelativehumidity_outputflag:
            self._dailyrelativehumidity_outputpointer[0] = self.dailyrelativehumidity
        if self._dailysunshineduration_outputflag:
            self._dailysunshineduration_outputpointer[0] = self.dailysunshineduration
        if self._dailypossiblesunshineduration_outputflag:
            self._dailypossiblesunshineduration_outputpointer[0] = self.dailypossiblesunshineduration
        if self._dailyglobalradiation_outputflag:
            self._dailyglobalradiation_outputpointer[0] = self.dailyglobalradiation
        if self._windspeed2m_outputflag:
            self._windspeed2m_outputpointer[0] = self.windspeed2m
        if self._dailywindspeed2m_outputflag:
            self._dailywindspeed2m_outputpointer[0] = self.dailywindspeed2m
        if self._windspeed10m_outputflag:
            self._windspeed10m_outputpointer[0] = self.windspeed10m
        if self._qdgz_outputflag:
            self._qdgz_outputpointer[0] = self.qdgz
        if self._qah_outputflag:
            self._qah_outputpointer[0] = self.qah
        if self._qa_outputflag:
            self._qa_outputpointer[0] = self.qa
@cython.final
cdef class StateSequences:
    cdef public double[:] inzp
    cdef public int _inzp_ndim
    cdef public int _inzp_length
    cdef public int _inzp_length_0
    cdef public bint _inzp_ramflag
    cdef public double[:,:] _inzp_array
    cdef public bint _inzp_diskflag_reading
    cdef public bint _inzp_diskflag_writing
    cdef public double[:] _inzp_ncarray
    cdef public bint _inzp_outputflag
    cdef double *_inzp_outputpointer
    cdef public double[:] wats
    cdef public int _wats_ndim
    cdef public int _wats_length
    cdef public int _wats_length_0
    cdef public bint _wats_ramflag
    cdef public double[:,:] _wats_array
    cdef public bint _wats_diskflag_reading
    cdef public bint _wats_diskflag_writing
    cdef public double[:] _wats_ncarray
    cdef public bint _wats_outputflag
    cdef double *_wats_outputpointer
    cdef public double[:] waes
    cdef public int _waes_ndim
    cdef public int _waes_length
    cdef public int _waes_length_0
    cdef public bint _waes_ramflag
    cdef public double[:,:] _waes_array
    cdef public bint _waes_diskflag_reading
    cdef public bint _waes_diskflag_writing
    cdef public double[:] _waes_ncarray
    cdef public bint _waes_outputflag
    cdef double *_waes_outputpointer
    cdef public double[:] esnow
    cdef public int _esnow_ndim
    cdef public int _esnow_length
    cdef public int _esnow_length_0
    cdef public bint _esnow_ramflag
    cdef public double[:,:] _esnow_array
    cdef public bint _esnow_diskflag_reading
    cdef public bint _esnow_diskflag_writing
    cdef public double[:] _esnow_ncarray
    cdef public bint _esnow_outputflag
    cdef double *_esnow_outputpointer
    cdef public double[:] taus
    cdef public int _taus_ndim
    cdef public int _taus_length
    cdef public int _taus_length_0
    cdef public bint _taus_ramflag
    cdef public double[:,:] _taus_array
    cdef public bint _taus_diskflag_reading
    cdef public bint _taus_diskflag_writing
    cdef public double[:] _taus_ncarray
    cdef public bint _taus_outputflag
    cdef double *_taus_outputpointer
    cdef public double[:] ebdn
    cdef public int _ebdn_ndim
    cdef public int _ebdn_length
    cdef public int _ebdn_length_0
    cdef public bint _ebdn_ramflag
    cdef public double[:,:] _ebdn_array
    cdef public bint _ebdn_diskflag_reading
    cdef public bint _ebdn_diskflag_writing
    cdef public double[:] _ebdn_ncarray
    cdef public bint _ebdn_outputflag
    cdef double *_ebdn_outputpointer
    cdef public double[:] bowa
    cdef public int _bowa_ndim
    cdef public int _bowa_length
    cdef public int _bowa_length_0
    cdef public bint _bowa_ramflag
    cdef public double[:,:] _bowa_array
    cdef public bint _bowa_diskflag_reading
    cdef public bint _bowa_diskflag_writing
    cdef public double[:] _bowa_ncarray
    cdef public bint _bowa_outputflag
    cdef double *_bowa_outputpointer
    cdef public double qdgz1
    cdef public int _qdgz1_ndim
    cdef public int _qdgz1_length
    cdef public bint _qdgz1_ramflag
    cdef public double[:] _qdgz1_array
    cdef public bint _qdgz1_diskflag_reading
    cdef public bint _qdgz1_diskflag_writing
    cdef public double[:] _qdgz1_ncarray
    cdef public bint _qdgz1_outputflag
    cdef double *_qdgz1_outputpointer
    cdef public double qdgz2
    cdef public int _qdgz2_ndim
    cdef public int _qdgz2_length
    cdef public bint _qdgz2_ramflag
    cdef public double[:] _qdgz2_array
    cdef public bint _qdgz2_diskflag_reading
    cdef public bint _qdgz2_diskflag_writing
    cdef public double[:] _qdgz2_ncarray
    cdef public bint _qdgz2_outputflag
    cdef double *_qdgz2_outputpointer
    cdef public double qigz1
    cdef public int _qigz1_ndim
    cdef public int _qigz1_length
    cdef public bint _qigz1_ramflag
    cdef public double[:] _qigz1_array
    cdef public bint _qigz1_diskflag_reading
    cdef public bint _qigz1_diskflag_writing
    cdef public double[:] _qigz1_ncarray
    cdef public bint _qigz1_outputflag
    cdef double *_qigz1_outputpointer
    cdef public double qigz2
    cdef public int _qigz2_ndim
    cdef public int _qigz2_length
    cdef public bint _qigz2_ramflag
    cdef public double[:] _qigz2_array
    cdef public bint _qigz2_diskflag_reading
    cdef public bint _qigz2_diskflag_writing
    cdef public double[:] _qigz2_ncarray
    cdef public bint _qigz2_outputflag
    cdef double *_qigz2_outputpointer
    cdef public double qbgz
    cdef public int _qbgz_ndim
    cdef public int _qbgz_length
    cdef public bint _qbgz_ramflag
    cdef public double[:] _qbgz_array
    cdef public bint _qbgz_diskflag_reading
    cdef public bint _qbgz_diskflag_writing
    cdef public double[:] _qbgz_ncarray
    cdef public bint _qbgz_outputflag
    cdef double *_qbgz_outputpointer
    cdef public double qdga1
    cdef public int _qdga1_ndim
    cdef public int _qdga1_length
    cdef public bint _qdga1_ramflag
    cdef public double[:] _qdga1_array
    cdef public bint _qdga1_diskflag_reading
    cdef public bint _qdga1_diskflag_writing
    cdef public double[:] _qdga1_ncarray
    cdef public bint _qdga1_outputflag
    cdef double *_qdga1_outputpointer
    cdef public double qdga2
    cdef public int _qdga2_ndim
    cdef public int _qdga2_length
    cdef public bint _qdga2_ramflag
    cdef public double[:] _qdga2_array
    cdef public bint _qdga2_diskflag_reading
    cdef public bint _qdga2_diskflag_writing
    cdef public double[:] _qdga2_ncarray
    cdef public bint _qdga2_outputflag
    cdef double *_qdga2_outputpointer
    cdef public double qiga1
    cdef public int _qiga1_ndim
    cdef public int _qiga1_length
    cdef public bint _qiga1_ramflag
    cdef public double[:] _qiga1_array
    cdef public bint _qiga1_diskflag_reading
    cdef public bint _qiga1_diskflag_writing
    cdef public double[:] _qiga1_ncarray
    cdef public bint _qiga1_outputflag
    cdef double *_qiga1_outputpointer
    cdef public double qiga2
    cdef public int _qiga2_ndim
    cdef public int _qiga2_length
    cdef public bint _qiga2_ramflag
    cdef public double[:] _qiga2_array
    cdef public bint _qiga2_diskflag_reading
    cdef public bint _qiga2_diskflag_writing
    cdef public double[:] _qiga2_ncarray
    cdef public bint _qiga2_outputflag
    cdef double *_qiga2_outputpointer
    cdef public double qbga
    cdef public int _qbga_ndim
    cdef public int _qbga_length
    cdef public bint _qbga_ramflag
    cdef public double[:] _qbga_array
    cdef public bint _qbga_diskflag_reading
    cdef public bint _qbga_diskflag_writing
    cdef public double[:] _qbga_ncarray
    cdef public bint _qbga_outputflag
    cdef double *_qbga_outputpointer
    cpdef inline void load_data(self, int idx)  nogil:
        cdef int jdx0
        cdef int k
        if self._inzp_diskflag_reading:
            k = 0
            for jdx0 in range(self._inzp_length_0):
                self.inzp[jdx0] = self._inzp_ncarray[k]
                k += 1
        elif self._inzp_ramflag:
            for jdx0 in range(self._inzp_length_0):
                self.inzp[jdx0] = self._inzp_array[idx, jdx0]
        if self._wats_diskflag_reading:
            k = 0
            for jdx0 in range(self._wats_length_0):
                self.wats[jdx0] = self._wats_ncarray[k]
                k += 1
        elif self._wats_ramflag:
            for jdx0 in range(self._wats_length_0):
                self.wats[jdx0] = self._wats_array[idx, jdx0]
        if self._waes_diskflag_reading:
            k = 0
            for jdx0 in range(self._waes_length_0):
                self.waes[jdx0] = self._waes_ncarray[k]
                k += 1
        elif self._waes_ramflag:
            for jdx0 in range(self._waes_length_0):
                self.waes[jdx0] = self._waes_array[idx, jdx0]
        if self._esnow_diskflag_reading:
            k = 0
            for jdx0 in range(self._esnow_length_0):
                self.esnow[jdx0] = self._esnow_ncarray[k]
                k += 1
        elif self._esnow_ramflag:
            for jdx0 in range(self._esnow_length_0):
                self.esnow[jdx0] = self._esnow_array[idx, jdx0]
        if self._taus_diskflag_reading:
            k = 0
            for jdx0 in range(self._taus_length_0):
                self.taus[jdx0] = self._taus_ncarray[k]
                k += 1
        elif self._taus_ramflag:
            for jdx0 in range(self._taus_length_0):
                self.taus[jdx0] = self._taus_array[idx, jdx0]
        if self._ebdn_diskflag_reading:
            k = 0
            for jdx0 in range(self._ebdn_length_0):
                self.ebdn[jdx0] = self._ebdn_ncarray[k]
                k += 1
        elif self._ebdn_ramflag:
            for jdx0 in range(self._ebdn_length_0):
                self.ebdn[jdx0] = self._ebdn_array[idx, jdx0]
        if self._bowa_diskflag_reading:
            k = 0
            for jdx0 in range(self._bowa_length_0):
                self.bowa[jdx0] = self._bowa_ncarray[k]
                k += 1
        elif self._bowa_ramflag:
            for jdx0 in range(self._bowa_length_0):
                self.bowa[jdx0] = self._bowa_array[idx, jdx0]
        if self._qdgz1_diskflag_reading:
            self.qdgz1 = self._qdgz1_ncarray[0]
        elif self._qdgz1_ramflag:
            self.qdgz1 = self._qdgz1_array[idx]
        if self._qdgz2_diskflag_reading:
            self.qdgz2 = self._qdgz2_ncarray[0]
        elif self._qdgz2_ramflag:
            self.qdgz2 = self._qdgz2_array[idx]
        if self._qigz1_diskflag_reading:
            self.qigz1 = self._qigz1_ncarray[0]
        elif self._qigz1_ramflag:
            self.qigz1 = self._qigz1_array[idx]
        if self._qigz2_diskflag_reading:
            self.qigz2 = self._qigz2_ncarray[0]
        elif self._qigz2_ramflag:
            self.qigz2 = self._qigz2_array[idx]
        if self._qbgz_diskflag_reading:
            self.qbgz = self._qbgz_ncarray[0]
        elif self._qbgz_ramflag:
            self.qbgz = self._qbgz_array[idx]
        if self._qdga1_diskflag_reading:
            self.qdga1 = self._qdga1_ncarray[0]
        elif self._qdga1_ramflag:
            self.qdga1 = self._qdga1_array[idx]
        if self._qdga2_diskflag_reading:
            self.qdga2 = self._qdga2_ncarray[0]
        elif self._qdga2_ramflag:
            self.qdga2 = self._qdga2_array[idx]
        if self._qiga1_diskflag_reading:
            self.qiga1 = self._qiga1_ncarray[0]
        elif self._qiga1_ramflag:
            self.qiga1 = self._qiga1_array[idx]
        if self._qiga2_diskflag_reading:
            self.qiga2 = self._qiga2_ncarray[0]
        elif self._qiga2_ramflag:
            self.qiga2 = self._qiga2_array[idx]
        if self._qbga_diskflag_reading:
            self.qbga = self._qbga_ncarray[0]
        elif self._qbga_ramflag:
            self.qbga = self._qbga_array[idx]
    cpdef inline void save_data(self, int idx)  nogil:
        cdef int jdx0
        cdef int k
        if self._inzp_diskflag_writing:
            k = 0
            for jdx0 in range(self._inzp_length_0):
                self._inzp_ncarray[k] = self.inzp[jdx0]
                k += 1
        if self._inzp_ramflag:
            for jdx0 in range(self._inzp_length_0):
                self._inzp_array[idx, jdx0] = self.inzp[jdx0]
        if self._wats_diskflag_writing:
            k = 0
            for jdx0 in range(self._wats_length_0):
                self._wats_ncarray[k] = self.wats[jdx0]
                k += 1
        if self._wats_ramflag:
            for jdx0 in range(self._wats_length_0):
                self._wats_array[idx, jdx0] = self.wats[jdx0]
        if self._waes_diskflag_writing:
            k = 0
            for jdx0 in range(self._waes_length_0):
                self._waes_ncarray[k] = self.waes[jdx0]
                k += 1
        if self._waes_ramflag:
            for jdx0 in range(self._waes_length_0):
                self._waes_array[idx, jdx0] = self.waes[jdx0]
        if self._esnow_diskflag_writing:
            k = 0
            for jdx0 in range(self._esnow_length_0):
                self._esnow_ncarray[k] = self.esnow[jdx0]
                k += 1
        if self._esnow_ramflag:
            for jdx0 in range(self._esnow_length_0):
                self._esnow_array[idx, jdx0] = self.esnow[jdx0]
        if self._taus_diskflag_writing:
            k = 0
            for jdx0 in range(self._taus_length_0):
                self._taus_ncarray[k] = self.taus[jdx0]
                k += 1
        if self._taus_ramflag:
            for jdx0 in range(self._taus_length_0):
                self._taus_array[idx, jdx0] = self.taus[jdx0]
        if self._ebdn_diskflag_writing:
            k = 0
            for jdx0 in range(self._ebdn_length_0):
                self._ebdn_ncarray[k] = self.ebdn[jdx0]
                k += 1
        if self._ebdn_ramflag:
            for jdx0 in range(self._ebdn_length_0):
                self._ebdn_array[idx, jdx0] = self.ebdn[jdx0]
        if self._bowa_diskflag_writing:
            k = 0
            for jdx0 in range(self._bowa_length_0):
                self._bowa_ncarray[k] = self.bowa[jdx0]
                k += 1
        if self._bowa_ramflag:
            for jdx0 in range(self._bowa_length_0):
                self._bowa_array[idx, jdx0] = self.bowa[jdx0]
        if self._qdgz1_diskflag_writing:
            self._qdgz1_ncarray[0] = self.qdgz1
        if self._qdgz1_ramflag:
            self._qdgz1_array[idx] = self.qdgz1
        if self._qdgz2_diskflag_writing:
            self._qdgz2_ncarray[0] = self.qdgz2
        if self._qdgz2_ramflag:
            self._qdgz2_array[idx] = self.qdgz2
        if self._qigz1_diskflag_writing:
            self._qigz1_ncarray[0] = self.qigz1
        if self._qigz1_ramflag:
            self._qigz1_array[idx] = self.qigz1
        if self._qigz2_diskflag_writing:
            self._qigz2_ncarray[0] = self.qigz2
        if self._qigz2_ramflag:
            self._qigz2_array[idx] = self.qigz2
        if self._qbgz_diskflag_writing:
            self._qbgz_ncarray[0] = self.qbgz
        if self._qbgz_ramflag:
            self._qbgz_array[idx] = self.qbgz
        if self._qdga1_diskflag_writing:
            self._qdga1_ncarray[0] = self.qdga1
        if self._qdga1_ramflag:
            self._qdga1_array[idx] = self.qdga1
        if self._qdga2_diskflag_writing:
            self._qdga2_ncarray[0] = self.qdga2
        if self._qdga2_ramflag:
            self._qdga2_array[idx] = self.qdga2
        if self._qiga1_diskflag_writing:
            self._qiga1_ncarray[0] = self.qiga1
        if self._qiga1_ramflag:
            self._qiga1_array[idx] = self.qiga1
        if self._qiga2_diskflag_writing:
            self._qiga2_ncarray[0] = self.qiga2
        if self._qiga2_ramflag:
            self._qiga2_array[idx] = self.qiga2
        if self._qbga_diskflag_writing:
            self._qbga_ncarray[0] = self.qbga
        if self._qbga_ramflag:
            self._qbga_array[idx] = self.qbga
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "qdgz1":
            self._qdgz1_outputpointer = value.p_value
        if name == "qdgz2":
            self._qdgz2_outputpointer = value.p_value
        if name == "qigz1":
            self._qigz1_outputpointer = value.p_value
        if name == "qigz2":
            self._qigz2_outputpointer = value.p_value
        if name == "qbgz":
            self._qbgz_outputpointer = value.p_value
        if name == "qdga1":
            self._qdga1_outputpointer = value.p_value
        if name == "qdga2":
            self._qdga2_outputpointer = value.p_value
        if name == "qiga1":
            self._qiga1_outputpointer = value.p_value
        if name == "qiga2":
            self._qiga2_outputpointer = value.p_value
        if name == "qbga":
            self._qbga_outputpointer = value.p_value
    cpdef inline void update_outputs(self) nogil:
        if self._qdgz1_outputflag:
            self._qdgz1_outputpointer[0] = self.qdgz1
        if self._qdgz2_outputflag:
            self._qdgz2_outputpointer[0] = self.qdgz2
        if self._qigz1_outputflag:
            self._qigz1_outputpointer[0] = self.qigz1
        if self._qigz2_outputflag:
            self._qigz2_outputpointer[0] = self.qigz2
        if self._qbgz_outputflag:
            self._qbgz_outputpointer[0] = self.qbgz
        if self._qdga1_outputflag:
            self._qdga1_outputpointer[0] = self.qdga1
        if self._qdga2_outputflag:
            self._qdga2_outputpointer[0] = self.qdga2
        if self._qiga1_outputflag:
            self._qiga1_outputpointer[0] = self.qiga1
        if self._qiga2_outputflag:
            self._qiga2_outputpointer[0] = self.qiga2
        if self._qbga_outputflag:
            self._qbga_outputpointer[0] = self.qbga
@cython.final
cdef class LogSequences:
    cdef public double[:] loggedteml
    cdef public int _loggedteml_ndim
    cdef public int _loggedteml_length
    cdef public int _loggedteml_length_0
    cdef public double[:] loggedrelativehumidity
    cdef public int _loggedrelativehumidity_ndim
    cdef public int _loggedrelativehumidity_length
    cdef public int _loggedrelativehumidity_length_0
    cdef public double[:] loggedsunshineduration
    cdef public int _loggedsunshineduration_ndim
    cdef public int _loggedsunshineduration_length
    cdef public int _loggedsunshineduration_length_0
    cdef public double[:] loggedpossiblesunshineduration
    cdef public int _loggedpossiblesunshineduration_ndim
    cdef public int _loggedpossiblesunshineduration_length
    cdef public int _loggedpossiblesunshineduration_length_0
    cdef public double[:] loggedglobalradiation
    cdef public int _loggedglobalradiation_ndim
    cdef public int _loggedglobalradiation_length
    cdef public int _loggedglobalradiation_length_0
    cdef public double[:] loggedwindspeed2m
    cdef public int _loggedwindspeed2m_ndim
    cdef public int _loggedwindspeed2m_length
    cdef public int _loggedwindspeed2m_length_0
@cython.final
cdef class AideSequences:
    cdef public double[:] snratio
    cdef public int _snratio_ndim
    cdef public int _snratio_length
    cdef public int _snratio_length_0
    cdef public double[:] rlatm
    cdef public int _rlatm_ndim
    cdef public int _rlatm_length
    cdef public int _rlatm_length_0
    cdef public double[:] temps
    cdef public int _temps_ndim
    cdef public int _temps_length
    cdef public int _temps_length_0
@cython.final
cdef class OutletSequences:
    cdef double *q
    cdef public int _q_ndim
    cdef public int _q_length
    cpdef inline set_pointer0d(self, str name, pointerutils.Double value):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self.q = pointer.p_value
    cpdef get_value(self, str name):
        cdef int idx
        if name == "q":
            return self.q[0]
    cpdef set_value(self, str name, value):
        if name == "q":
            self.q[0] = value

@cython.final
cdef class PegasusESnow(rootutils.PegasusBase):
    cdef public Model model
    def __init__(self, Model model):
        self.model = model
    cpdef double apply_method0(self, double x) nogil:
        return self.model.return_backwardeulererror_v1(x)
@cython.final
cdef class PegasusTempSSurface(rootutils.PegasusBase):
    cdef public Model model
    def __init__(self, Model model):
        self.model = model
    cpdef double apply_method0(self, double x) nogil:
        return self.model.return_energygainsnowsurface_v1(x)
@cython.final
cdef class Model:
    cdef public int idx_hru
    cdef public int idx_sim
    cdef public Parameters parameters
    cdef public Sequences sequences
    cdef public PegasusESnow pegasusesnow
    cdef public PegasusTempSSurface pegasustempssurface
    def __init__(self):
        self.pegasusesnow = PegasusESnow(self)
        self.pegasustempssurface = PegasusTempSSurface(self)
    cpdef inline void simulate(self, int idx)  nogil:
        self.idx_sim = idx
        self.load_data()
        self.update_inlets()
        self.run()
        self.new2old()
        self.update_outlets()
        self.update_outputs()
    cpdef inline void load_data(self) nogil:
        self.sequences.inputs.load_data(self.idx_sim)
    cpdef inline void save_data(self, int idx) nogil:
        self.sequences.inputs.save_data(self.idx_sim)
        self.sequences.fluxes.save_data(self.idx_sim)
        self.sequences.states.save_data(self.idx_sim)
    cpdef inline void new2old(self) nogil:
        cdef int jdx0
        for jdx0 in range(self.sequences.states._inzp_length_0):
            self.sequences.old_states.inzp[jdx0] = self.sequences.new_states.inzp[jdx0]
        for jdx0 in range(self.sequences.states._wats_length_0):
            self.sequences.old_states.wats[jdx0] = self.sequences.new_states.wats[jdx0]
        for jdx0 in range(self.sequences.states._waes_length_0):
            self.sequences.old_states.waes[jdx0] = self.sequences.new_states.waes[jdx0]
        for jdx0 in range(self.sequences.states._esnow_length_0):
            self.sequences.old_states.esnow[jdx0] = self.sequences.new_states.esnow[jdx0]
        for jdx0 in range(self.sequences.states._taus_length_0):
            self.sequences.old_states.taus[jdx0] = self.sequences.new_states.taus[jdx0]
        for jdx0 in range(self.sequences.states._ebdn_length_0):
            self.sequences.old_states.ebdn[jdx0] = self.sequences.new_states.ebdn[jdx0]
        for jdx0 in range(self.sequences.states._bowa_length_0):
            self.sequences.old_states.bowa[jdx0] = self.sequences.new_states.bowa[jdx0]
        self.sequences.old_states.qdgz1 = self.sequences.new_states.qdgz1
        self.sequences.old_states.qdgz2 = self.sequences.new_states.qdgz2
        self.sequences.old_states.qigz1 = self.sequences.new_states.qigz1
        self.sequences.old_states.qigz2 = self.sequences.new_states.qigz2
        self.sequences.old_states.qbgz = self.sequences.new_states.qbgz
        self.sequences.old_states.qdga1 = self.sequences.new_states.qdga1
        self.sequences.old_states.qdga2 = self.sequences.new_states.qdga2
        self.sequences.old_states.qiga1 = self.sequences.new_states.qiga1
        self.sequences.old_states.qiga2 = self.sequences.new_states.qiga2
        self.sequences.old_states.qbga = self.sequences.new_states.qbga
    cpdef inline void run(self) nogil:
        self.calc_qzh_v1()
        self.update_loggedteml_v1()
        self.calc_temltag_v1()
        self.update_loggedrelativehumidity_v1()
        self.calc_dailyrelativehumidity_v1()
        self.update_loggedsunshineduration_v1()
        self.calc_dailysunshineduration_v1()
        self.update_loggedpossiblesunshineduration_v1()
        self.calc_dailypossiblesunshineduration_v1()
        self.update_loggedglobalradiation_v1()
        self.calc_dailyglobalradiation_v1()
        self.calc_nkor_v1()
        self.calc_tkor_v1()
        self.calc_tkortag_v1()
        self.calc_windspeed2m_v1()
        self.calc_reducedwindspeed2m_v1()
        self.update_loggedwindspeed2m_v1()
        self.calc_dailywindspeed2m_v1()
        self.calc_windspeed10m_v1()
        self.calc_saturationvapourpressure_v1()
        self.calc_dailysaturationvapourpressure_v1()
        self.calc_saturationvapourpressureslope_v1()
        self.calc_dailysaturationvapourpressureslope_v1()
        self.calc_actualvapourpressure_v1()
        self.calc_dailyactualvapourpressure_v1()
        self.calc_nbes_inzp_v1()
        self.calc_snratio_v1()
        self.calc_sbes_v1()
        self.calc_wats_v1()
        self.calc_wada_waes_v1()
        self.calc_wnied_esnow_v1()
        self.calc_temps_v1()
        self.update_taus_v1()
        self.calc_actualalbedo_v1()
        self.calc_netshortwaveradiationsnow_v1()
        self.calc_rlatm_v1()
        self.calc_tz_v1()
        self.calc_wg_v1()
        self.update_esnow_v1()
        self.calc_schmpot_v2()
        self.calc_schm_wats_v1()
        self.calc_gefrpot_v1()
        self.calc_gefr_wats_v1()
        self.calc_evs_waes_wats_v1()
        self.update_wada_waes_v1()
        self.update_esnow_v2()
        self.calc_netshortwaveradiation_v1()
        self.calc_dailynetshortwaveradiation_v1()
        self.calc_dailynetlongwaveradiation_v1()
        self.calc_netradiation_v1()
        self.calc_dailynetradiation_v1()
        self.calc_dryairpressure_v1()
        self.calc_densityair_v1()
        self.calc_aerodynamicresistance_v1()
        self.calc_soilsurfaceresistance_v1()
        self.calc_landusesurfaceresistance_v1()
        self.calc_actualsurfaceresistance_v1()
        self.calc_g_v2()
        self.calc_evpo_v2()
        self.calc_evi_inzp_v2()
        self.calc_evb_v2()
        self.update_ebdn_v1()
        self.calc_sff_v1()
        self.calc_fvg_v1()
        self.calc_qkap_v1()
        self.calc_qbb_v1()
        self.calc_qib1_v1()
        self.calc_qib2_v1()
        self.calc_qdb_v1()
        self.update_qdb_v1()
        self.calc_bowa_v1()
        self.calc_qbgz_v1()
        self.calc_qigz1_v1()
        self.calc_qigz2_v1()
        self.calc_qdgz_v1()
        self.calc_qbga_v1()
        self.update_qdgz_qbgz_qbga_v1()
        self.update_qdgz_qbgz_qbga_v2()
        self.calc_qiga1_v1()
        self.calc_qiga2_v1()
        self.calc_qdgz1_qdgz2_v1()
        self.calc_qdga1_v1()
        self.calc_qdga2_v1()
        self.calc_qah_v1()
        self.calc_qa_v1()
    cpdef inline void update_inlets(self) nogil:
        self.pick_qz_v1()
    cpdef inline void update_outlets(self) nogil:
        self.pass_qa_v1()
    cpdef inline void update_receivers(self, int idx) nogil:
        self.idx_sim = idx
        pass
    cpdef inline void update_senders(self, int idx) nogil:
        self.idx_sim = idx
        pass
    cpdef inline void update_outputs(self) nogil:
        self.sequences.fluxes.update_outputs()
        self.sequences.states.update_outputs()

    cpdef inline void pick_qz_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.qz = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.qz = self.sequences.fluxes.qz + (self.sequences.inlets.q[idx][0])
    cpdef inline void pick_qz(self)  nogil:
        cdef int idx
        self.sequences.fluxes.qz = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.qz = self.sequences.fluxes.qz + (self.sequences.inlets.q[idx][0])
    cpdef inline void calc_qzh_v1(self)  nogil:
        self.sequences.fluxes.qzh = self.sequences.fluxes.qz / self.parameters.derived.qfactor
    cpdef inline void update_loggedteml_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedteml[idx] = self.sequences.logs.loggedteml[idx - 1]
        self.sequences.logs.loggedteml[0] = self.sequences.inputs.teml
    cpdef inline void calc_temltag_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.temltag = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.temltag = self.sequences.fluxes.temltag + (self.sequences.logs.loggedteml[idx])
        self.sequences.fluxes.temltag = self.sequences.fluxes.temltag / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedrelativehumidity_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedrelativehumidity[idx] = self.sequences.logs.loggedrelativehumidity[idx - 1]
        self.sequences.logs.loggedrelativehumidity[0] = self.sequences.inputs.relativehumidity
    cpdef inline void calc_dailyrelativehumidity_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailyrelativehumidity = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity + (self.sequences.logs.loggedrelativehumidity[idx])
        self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedsunshineduration_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedsunshineduration[idx] = self.sequences.logs.loggedsunshineduration[idx - 1]
        self.sequences.logs.loggedsunshineduration[0] = self.sequences.inputs.sunshineduration
    cpdef inline void calc_dailysunshineduration_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailysunshineduration = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailysunshineduration = self.sequences.fluxes.dailysunshineduration + (self.sequences.logs.loggedsunshineduration[idx])
    cpdef inline void update_loggedpossiblesunshineduration_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedpossiblesunshineduration[                idx            ] = self.sequences.logs.loggedpossiblesunshineduration[idx - 1]
        self.sequences.logs.loggedpossiblesunshineduration[0] = self.sequences.inputs.possiblesunshineduration
    cpdef inline void calc_dailypossiblesunshineduration_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailypossiblesunshineduration = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailypossiblesunshineduration = self.sequences.fluxes.dailypossiblesunshineduration + (self.sequences.logs.loggedpossiblesunshineduration[idx])
    cpdef inline void update_loggedglobalradiation_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedglobalradiation[idx] = self.sequences.logs.loggedglobalradiation[idx - 1]
        self.sequences.logs.loggedglobalradiation[0] = self.sequences.inputs.globalradiation
    cpdef inline void calc_dailyglobalradiation_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailyglobalradiation = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailyglobalradiation = self.sequences.fluxes.dailyglobalradiation + (self.sequences.logs.loggedglobalradiation[idx])
        self.sequences.fluxes.dailyglobalradiation = self.sequences.fluxes.dailyglobalradiation / (self.parameters.derived.nmblogentries)
    cpdef inline void calc_nkor_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.nkor[k] = self.parameters.control.kg[k] * self.sequences.inputs.nied
    cpdef inline void calc_tkor_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkor[k] = self.parameters.control.kt[k] + self.sequences.inputs.teml
    cpdef inline void calc_tkortag_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkortag[k] = self.parameters.control.kt[k] + self.sequences.fluxes.temltag
    cpdef inline void calc_windspeed2m_v1(self)  nogil:
        self.sequences.fluxes.windspeed2m = self.return_adjustedwindspeed_v1(2.0)
    cpdef inline void calc_reducedwindspeed2m_v1(self)  nogil:
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                self.sequences.fluxes.reducedwindspeed2m[k] = (                    max(self.parameters.control.p1wind - self.parameters.control.p2wind * d_lai, 0.0) * self.sequences.fluxes.windspeed2m                )
            else:
                self.sequences.fluxes.reducedwindspeed2m[k] = self.sequences.fluxes.windspeed2m
    cpdef inline void update_loggedwindspeed2m_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedwindspeed2m[idx] = self.sequences.logs.loggedwindspeed2m[idx - 1]
        self.sequences.logs.loggedwindspeed2m[0] = self.sequences.fluxes.windspeed2m
    cpdef inline void calc_dailywindspeed2m_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailywindspeed2m = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m + (self.sequences.logs.loggedwindspeed2m[idx])
        self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m / (self.parameters.derived.nmblogentries)
    cpdef inline void calc_windspeed10m_v1(self)  nogil:
        self.sequences.fluxes.windspeed10m = self.return_adjustedwindspeed_v1(10.0)
    cpdef inline void calc_saturationvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressure[k] = self.return_saturationvapourpressure_v1(                self.sequences.fluxes.tkor[k]            )
    cpdef inline void calc_dailysaturationvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressure[                k            ] = self.return_saturationvapourpressure_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_saturationvapourpressureslope_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkor[k])
    cpdef inline void calc_dailysaturationvapourpressureslope_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_actualvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.actualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.saturationvapourpressure[k], self.sequences.inputs.relativehumidity            )
    cpdef inline void calc_dailyactualvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailyactualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.dailysaturationvapourpressure[k],                self.sequences.fluxes.dailyrelativehumidity,            )
    cpdef inline void calc_nbes_inzp_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.nbes[k] = 0.0
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.nbes[k] = max(                    self.sequences.fluxes.nkor[k]                    + self.sequences.states.inzp[k]                    - self.parameters.derived.kinz[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]],                    0.0,                )
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] + (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.nbes[k])
    cpdef inline void calc_snratio_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.fluxes.tkor[k] >= (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 0.0
            elif self.sequences.fluxes.tkor[k] <= (self.parameters.control.tgr[k] - self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 1.0
            else:
                self.sequences.aides.snratio[k] = (                    (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0) - self.sequences.fluxes.tkor[k]                ) / self.parameters.control.tsp[k]
    cpdef inline void calc_sbes_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.sbes[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbes[k]
    cpdef inline void calc_wats_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k])
    cpdef inline void calc_wada_waes_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.waes[k] = 0.0
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.nbes[k]
            else:
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
    cpdef inline void calc_wnied_esnow_v1(self)  nogil:
        cdef double d_water
        cdef double d_ice
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wnied[k] = 0.0
                self.sequences.states.esnow[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k] - self.sequences.fluxes.wada[k])
                self.sequences.fluxes.wnied[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
                self.sequences.states.esnow[k] = self.sequences.states.esnow[k] + (self.sequences.fluxes.wnied[k])
    cpdef inline void calc_temps_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
    cpdef inline void update_taus_v1(self)  nogil:
        cdef double d_r2
        cdef double d_r1
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                if isnan(self.sequences.states.taus[k]):
                    self.sequences.states.taus[k] = 0.0
                d_r1 = exp(                    5000.0 * (1 / 273.15 - 1.0 / (273.15 + self.sequences.aides.temps[k]))                )
                d_r2 = min(d_r1**10, 1.0)
                self.sequences.states.taus[k] = self.sequences.states.taus[k] * (max(1 - 0.1 * self.sequences.fluxes.sbes[k], 0.0))
                self.sequences.states.taus[k] = self.sequences.states.taus[k] + ((d_r1 + d_r2 + 0.03) / 1e6 * self.parameters.derived.seconds)
            else:
                self.sequences.states.taus[k] = nan
    cpdef inline void calc_actualalbedo_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo0snow * (                    1.0 - self.parameters.control.snowagingfactor * self.sequences.states.taus[k] / (1.0 + self.sequences.states.taus[k])                )
            else:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_netshortwaveradiationsnow_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiationsnow[k] = (                self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]                * (1.0 - self.sequences.fluxes.actualalbedo[k])                * self.sequences.inputs.globalradiation            )
    cpdef inline void calc_rlatm_v1(self)  nogil:
        cdef double d_t
        cdef int k
        cdef double d_common
        cdef double d_rs
        d_rs = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        d_common = self.parameters.fixed.fratm * self.parameters.fixed.sigma * (1.0 + 0.22 * (1.0 - d_rs) ** 2)
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.aides.rlatm[k] = d_common * (                d_t**4 * (self.sequences.fluxes.actualvapourpressure[k] / d_t) ** (1.0 / 7.0)            )
    cpdef inline void calc_tz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.tz[k] = nan
            elif self.sequences.states.ebdn[k] < 0.0:
                self.sequences.fluxes.tz[k] = self.sequences.states.ebdn[k] / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
            elif self.sequences.states.ebdn[k] < self.parameters.derived.heatoffusion[k]:
                self.sequences.fluxes.tz[k] = 0.0
            else:
                self.sequences.fluxes.tz[k] = (self.sequences.states.ebdn[k] - self.parameters.derived.heatoffusion[k]) / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
    cpdef inline void calc_wg_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.wg[k] = 0.0
            else:
                self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
    cpdef inline void update_esnow_v1(self)  nogil:
        cdef double d_esnow
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.idx_hru = k
                d_esnow = self.sequences.states.esnow[k]
                self.sequences.states.esnow[k] = self.pegasusesnow.find_x(                    self.return_esnow_v1(k, -30.0),                    self.return_esnow_v1(k, 30.0),                    self.return_esnow_v1(k, -100.0),                    self.return_esnow_v1(k, 100.0),                    0.0,                    1e-8,                    10,                )
                if self.sequences.states.esnow[k] > 0.0:
                    self.sequences.aides.temps[k] = 0.0
                    self.sequences.fluxes.tempssurface[k] = self.return_tempssurface(k)
                    self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
                    self.sequences.states.esnow[k] = d_esnow + self.sequences.fluxes.wg[k] - self.sequences.fluxes.wsurf[k]
            else:
                self.sequences.states.esnow[k] = 0.0
                self.sequences.aides.temps[k] = nan
                self.sequences.fluxes.tempssurface[k] = nan
                self.sequences.fluxes.netlongwaveradiationsnow[k] = 0.0
                self.sequences.fluxes.netradiationsnow[k] = 0.0
                self.sequences.fluxes.saturationvapourpressuresnow[k] = 0.0
                self.sequences.fluxes.wsenssnow[k] = 0.0
                self.sequences.fluxes.wlatsnow[k] = 0.0
                self.sequences.fluxes.wsurf[k] = 0.0
    cpdef inline void calc_schmpot_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.schmpot[k] = max(self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0.0)
            else:
                self.sequences.fluxes.schmpot[k] = 0.0
    cpdef inline void calc_schm_wats_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.schm[k] = 0.0
            else:
                self.sequences.fluxes.schm[k] = min(self.sequences.fluxes.schmpot[k], self.sequences.states.wats[k])
                self.sequences.states.wats[k] = self.sequences.states.wats[k] - (self.sequences.fluxes.schm[k])
    cpdef inline void calc_gefrpot_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                self.sequences.fluxes.gefrpot[k] = max(-self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0)
            else:
                self.sequences.fluxes.gefrpot[k] = 0.0
    cpdef inline void calc_gefr_wats_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE) or not self.parameters.control.refreezeflag:
                self.sequences.fluxes.gefr[k] = 0.0
            else:
                self.sequences.fluxes.gefr[k] = min(self.sequences.fluxes.gefrpot[k], (self.sequences.states.waes[k] - self.sequences.states.wats[k]))
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.gefr[k])
    cpdef inline void calc_evs_waes_wats_v1(self)  nogil:
        cdef double d_frac
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS) or (self.sequences.states.waes[k] <= 0.0):
                self.sequences.fluxes.evs[k] = 0.0
                self.sequences.states.waes[k] = 0.0
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.fluxes.evs[k] = min(self.sequences.fluxes.wlatsnow[k] / self.parameters.fixed.lwe, self.sequences.states.waes[k])
                d_frac = (self.sequences.states.waes[k] - self.sequences.fluxes.evs[k]) / self.sequences.states.waes[k]
                self.sequences.states.waes[k] = self.sequences.states.waes[k] * (d_frac)
                self.sequences.states.wats[k] = self.sequences.states.wats[k] * (d_frac)
    cpdef inline void update_wada_waes_v1(self)  nogil:
        cdef double d_wada_corr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE):
                d_wada_corr = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] + (d_wada_corr)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (d_wada_corr)
    cpdef inline void update_esnow_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE)) or (self.sequences.states.waes[k] <= 0.0):
                self.sequences.states.esnow[k] = 0.0
            else:
                self.sequences.states.esnow[k] = self.sequences.states.esnow[k] + (self.parameters.fixed.rschmelz * (self.sequences.fluxes.gefr[k] - self.sequences.fluxes.schm[k]))
    cpdef inline void calc_netshortwaveradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.inputs.globalradiation
    cpdef inline void calc_dailynetshortwaveradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.fluxes.dailyglobalradiation
    cpdef inline void calc_dailynetlongwaveradiation_v1(self)  nogil:
        cdef double d_temp
        cdef int k
        cdef double d_relsunshine
        d_relsunshine = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        for k in range(self.parameters.control.nhru):
            d_temp = self.sequences.fluxes.tkortag[k] + 273.15
            self.sequences.fluxes.dailynetlongwaveradiation[k] = (                (0.2 + 0.8 * d_relsunshine)                * (self.parameters.fixed.sigma * d_temp**4)                * (                    self.parameters.control.emissivity                    - self.parameters.fixed.fratm                    * (self.sequences.fluxes.dailyactualvapourpressure[k] / d_temp) ** (1.0 / 7.0)                )            )
    cpdef inline void calc_netradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.netshortwaveradiation[k], self.sequences.fluxes.dailynetlongwaveradiation[k]            )
    cpdef inline void calc_dailynetradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.dailynetshortwaveradiation[k],                self.sequences.fluxes.dailynetlongwaveradiation[k],            )
    cpdef inline void calc_dryairpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dryairpressure[k] = (                self.sequences.inputs.atmosphericpressure - self.sequences.fluxes.actualvapourpressure[k]            )
    cpdef inline void calc_densityair_v1(self)  nogil:
        cdef double d_t
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.fluxes.densityair[k] = 100.0 * (                self.sequences.fluxes.dryairpressure[k] / (self.parameters.fixed.rdryair * d_t)                + self.sequences.fluxes.actualvapourpressure[k] / (self.parameters.fixed.rwatervapour * d_t)            )
    cpdef inline void calc_aerodynamicresistance_v1(self)  nogil:
        cdef double d_z0
        cdef double d_ch
        cdef int k
        if self.sequences.fluxes.windspeed10m > 0.0:
            for k in range(self.parameters.control.nhru):
                d_ch = self.parameters.control.cropheight[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                if d_ch < 10.0:
                    d_z0 = 0.021 + 0.163 * d_ch
                    self.sequences.fluxes.aerodynamicresistance[k] = (                        6.25 / self.sequences.fluxes.windspeed10m * log(10.0 / d_z0) ** 2                    )
                else:
                    self.sequences.fluxes.aerodynamicresistance[k] = 94.0 / self.sequences.fluxes.windspeed10m
        else:
            for k in range(self.parameters.control.nhru):
                self.sequences.fluxes.aerodynamicresistance[k] = inf
    cpdef inline void calc_soilsurfaceresistance_v1(self)  nogil:
        cdef double d_free
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.soilsurfaceresistance[k] = nan
            elif self.parameters.derived.nfk[k] > 20.0:
                self.sequences.fluxes.soilsurfaceresistance[k] = 100.0
            elif self.parameters.derived.nfk[k] > 0.0:
                d_free = min(max(self.sequences.states.bowa[k] - self.parameters.control.pwp[k], 0.0), self.parameters.derived.nfk[k])
                self.sequences.fluxes.soilsurfaceresistance[k] = (                    100.0 * self.parameters.derived.nfk[k] / (d_free + 0.01 * self.parameters.derived.nfk[k])                )
            else:
                self.sequences.fluxes.soilsurfaceresistance[k] = inf
    cpdef inline void calc_landusesurfaceresistance_v1(self)  nogil:
        cdef double d_def
        cdef double d_res
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_res = self.parameters.control.surfaceresistance[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            if self.parameters.control.lnk[k] == NADELW:
                d_def = self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k]
                if (self.sequences.fluxes.tkor[k] <= -5.0) or (d_def >= 20.0):
                    self.sequences.fluxes.landusesurfaceresistance[k] = 10000.0
                elif self.sequences.fluxes.tkor[k] < 20.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        (25.0 * d_res) / (self.sequences.fluxes.tkor[k] + 5.0) / (1.0 - 0.05 * d_def),                        10000.0,                    )
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        d_res / (1.0 - 0.05 * d_def), 10000.0                    )
            else:
                self.sequences.fluxes.landusesurfaceresistance[k] = d_res
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE, VERS):
                if self.sequences.states.bowa[k] <= 0.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = inf
                elif self.sequences.states.bowa[k] < self.parameters.control.py[k]:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (3.5 * (                        1.0 - self.sequences.states.bowa[k] / self.parameters.control.py[k]                    ) + exp(0.2 * self.parameters.control.py[k] / self.sequences.states.bowa[k]))
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (exp(0.2))
    cpdef inline void calc_actualsurfaceresistance_v1(self)  nogil:
        cdef double d_invrestnight
        cdef double d_invrestday
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.actualsurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k]
            else:
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                d_invrestday = (                    (1.0 - 0.7**d_lai) / self.sequences.fluxes.landusesurfaceresistance[k]                ) + 0.7**d_lai / self.sequences.fluxes.soilsurfaceresistance[k]
                d_invrestnight = d_lai / 2500.0 + 1.0 / self.sequences.fluxes.soilsurfaceresistance[k]
                self.sequences.fluxes.actualsurfaceresistance[k] = 1.0 / (                    (                        self.sequences.inputs.possiblesunshineduration / self.parameters.derived.hours * d_invrestday                        + (1.0 - self.sequences.inputs.possiblesunshineduration / self.parameters.derived.hours)                        * d_invrestnight                    )                )
    cpdef inline void calc_g_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.g[k] = 0.0
            else:
                self.sequences.fluxes.g[k] = self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_evpo_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS):
                self.sequences.fluxes.evpo[k] = self.return_penman_v1(k)
            else:
                self.sequences.fluxes.evpo[k] = self.return_penmanmonteith_v1(k, 0.0)
    cpdef inline void calc_evi_inzp_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.evi[k] = self.sequences.fluxes.evpo[k]
                self.sequences.states.inzp[k] = 0.0
            elif self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) or self.sequences.states.waes[k] == 0:
                self.sequences.fluxes.evi[k] = min(self.sequences.fluxes.evpo[k], self.sequences.states.inzp[k])
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
            else:
                self.sequences.fluxes.evi[k] = 0.0
    cpdef inline void calc_evb_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or ((self.parameters.control.lnk[k] not in (LAUBW, MISCHW, NADELW) and self.sequences.states.waes[k] > 0.0))                or (self.sequences.fluxes.evpo[k] == 0.0)            ):
                self.sequences.fluxes.evb[k] = 0.0
            else:
                self.sequences.fluxes.evb[k] = (                    (self.sequences.fluxes.evpo[k] - self.sequences.fluxes.evi[k])                    / self.sequences.fluxes.evpo[k]                    * self.return_penmanmonteith_v1(                        k,                        self.sequences.fluxes.actualsurfaceresistance[k],                    )                )
    cpdef inline void update_ebdn_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.ebdn[k] = 0.0
            else:
                self.sequences.states.ebdn[k] = self.sequences.states.ebdn[k] + (self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]] - self.sequences.fluxes.wg[k])
    cpdef inline void calc_sff_v1(self)  nogil:
        cdef double d_sff
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.sff[k] = 0.0
            else:
                d_sff = 1.0 - self.sequences.states.ebdn[k] / (self.parameters.fixed.bowa2z[k] * self.parameters.fixed.rschmelz)
                self.sequences.fluxes.sff[k] = min(max(d_sff, 0.0), 1.0)
    cpdef inline void calc_fvg_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.fvg[k] = 0.0
            else:
                self.sequences.fluxes.fvg[k] = min(self.parameters.control.fvf * self.sequences.fluxes.sff[k] ** self.parameters.control.bsff, 1.0)
    cpdef inline void calc_qkap_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qkap[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 0]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k]
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 1]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k] * (                    1.0                    - (self.sequences.states.bowa[k] - self.parameters.control.kapgrenz[k, 0])                    / (self.parameters.control.kapgrenz[k, 1] - self.parameters.control.kapgrenz[k, 0])                )
            else:
                self.sequences.fluxes.qkap[k] = 0
    cpdef inline void calc_qbb_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.pwp[k])                or (self.parameters.control.wmax[k] <= 0.0)            ):
                self.sequences.fluxes.qbb[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.fk[k]:
                if self.parameters.control.rbeta:
                    self.sequences.fluxes.qbb[k] = 0.0
                else:
                    self.sequences.fluxes.qbb[k] = self.parameters.control.beta[k] * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])
            else:
                self.sequences.fluxes.qbb[k] = (                    self.parameters.control.beta[k]                    * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])                    * (                        1.0                        + (self.parameters.control.fbeta[k] - 1.0)                        * (self.sequences.states.bowa[k] - self.parameters.control.fk[k])                        / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                    )                )
    cpdef inline void calc_qib1_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (                self.sequences.states.bowa[k] <= self.parameters.control.pwp[k]            ):
                self.sequences.fluxes.qib1[k] = 0.0
            else:
                self.sequences.fluxes.qib1[k] = self.parameters.control.dmin[k] * (self.sequences.states.bowa[k] / self.parameters.control.wmax[k])
    cpdef inline void calc_qib2_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.fk[k])                or (self.parameters.control.wmax[k] <= self.parameters.control.fk[k])            ):
                self.sequences.fluxes.qib2[k] = 0.0
            else:
                self.sequences.fluxes.qib2[k] = (self.parameters.control.dmax[k] - self.parameters.control.dmin[k]) * (                    (self.sequences.states.bowa[k] - self.parameters.control.fk[k]) / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                ) ** 1.5
    cpdef inline void calc_qdb_v1(self)  nogil:
        cdef double d_exz
        cdef double d_sfa
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qdb[k] = 0.0
            elif (self.parameters.control.lnk[k] in (VERS, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.wada[k]
            else:
                if self.sequences.states.bowa[k] < self.parameters.control.wmax[k]:
                    d_sfa = (1.0 - self.sequences.states.bowa[k] / self.parameters.control.wmax[k]) ** (                        1.0 / (self.parameters.control.bsf[k] + 1.0)                    ) - (self.sequences.fluxes.wada[k] / ((self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k]))
                else:
                    d_sfa = 0.0
                d_exz = self.sequences.states.bowa[k] + self.sequences.fluxes.wada[k] - self.parameters.control.wmax[k]
                self.sequences.fluxes.qdb[k] = d_exz
                if d_sfa > 0.0:
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (d_sfa ** (self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k])
                self.sequences.fluxes.qdb[k] = max(self.sequences.fluxes.qdb[k], 0.0)
    cpdef inline void update_qdb_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (self.sequences.fluxes.fvg[k] * (self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k]))
    cpdef inline void calc_bowa_v1(self)  nogil:
        cdef double d_factor
        cdef double d_rvl
        cdef double d_incr
        cdef double d_decr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                d_decr = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k] + self.sequences.fluxes.qdb[k]
                d_incr = self.sequences.fluxes.wada[k] + self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    d_decr = d_decr + (self.sequences.fluxes.evb[k])
                else:
                    d_incr = d_incr - (self.sequences.fluxes.evb[k])
                if d_decr > self.sequences.states.bowa[k] + d_incr:
                    d_rvl = (self.sequences.states.bowa[k] + d_incr) / d_decr
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_rvl)
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (d_rvl)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (d_rvl)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (d_rvl)
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] * (d_rvl)
                    self.sequences.states.bowa[k] = 0.0
                else:
                    self.sequences.states.bowa[k] = (self.sequences.states.bowa[k] + d_incr) - d_decr
                    if self.sequences.states.bowa[k] > self.parameters.control.wmax[k]:
                        d_factor = (self.sequences.states.bowa[k] - self.parameters.control.wmax[k]) / d_incr
                        if self.sequences.fluxes.evb[k] < 0.0:
                            self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_factor)
                        self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] * (d_factor)
                        self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (d_factor)
                        self.sequences.states.bowa[k] = self.parameters.control.wmax[k]
    cpdef inline void calc_qbgz_v1(self)  nogil:
        cdef int k
        self.sequences.states.qbgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == SEE:
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, FLUSS, VERS):
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.qbb[k] - self.sequences.fluxes.qkap[k]))
    cpdef inline void calc_qigz1_v1(self)  nogil:
        cdef int k
        self.sequences.states.qigz1 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz1 = self.sequences.states.qigz1 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib1[k])
    cpdef inline void calc_qigz2_v1(self)  nogil:
        cdef int k
        self.sequences.states.qigz2 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz2 = self.sequences.states.qigz2 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib2[k])
    cpdef inline void calc_qdgz_v1(self)  nogil:
        cdef int k
        self.sequences.fluxes.qdgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == FLUSS:
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, SEE):
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * self.sequences.fluxes.qdb[k])
    cpdef inline void calc_qbga_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kb <= 0.0:
            self.sequences.new_states.qbga = self.sequences.new_states.qbgz
        elif self.parameters.derived.kb > 1e200:
            self.sequences.new_states.qbga = self.sequences.old_states.qbga + self.sequences.new_states.qbgz - self.sequences.old_states.qbgz
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kb)
            self.sequences.new_states.qbga = (                self.sequences.old_states.qbga                + (self.sequences.old_states.qbgz - self.sequences.old_states.qbga) * d_temp                + (self.sequences.new_states.qbgz - self.sequences.old_states.qbgz) * (1.0 - self.parameters.derived.kb * d_temp)            )
    cpdef inline void update_qdgz_qbgz_qbga_v1(self)  nogil:
        cdef double d_qbgz_adj
        cdef double d_temp
        if self.sequences.new_states.qbga > self.parameters.derived.qbgamax:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kb)
            d_qbgz_adj = self.sequences.old_states.qbgz + (                (self.parameters.derived.qbgamax - self.sequences.old_states.qbga - (self.sequences.old_states.qbgz - self.sequences.old_states.qbga) * d_temp)                / (1.0 - self.parameters.derived.kb * d_temp)            )
            self.sequences.new_states.qbga = self.parameters.derived.qbgamax
            self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.sequences.new_states.qbgz - d_qbgz_adj)
            self.sequences.new_states.qbgz = d_qbgz_adj
    cpdef inline void update_qdgz_qbgz_qbga_v2(self)  nogil:
        cdef double d_qbgz_exc
        cdef double d_grad
        d_grad = self.parameters.derived.kb * (self.sequences.new_states.qbga - self.sequences.old_states.qbga)
        if d_grad > self.parameters.control.gsbgrad1:
            if d_grad < self.parameters.control.gsbgrad2:
                d_qbgz_exc = self.sequences.new_states.qbgz * (                    (d_grad - self.parameters.control.gsbgrad1) / (self.parameters.control.gsbgrad2 - self.parameters.control.gsbgrad1)                )
            else:
                d_qbgz_exc = self.sequences.new_states.qbgz
            self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (d_qbgz_exc)
            self.sequences.new_states.qbgz = self.sequences.new_states.qbgz - (d_qbgz_exc)
            self.calc_qbga_v1()
    cpdef inline void calc_qiga1_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki1 <= 0.0:
            self.sequences.new_states.qiga1 = self.sequences.new_states.qigz1
        elif self.parameters.derived.ki1 > 1e200:
            self.sequences.new_states.qiga1 = self.sequences.old_states.qiga1 + self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki1)
            self.sequences.new_states.qiga1 = (                self.sequences.old_states.qiga1                + (self.sequences.old_states.qigz1 - self.sequences.old_states.qiga1) * d_temp                + (self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1) * (1.0 - self.parameters.derived.ki1 * d_temp)            )
    cpdef inline void calc_qiga2_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki2 <= 0.0:
            self.sequences.new_states.qiga2 = self.sequences.new_states.qigz2
        elif self.parameters.derived.ki2 > 1e200:
            self.sequences.new_states.qiga2 = self.sequences.old_states.qiga2 + self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki2)
            self.sequences.new_states.qiga2 = (                self.sequences.old_states.qiga2                + (self.sequences.old_states.qigz2 - self.sequences.old_states.qiga2) * d_temp                + (self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2) * (1.0 - self.parameters.derived.ki2 * d_temp)            )
    cpdef inline void calc_qdgz1_qdgz2_v1(self)  nogil:
        if self.sequences.fluxes.qdgz > self.parameters.control.a2:
            self.sequences.states.qdgz2 = (self.sequences.fluxes.qdgz - self.parameters.control.a2) ** 2 / (self.sequences.fluxes.qdgz + self.parameters.control.a1 - self.parameters.control.a2)
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz - self.sequences.states.qdgz2
        else:
            self.sequences.states.qdgz2 = 0.0
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz
    cpdef inline void calc_qdga1_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd1 <= 0.0:
            self.sequences.new_states.qdga1 = self.sequences.new_states.qdgz1
        elif self.parameters.derived.kd1 > 1e200:
            self.sequences.new_states.qdga1 = self.sequences.old_states.qdga1 + self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd1)
            self.sequences.new_states.qdga1 = (                self.sequences.old_states.qdga1                + (self.sequences.old_states.qdgz1 - self.sequences.old_states.qdga1) * d_temp                + (self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1) * (1.0 - self.parameters.derived.kd1 * d_temp)            )
    cpdef inline void calc_qdga2_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd2 <= 0.0:
            self.sequences.new_states.qdga2 = self.sequences.new_states.qdgz2
        elif self.parameters.derived.kd2 > 1e200:
            self.sequences.new_states.qdga2 = self.sequences.old_states.qdga2 + self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd2)
            self.sequences.new_states.qdga2 = (                self.sequences.old_states.qdga2                + (self.sequences.old_states.qdgz2 - self.sequences.old_states.qdga2) * d_temp                + (self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2) * (1.0 - self.parameters.derived.kd2 * d_temp)            )
    cpdef inline void calc_qah_v1(self)  nogil:
        cdef double d_epw
        cdef int k
        cdef double d_area
        self.sequences.fluxes.qah = self.sequences.fluxes.qzh + self.sequences.states.qbga + self.sequences.states.qiga1 + self.sequences.states.qiga2 + self.sequences.states.qdga1 + self.sequences.states.qdga2
        if (not self.parameters.control.negq) and (self.sequences.fluxes.qah < 0.0):
            d_area = 0.0
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] in (FLUSS, SEE):
                    d_area = d_area + (self.parameters.control.fhru[k])
            if d_area > 0.0:
                for k in range(self.parameters.control.nhru):
                    if self.parameters.control.lnk[k] in (FLUSS, SEE):
                        self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] + (self.sequences.fluxes.qah / d_area)
            self.sequences.fluxes.qah = 0.0
        d_epw = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qah = self.sequences.fluxes.qah + (self.parameters.control.fhru[k] * self.sequences.fluxes.nkor[k])
                d_epw = d_epw + (self.parameters.control.fhru[k] * self.sequences.fluxes.evi[k])
        if (self.sequences.fluxes.qah > d_epw) or self.parameters.control.negq:
            self.sequences.fluxes.qah = self.sequences.fluxes.qah - (d_epw)
        elif d_epw > 0.0:
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] == WASSER:
                    self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] * (self.sequences.fluxes.qah / d_epw)
            self.sequences.fluxes.qah = 0.0
    cpdef inline void calc_qa_v1(self)  nogil:
        self.sequences.fluxes.qa = self.parameters.derived.qfactor * self.sequences.fluxes.qah
    cpdef inline void calc_qzh(self)  nogil:
        self.sequences.fluxes.qzh = self.sequences.fluxes.qz / self.parameters.derived.qfactor
    cpdef inline void update_loggedteml(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedteml[idx] = self.sequences.logs.loggedteml[idx - 1]
        self.sequences.logs.loggedteml[0] = self.sequences.inputs.teml
    cpdef inline void calc_temltag(self)  nogil:
        cdef int idx
        self.sequences.fluxes.temltag = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.temltag = self.sequences.fluxes.temltag + (self.sequences.logs.loggedteml[idx])
        self.sequences.fluxes.temltag = self.sequences.fluxes.temltag / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedrelativehumidity(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedrelativehumidity[idx] = self.sequences.logs.loggedrelativehumidity[idx - 1]
        self.sequences.logs.loggedrelativehumidity[0] = self.sequences.inputs.relativehumidity
    cpdef inline void calc_dailyrelativehumidity(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailyrelativehumidity = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity + (self.sequences.logs.loggedrelativehumidity[idx])
        self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedsunshineduration(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedsunshineduration[idx] = self.sequences.logs.loggedsunshineduration[idx - 1]
        self.sequences.logs.loggedsunshineduration[0] = self.sequences.inputs.sunshineduration
    cpdef inline void calc_dailysunshineduration(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailysunshineduration = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailysunshineduration = self.sequences.fluxes.dailysunshineduration + (self.sequences.logs.loggedsunshineduration[idx])
    cpdef inline void update_loggedpossiblesunshineduration(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedpossiblesunshineduration[                idx            ] = self.sequences.logs.loggedpossiblesunshineduration[idx - 1]
        self.sequences.logs.loggedpossiblesunshineduration[0] = self.sequences.inputs.possiblesunshineduration
    cpdef inline void calc_dailypossiblesunshineduration(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailypossiblesunshineduration = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailypossiblesunshineduration = self.sequences.fluxes.dailypossiblesunshineduration + (self.sequences.logs.loggedpossiblesunshineduration[idx])
    cpdef inline void update_loggedglobalradiation(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedglobalradiation[idx] = self.sequences.logs.loggedglobalradiation[idx - 1]
        self.sequences.logs.loggedglobalradiation[0] = self.sequences.inputs.globalradiation
    cpdef inline void calc_dailyglobalradiation(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailyglobalradiation = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailyglobalradiation = self.sequences.fluxes.dailyglobalradiation + (self.sequences.logs.loggedglobalradiation[idx])
        self.sequences.fluxes.dailyglobalradiation = self.sequences.fluxes.dailyglobalradiation / (self.parameters.derived.nmblogentries)
    cpdef inline void calc_nkor(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.nkor[k] = self.parameters.control.kg[k] * self.sequences.inputs.nied
    cpdef inline void calc_tkor(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkor[k] = self.parameters.control.kt[k] + self.sequences.inputs.teml
    cpdef inline void calc_tkortag(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkortag[k] = self.parameters.control.kt[k] + self.sequences.fluxes.temltag
    cpdef inline void calc_windspeed2m(self)  nogil:
        self.sequences.fluxes.windspeed2m = self.return_adjustedwindspeed_v1(2.0)
    cpdef inline void calc_reducedwindspeed2m(self)  nogil:
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                self.sequences.fluxes.reducedwindspeed2m[k] = (                    max(self.parameters.control.p1wind - self.parameters.control.p2wind * d_lai, 0.0) * self.sequences.fluxes.windspeed2m                )
            else:
                self.sequences.fluxes.reducedwindspeed2m[k] = self.sequences.fluxes.windspeed2m
    cpdef inline void update_loggedwindspeed2m(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedwindspeed2m[idx] = self.sequences.logs.loggedwindspeed2m[idx - 1]
        self.sequences.logs.loggedwindspeed2m[0] = self.sequences.fluxes.windspeed2m
    cpdef inline void calc_dailywindspeed2m(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailywindspeed2m = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m + (self.sequences.logs.loggedwindspeed2m[idx])
        self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m / (self.parameters.derived.nmblogentries)
    cpdef inline void calc_windspeed10m(self)  nogil:
        self.sequences.fluxes.windspeed10m = self.return_adjustedwindspeed_v1(10.0)
    cpdef inline void calc_saturationvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressure[k] = self.return_saturationvapourpressure_v1(                self.sequences.fluxes.tkor[k]            )
    cpdef inline void calc_dailysaturationvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressure[                k            ] = self.return_saturationvapourpressure_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_saturationvapourpressureslope(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkor[k])
    cpdef inline void calc_dailysaturationvapourpressureslope(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_actualvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.actualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.saturationvapourpressure[k], self.sequences.inputs.relativehumidity            )
    cpdef inline void calc_dailyactualvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailyactualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.dailysaturationvapourpressure[k],                self.sequences.fluxes.dailyrelativehumidity,            )
    cpdef inline void calc_nbes_inzp(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.nbes[k] = 0.0
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.nbes[k] = max(                    self.sequences.fluxes.nkor[k]                    + self.sequences.states.inzp[k]                    - self.parameters.derived.kinz[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]],                    0.0,                )
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] + (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.nbes[k])
    cpdef inline void calc_snratio(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.fluxes.tkor[k] >= (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 0.0
            elif self.sequences.fluxes.tkor[k] <= (self.parameters.control.tgr[k] - self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 1.0
            else:
                self.sequences.aides.snratio[k] = (                    (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0) - self.sequences.fluxes.tkor[k]                ) / self.parameters.control.tsp[k]
    cpdef inline void calc_sbes(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.sbes[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbes[k]
    cpdef inline void calc_wats(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k])
    cpdef inline void calc_wada_waes(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.waes[k] = 0.0
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.nbes[k]
            else:
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
    cpdef inline void calc_wnied_esnow(self)  nogil:
        cdef double d_water
        cdef double d_ice
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wnied[k] = 0.0
                self.sequences.states.esnow[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k] - self.sequences.fluxes.wada[k])
                self.sequences.fluxes.wnied[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
                self.sequences.states.esnow[k] = self.sequences.states.esnow[k] + (self.sequences.fluxes.wnied[k])
    cpdef inline void calc_temps(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
    cpdef inline void update_taus(self)  nogil:
        cdef double d_r2
        cdef double d_r1
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                if isnan(self.sequences.states.taus[k]):
                    self.sequences.states.taus[k] = 0.0
                d_r1 = exp(                    5000.0 * (1 / 273.15 - 1.0 / (273.15 + self.sequences.aides.temps[k]))                )
                d_r2 = min(d_r1**10, 1.0)
                self.sequences.states.taus[k] = self.sequences.states.taus[k] * (max(1 - 0.1 * self.sequences.fluxes.sbes[k], 0.0))
                self.sequences.states.taus[k] = self.sequences.states.taus[k] + ((d_r1 + d_r2 + 0.03) / 1e6 * self.parameters.derived.seconds)
            else:
                self.sequences.states.taus[k] = nan
    cpdef inline void calc_actualalbedo(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo0snow * (                    1.0 - self.parameters.control.snowagingfactor * self.sequences.states.taus[k] / (1.0 + self.sequences.states.taus[k])                )
            else:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_netshortwaveradiationsnow(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiationsnow[k] = (                self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]                * (1.0 - self.sequences.fluxes.actualalbedo[k])                * self.sequences.inputs.globalradiation            )
    cpdef inline void calc_rlatm(self)  nogil:
        cdef double d_t
        cdef int k
        cdef double d_common
        cdef double d_rs
        d_rs = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        d_common = self.parameters.fixed.fratm * self.parameters.fixed.sigma * (1.0 + 0.22 * (1.0 - d_rs) ** 2)
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.aides.rlatm[k] = d_common * (                d_t**4 * (self.sequences.fluxes.actualvapourpressure[k] / d_t) ** (1.0 / 7.0)            )
    cpdef inline void calc_tz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.tz[k] = nan
            elif self.sequences.states.ebdn[k] < 0.0:
                self.sequences.fluxes.tz[k] = self.sequences.states.ebdn[k] / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
            elif self.sequences.states.ebdn[k] < self.parameters.derived.heatoffusion[k]:
                self.sequences.fluxes.tz[k] = 0.0
            else:
                self.sequences.fluxes.tz[k] = (self.sequences.states.ebdn[k] - self.parameters.derived.heatoffusion[k]) / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
    cpdef inline void calc_wg(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.wg[k] = 0.0
            else:
                self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
    cpdef inline void calc_schmpot(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.schmpot[k] = max(self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0.0)
            else:
                self.sequences.fluxes.schmpot[k] = 0.0
    cpdef inline void calc_schm_wats(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.schm[k] = 0.0
            else:
                self.sequences.fluxes.schm[k] = min(self.sequences.fluxes.schmpot[k], self.sequences.states.wats[k])
                self.sequences.states.wats[k] = self.sequences.states.wats[k] - (self.sequences.fluxes.schm[k])
    cpdef inline void calc_gefrpot(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                self.sequences.fluxes.gefrpot[k] = max(-self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0)
            else:
                self.sequences.fluxes.gefrpot[k] = 0.0
    cpdef inline void calc_gefr_wats(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE) or not self.parameters.control.refreezeflag:
                self.sequences.fluxes.gefr[k] = 0.0
            else:
                self.sequences.fluxes.gefr[k] = min(self.sequences.fluxes.gefrpot[k], (self.sequences.states.waes[k] - self.sequences.states.wats[k]))
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.gefr[k])
    cpdef inline void calc_evs_waes_wats(self)  nogil:
        cdef double d_frac
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS) or (self.sequences.states.waes[k] <= 0.0):
                self.sequences.fluxes.evs[k] = 0.0
                self.sequences.states.waes[k] = 0.0
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.fluxes.evs[k] = min(self.sequences.fluxes.wlatsnow[k] / self.parameters.fixed.lwe, self.sequences.states.waes[k])
                d_frac = (self.sequences.states.waes[k] - self.sequences.fluxes.evs[k]) / self.sequences.states.waes[k]
                self.sequences.states.waes[k] = self.sequences.states.waes[k] * (d_frac)
                self.sequences.states.wats[k] = self.sequences.states.wats[k] * (d_frac)
    cpdef inline void update_wada_waes(self)  nogil:
        cdef double d_wada_corr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE):
                d_wada_corr = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] + (d_wada_corr)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (d_wada_corr)
    cpdef inline void calc_netshortwaveradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.inputs.globalradiation
    cpdef inline void calc_dailynetshortwaveradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.fluxes.dailyglobalradiation
    cpdef inline void calc_dailynetlongwaveradiation(self)  nogil:
        cdef double d_temp
        cdef int k
        cdef double d_relsunshine
        d_relsunshine = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        for k in range(self.parameters.control.nhru):
            d_temp = self.sequences.fluxes.tkortag[k] + 273.15
            self.sequences.fluxes.dailynetlongwaveradiation[k] = (                (0.2 + 0.8 * d_relsunshine)                * (self.parameters.fixed.sigma * d_temp**4)                * (                    self.parameters.control.emissivity                    - self.parameters.fixed.fratm                    * (self.sequences.fluxes.dailyactualvapourpressure[k] / d_temp) ** (1.0 / 7.0)                )            )
    cpdef inline void calc_netradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.netshortwaveradiation[k], self.sequences.fluxes.dailynetlongwaveradiation[k]            )
    cpdef inline void calc_dailynetradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.dailynetshortwaveradiation[k],                self.sequences.fluxes.dailynetlongwaveradiation[k],            )
    cpdef inline void calc_dryairpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dryairpressure[k] = (                self.sequences.inputs.atmosphericpressure - self.sequences.fluxes.actualvapourpressure[k]            )
    cpdef inline void calc_densityair(self)  nogil:
        cdef double d_t
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.fluxes.densityair[k] = 100.0 * (                self.sequences.fluxes.dryairpressure[k] / (self.parameters.fixed.rdryair * d_t)                + self.sequences.fluxes.actualvapourpressure[k] / (self.parameters.fixed.rwatervapour * d_t)            )
    cpdef inline void calc_aerodynamicresistance(self)  nogil:
        cdef double d_z0
        cdef double d_ch
        cdef int k
        if self.sequences.fluxes.windspeed10m > 0.0:
            for k in range(self.parameters.control.nhru):
                d_ch = self.parameters.control.cropheight[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                if d_ch < 10.0:
                    d_z0 = 0.021 + 0.163 * d_ch
                    self.sequences.fluxes.aerodynamicresistance[k] = (                        6.25 / self.sequences.fluxes.windspeed10m * log(10.0 / d_z0) ** 2                    )
                else:
                    self.sequences.fluxes.aerodynamicresistance[k] = 94.0 / self.sequences.fluxes.windspeed10m
        else:
            for k in range(self.parameters.control.nhru):
                self.sequences.fluxes.aerodynamicresistance[k] = inf
    cpdef inline void calc_soilsurfaceresistance(self)  nogil:
        cdef double d_free
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.soilsurfaceresistance[k] = nan
            elif self.parameters.derived.nfk[k] > 20.0:
                self.sequences.fluxes.soilsurfaceresistance[k] = 100.0
            elif self.parameters.derived.nfk[k] > 0.0:
                d_free = min(max(self.sequences.states.bowa[k] - self.parameters.control.pwp[k], 0.0), self.parameters.derived.nfk[k])
                self.sequences.fluxes.soilsurfaceresistance[k] = (                    100.0 * self.parameters.derived.nfk[k] / (d_free + 0.01 * self.parameters.derived.nfk[k])                )
            else:
                self.sequences.fluxes.soilsurfaceresistance[k] = inf
    cpdef inline void calc_landusesurfaceresistance(self)  nogil:
        cdef double d_def
        cdef double d_res
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_res = self.parameters.control.surfaceresistance[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            if self.parameters.control.lnk[k] == NADELW:
                d_def = self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k]
                if (self.sequences.fluxes.tkor[k] <= -5.0) or (d_def >= 20.0):
                    self.sequences.fluxes.landusesurfaceresistance[k] = 10000.0
                elif self.sequences.fluxes.tkor[k] < 20.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        (25.0 * d_res) / (self.sequences.fluxes.tkor[k] + 5.0) / (1.0 - 0.05 * d_def),                        10000.0,                    )
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        d_res / (1.0 - 0.05 * d_def), 10000.0                    )
            else:
                self.sequences.fluxes.landusesurfaceresistance[k] = d_res
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE, VERS):
                if self.sequences.states.bowa[k] <= 0.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = inf
                elif self.sequences.states.bowa[k] < self.parameters.control.py[k]:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (3.5 * (                        1.0 - self.sequences.states.bowa[k] / self.parameters.control.py[k]                    ) + exp(0.2 * self.parameters.control.py[k] / self.sequences.states.bowa[k]))
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (exp(0.2))
    cpdef inline void calc_actualsurfaceresistance(self)  nogil:
        cdef double d_invrestnight
        cdef double d_invrestday
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.actualsurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k]
            else:
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                d_invrestday = (                    (1.0 - 0.7**d_lai) / self.sequences.fluxes.landusesurfaceresistance[k]                ) + 0.7**d_lai / self.sequences.fluxes.soilsurfaceresistance[k]
                d_invrestnight = d_lai / 2500.0 + 1.0 / self.sequences.fluxes.soilsurfaceresistance[k]
                self.sequences.fluxes.actualsurfaceresistance[k] = 1.0 / (                    (                        self.sequences.inputs.possiblesunshineduration / self.parameters.derived.hours * d_invrestday                        + (1.0 - self.sequences.inputs.possiblesunshineduration / self.parameters.derived.hours)                        * d_invrestnight                    )                )
    cpdef inline void calc_g(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.g[k] = 0.0
            else:
                self.sequences.fluxes.g[k] = self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_evpo(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS):
                self.sequences.fluxes.evpo[k] = self.return_penman_v1(k)
            else:
                self.sequences.fluxes.evpo[k] = self.return_penmanmonteith_v1(k, 0.0)
    cpdef inline void calc_evi_inzp(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.evi[k] = self.sequences.fluxes.evpo[k]
                self.sequences.states.inzp[k] = 0.0
            elif self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) or self.sequences.states.waes[k] == 0:
                self.sequences.fluxes.evi[k] = min(self.sequences.fluxes.evpo[k], self.sequences.states.inzp[k])
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
            else:
                self.sequences.fluxes.evi[k] = 0.0
    cpdef inline void calc_evb(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or ((self.parameters.control.lnk[k] not in (LAUBW, MISCHW, NADELW) and self.sequences.states.waes[k] > 0.0))                or (self.sequences.fluxes.evpo[k] == 0.0)            ):
                self.sequences.fluxes.evb[k] = 0.0
            else:
                self.sequences.fluxes.evb[k] = (                    (self.sequences.fluxes.evpo[k] - self.sequences.fluxes.evi[k])                    / self.sequences.fluxes.evpo[k]                    * self.return_penmanmonteith_v1(                        k,                        self.sequences.fluxes.actualsurfaceresistance[k],                    )                )
    cpdef inline void update_ebdn(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.ebdn[k] = 0.0
            else:
                self.sequences.states.ebdn[k] = self.sequences.states.ebdn[k] + (self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]] - self.sequences.fluxes.wg[k])
    cpdef inline void calc_sff(self)  nogil:
        cdef double d_sff
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.sff[k] = 0.0
            else:
                d_sff = 1.0 - self.sequences.states.ebdn[k] / (self.parameters.fixed.bowa2z[k] * self.parameters.fixed.rschmelz)
                self.sequences.fluxes.sff[k] = min(max(d_sff, 0.0), 1.0)
    cpdef inline void calc_fvg(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.fvg[k] = 0.0
            else:
                self.sequences.fluxes.fvg[k] = min(self.parameters.control.fvf * self.sequences.fluxes.sff[k] ** self.parameters.control.bsff, 1.0)
    cpdef inline void calc_qkap(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qkap[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 0]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k]
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 1]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k] * (                    1.0                    - (self.sequences.states.bowa[k] - self.parameters.control.kapgrenz[k, 0])                    / (self.parameters.control.kapgrenz[k, 1] - self.parameters.control.kapgrenz[k, 0])                )
            else:
                self.sequences.fluxes.qkap[k] = 0
    cpdef inline void calc_qbb(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.pwp[k])                or (self.parameters.control.wmax[k] <= 0.0)            ):
                self.sequences.fluxes.qbb[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.fk[k]:
                if self.parameters.control.rbeta:
                    self.sequences.fluxes.qbb[k] = 0.0
                else:
                    self.sequences.fluxes.qbb[k] = self.parameters.control.beta[k] * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])
            else:
                self.sequences.fluxes.qbb[k] = (                    self.parameters.control.beta[k]                    * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])                    * (                        1.0                        + (self.parameters.control.fbeta[k] - 1.0)                        * (self.sequences.states.bowa[k] - self.parameters.control.fk[k])                        / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                    )                )
    cpdef inline void calc_qib1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (                self.sequences.states.bowa[k] <= self.parameters.control.pwp[k]            ):
                self.sequences.fluxes.qib1[k] = 0.0
            else:
                self.sequences.fluxes.qib1[k] = self.parameters.control.dmin[k] * (self.sequences.states.bowa[k] / self.parameters.control.wmax[k])
    cpdef inline void calc_qib2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.fk[k])                or (self.parameters.control.wmax[k] <= self.parameters.control.fk[k])            ):
                self.sequences.fluxes.qib2[k] = 0.0
            else:
                self.sequences.fluxes.qib2[k] = (self.parameters.control.dmax[k] - self.parameters.control.dmin[k]) * (                    (self.sequences.states.bowa[k] - self.parameters.control.fk[k]) / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                ) ** 1.5
    cpdef inline void calc_qdb(self)  nogil:
        cdef double d_exz
        cdef double d_sfa
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qdb[k] = 0.0
            elif (self.parameters.control.lnk[k] in (VERS, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.wada[k]
            else:
                if self.sequences.states.bowa[k] < self.parameters.control.wmax[k]:
                    d_sfa = (1.0 - self.sequences.states.bowa[k] / self.parameters.control.wmax[k]) ** (                        1.0 / (self.parameters.control.bsf[k] + 1.0)                    ) - (self.sequences.fluxes.wada[k] / ((self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k]))
                else:
                    d_sfa = 0.0
                d_exz = self.sequences.states.bowa[k] + self.sequences.fluxes.wada[k] - self.parameters.control.wmax[k]
                self.sequences.fluxes.qdb[k] = d_exz
                if d_sfa > 0.0:
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (d_sfa ** (self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k])
                self.sequences.fluxes.qdb[k] = max(self.sequences.fluxes.qdb[k], 0.0)
    cpdef inline void update_qdb(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (self.sequences.fluxes.fvg[k] * (self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k]))
    cpdef inline void calc_bowa(self)  nogil:
        cdef double d_factor
        cdef double d_rvl
        cdef double d_incr
        cdef double d_decr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                d_decr = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k] + self.sequences.fluxes.qdb[k]
                d_incr = self.sequences.fluxes.wada[k] + self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    d_decr = d_decr + (self.sequences.fluxes.evb[k])
                else:
                    d_incr = d_incr - (self.sequences.fluxes.evb[k])
                if d_decr > self.sequences.states.bowa[k] + d_incr:
                    d_rvl = (self.sequences.states.bowa[k] + d_incr) / d_decr
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_rvl)
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (d_rvl)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (d_rvl)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (d_rvl)
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] * (d_rvl)
                    self.sequences.states.bowa[k] = 0.0
                else:
                    self.sequences.states.bowa[k] = (self.sequences.states.bowa[k] + d_incr) - d_decr
                    if self.sequences.states.bowa[k] > self.parameters.control.wmax[k]:
                        d_factor = (self.sequences.states.bowa[k] - self.parameters.control.wmax[k]) / d_incr
                        if self.sequences.fluxes.evb[k] < 0.0:
                            self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_factor)
                        self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] * (d_factor)
                        self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (d_factor)
                        self.sequences.states.bowa[k] = self.parameters.control.wmax[k]
    cpdef inline void calc_qbgz(self)  nogil:
        cdef int k
        self.sequences.states.qbgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == SEE:
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, FLUSS, VERS):
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.qbb[k] - self.sequences.fluxes.qkap[k]))
    cpdef inline void calc_qigz1(self)  nogil:
        cdef int k
        self.sequences.states.qigz1 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz1 = self.sequences.states.qigz1 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib1[k])
    cpdef inline void calc_qigz2(self)  nogil:
        cdef int k
        self.sequences.states.qigz2 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz2 = self.sequences.states.qigz2 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib2[k])
    cpdef inline void calc_qdgz(self)  nogil:
        cdef int k
        self.sequences.fluxes.qdgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == FLUSS:
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, SEE):
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * self.sequences.fluxes.qdb[k])
    cpdef inline void calc_qbga(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kb <= 0.0:
            self.sequences.new_states.qbga = self.sequences.new_states.qbgz
        elif self.parameters.derived.kb > 1e200:
            self.sequences.new_states.qbga = self.sequences.old_states.qbga + self.sequences.new_states.qbgz - self.sequences.old_states.qbgz
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kb)
            self.sequences.new_states.qbga = (                self.sequences.old_states.qbga                + (self.sequences.old_states.qbgz - self.sequences.old_states.qbga) * d_temp                + (self.sequences.new_states.qbgz - self.sequences.old_states.qbgz) * (1.0 - self.parameters.derived.kb * d_temp)            )
    cpdef inline void calc_qiga1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki1 <= 0.0:
            self.sequences.new_states.qiga1 = self.sequences.new_states.qigz1
        elif self.parameters.derived.ki1 > 1e200:
            self.sequences.new_states.qiga1 = self.sequences.old_states.qiga1 + self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki1)
            self.sequences.new_states.qiga1 = (                self.sequences.old_states.qiga1                + (self.sequences.old_states.qigz1 - self.sequences.old_states.qiga1) * d_temp                + (self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1) * (1.0 - self.parameters.derived.ki1 * d_temp)            )
    cpdef inline void calc_qiga2(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki2 <= 0.0:
            self.sequences.new_states.qiga2 = self.sequences.new_states.qigz2
        elif self.parameters.derived.ki2 > 1e200:
            self.sequences.new_states.qiga2 = self.sequences.old_states.qiga2 + self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki2)
            self.sequences.new_states.qiga2 = (                self.sequences.old_states.qiga2                + (self.sequences.old_states.qigz2 - self.sequences.old_states.qiga2) * d_temp                + (self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2) * (1.0 - self.parameters.derived.ki2 * d_temp)            )
    cpdef inline void calc_qdgz1_qdgz2(self)  nogil:
        if self.sequences.fluxes.qdgz > self.parameters.control.a2:
            self.sequences.states.qdgz2 = (self.sequences.fluxes.qdgz - self.parameters.control.a2) ** 2 / (self.sequences.fluxes.qdgz + self.parameters.control.a1 - self.parameters.control.a2)
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz - self.sequences.states.qdgz2
        else:
            self.sequences.states.qdgz2 = 0.0
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz
    cpdef inline void calc_qdga1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd1 <= 0.0:
            self.sequences.new_states.qdga1 = self.sequences.new_states.qdgz1
        elif self.parameters.derived.kd1 > 1e200:
            self.sequences.new_states.qdga1 = self.sequences.old_states.qdga1 + self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd1)
            self.sequences.new_states.qdga1 = (                self.sequences.old_states.qdga1                + (self.sequences.old_states.qdgz1 - self.sequences.old_states.qdga1) * d_temp                + (self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1) * (1.0 - self.parameters.derived.kd1 * d_temp)            )
    cpdef inline void calc_qdga2(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd2 <= 0.0:
            self.sequences.new_states.qdga2 = self.sequences.new_states.qdgz2
        elif self.parameters.derived.kd2 > 1e200:
            self.sequences.new_states.qdga2 = self.sequences.old_states.qdga2 + self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd2)
            self.sequences.new_states.qdga2 = (                self.sequences.old_states.qdga2                + (self.sequences.old_states.qdgz2 - self.sequences.old_states.qdga2) * d_temp                + (self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2) * (1.0 - self.parameters.derived.kd2 * d_temp)            )
    cpdef inline void calc_qah(self)  nogil:
        cdef double d_epw
        cdef int k
        cdef double d_area
        self.sequences.fluxes.qah = self.sequences.fluxes.qzh + self.sequences.states.qbga + self.sequences.states.qiga1 + self.sequences.states.qiga2 + self.sequences.states.qdga1 + self.sequences.states.qdga2
        if (not self.parameters.control.negq) and (self.sequences.fluxes.qah < 0.0):
            d_area = 0.0
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] in (FLUSS, SEE):
                    d_area = d_area + (self.parameters.control.fhru[k])
            if d_area > 0.0:
                for k in range(self.parameters.control.nhru):
                    if self.parameters.control.lnk[k] in (FLUSS, SEE):
                        self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] + (self.sequences.fluxes.qah / d_area)
            self.sequences.fluxes.qah = 0.0
        d_epw = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qah = self.sequences.fluxes.qah + (self.parameters.control.fhru[k] * self.sequences.fluxes.nkor[k])
                d_epw = d_epw + (self.parameters.control.fhru[k] * self.sequences.fluxes.evi[k])
        if (self.sequences.fluxes.qah > d_epw) or self.parameters.control.negq:
            self.sequences.fluxes.qah = self.sequences.fluxes.qah - (d_epw)
        elif d_epw > 0.0:
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] == WASSER:
                    self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] * (self.sequences.fluxes.qah / d_epw)
            self.sequences.fluxes.qah = 0.0
    cpdef inline void calc_qa(self)  nogil:
        self.sequences.fluxes.qa = self.parameters.derived.qfactor * self.sequences.fluxes.qah
    cpdef inline double return_adjustedwindspeed_v1(self, double newheight)  nogil:
        return self.sequences.inputs.windspeed * (            log(newheight / self.parameters.fixed.z0)            / log(self.parameters.control.measuringheightwindspeed / self.parameters.fixed.z0)        )
    cpdef inline double return_actualvapourpressure_v1(self, double saturationvapourpressure, double relativehumidity)  nogil:
        return saturationvapourpressure * relativehumidity / 100.0
    cpdef inline double return_netlongwaveradiationsnow_v1(self, numpy.int32_t k)  nogil:
        cdef double d_fr
        cdef double d_counter
        cdef double d_temp
        d_temp = self.sequences.fluxes.tkor[k] + 273.15
        d_counter = self.sequences.aides.rlatm[k]
        if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
            d_fr = self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            d_counter = d_fr * d_counter + (1.0 - d_fr) * 0.97 * self.parameters.fixed.sigma * d_temp**4
        return self.parameters.fixed.sigma * (self.sequences.fluxes.tempssurface[k] + 273.15) ** 4 - d_counter
    cpdef inline double return_penman_v1(self, numpy.int32_t k)  nogil:
        return (            self.sequences.fluxes.dailysaturationvapourpressureslope[k]            * self.sequences.fluxes.dailynetradiation[k]            / self.parameters.fixed.lw            + self.parameters.fixed.psy            * self.parameters.derived.days            * (0.13 + 0.094 * self.sequences.fluxes.dailywindspeed2m)            * (self.sequences.fluxes.dailysaturationvapourpressure[k] - self.sequences.fluxes.dailyactualvapourpressure[k])        ) / (self.sequences.fluxes.dailysaturationvapourpressureslope[k] + self.parameters.fixed.psy)
    cpdef inline double return_penmanmonteith_v1(self, numpy.int32_t k, double actualsurfaceresistance)  nogil:
        cdef double d_c
        cdef double d_b
        cdef double d_t
        cdef double d_ar
        d_ar = min(max(self.sequences.fluxes.aerodynamicresistance[k], 1e-6), 1e6)
        d_t = 273.15 + self.sequences.fluxes.tkor[k]
        d_b = (4.0 * self.parameters.control.emissivity * self.parameters.fixed.sigma / self.parameters.derived.seconds) * d_t**3
        d_c = 1.0 + d_b * d_ar / self.sequences.fluxes.densityair[k] / self.parameters.fixed.cpluft
        return (            (                self.sequences.fluxes.saturationvapourpressureslope[k] * (self.sequences.fluxes.netradiation[k] + self.sequences.fluxes.g[k])                + self.parameters.derived.seconds                * d_c                * self.sequences.fluxes.densityair[k]                * self.parameters.fixed.cpluft                * (self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k])                / d_ar            )            / (                self.sequences.fluxes.saturationvapourpressureslope[k]                + self.parameters.fixed.psy * d_c * (1.0 + actualsurfaceresistance / d_ar)            )            / self.parameters.fixed.lw        )
    cpdef inline double return_energygainsnowsurface_v1(self, double tempssurface)  nogil:
        cdef int k
        k = self.idx_hru
        self.sequences.fluxes.tempssurface[k] = tempssurface
        self.sequences.fluxes.saturationvapourpressuresnow[k] = self.return_saturationvapourpressure_v1(            self.sequences.fluxes.tempssurface[k]        )
        self.sequences.fluxes.wlatsnow[k] = self.return_wlatsnow_v1(k)
        self.sequences.fluxes.wsenssnow[k] = self.return_wsenssnow_v1(k)
        self.sequences.fluxes.netlongwaveradiationsnow[k] = self.return_netlongwaveradiationsnow_v1(k)
        self.sequences.fluxes.netradiationsnow[k] = self.return_netradiation_v1(            self.sequences.fluxes.netshortwaveradiationsnow[k],            self.sequences.fluxes.netlongwaveradiationsnow[k],        )
        self.sequences.fluxes.wsurf[k] = self.return_wsurf_v1(k)
        return (            self.sequences.fluxes.wsurf[k] + self.sequences.fluxes.netradiationsnow[k] - self.sequences.fluxes.wsenssnow[k] - self.sequences.fluxes.wlatsnow[k]        )
    cpdef inline double return_saturationvapourpressure_v1(self, double temperature)  nogil:
        return 6.1078 * 2.71828 ** (17.08085 * temperature / (temperature + 234.175))
    cpdef inline double return_saturationvapourpressureslope_v1(self, double temperature)  nogil:
        return (            24430.6            * exp(17.08085 * temperature / (temperature + 234.175))            / (temperature + 234.175) ** 2        )
    cpdef inline double return_netradiation_v1(self, double netshortwaveradiation, double netlongwaveradiation)  nogil:
        return netshortwaveradiation - netlongwaveradiation
    cpdef inline double return_wsenssnow_v1(self, numpy.int32_t k)  nogil:
        return (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k]) * (            self.sequences.fluxes.tempssurface[k] - self.sequences.fluxes.tkor[k]        )
    cpdef inline double return_wlatsnow_v1(self, numpy.int32_t k)  nogil:
        return (            (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k])            * self.parameters.fixed.psyinv            * (self.sequences.fluxes.saturationvapourpressuresnow[k] - self.sequences.fluxes.actualvapourpressure[k])        )
    cpdef inline double return_wsurf_v1(self, numpy.int32_t k)  nogil:
        if isinf(self.parameters.control.ktschnee):
            return inf
        return self.parameters.control.ktschnee * (self.sequences.aides.temps[k] - self.sequences.fluxes.tempssurface[k])
    cpdef inline double return_temps_v1(self, numpy.int32_t k)  nogil:
        cdef double d_water
        cdef double d_ice
        if self.sequences.states.waes[k] > 0.0:
            d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
            d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
            return max(self.sequences.states.esnow[k] / (d_ice + d_water), -273.0)
        return nan
    cpdef inline double return_wg_v1(self, numpy.int32_t k)  nogil:
        cdef double d_temp
        if self.sequences.states.waes[k] > 0.0:
            d_temp = self.sequences.aides.temps[k]
        else:
            d_temp = self.sequences.fluxes.tkor[k]
        return self.parameters.fixed.lambdag * (self.sequences.fluxes.tz[k] - d_temp) / self.parameters.fixed.z
    cpdef inline double return_backwardeulererror_v1(self, double esnow)  nogil:
        cdef double d_esnow_old
        cdef int k
        k = self.idx_hru
        if self.sequences.states.waes[k] > 0.0:
            d_esnow_old = self.sequences.states.esnow[k]
            self.sequences.states.esnow[k] = esnow
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
            self.sequences.states.esnow[k] = d_esnow_old
            self.return_tempssurface_v1(k)
            self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
            return d_esnow_old - esnow + self.sequences.fluxes.wg[k] - self.sequences.fluxes.wsurf[k]
        return nan
    cpdef inline double return_esnow_v1(self, numpy.int32_t k, double temps)  nogil:
        cdef double d_water
        cdef double d_ice
        d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
        d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
        return temps * (d_ice + d_water)
    cpdef inline double return_tempssurface_v1(self, numpy.int32_t k)  nogil:
        if self.sequences.states.waes[k] > 0.0:
            if isinf(self.parameters.control.ktschnee):
                self.idx_hru = k
                self.return_energygainsnowsurface_v1(self.sequences.aides.temps[k])
                self.sequences.fluxes.wsurf[k] = (                    self.sequences.fluxes.wsenssnow[k] + self.sequences.fluxes.wlatsnow[k] - self.sequences.fluxes.netradiationsnow[k]                )
            else:
                self.idx_hru = k
                self.pegasustempssurface.find_x(-50.0, 0.0, -100.0, 0.0, 0.0, 1e-8, 10)
                self.sequences.fluxes.wsurf[k] = self.sequences.fluxes.wsurf[k] - (self.return_energygainsnowsurface_v1(                    self.sequences.fluxes.tempssurface[k]                ))
        else:
            self.sequences.fluxes.tempssurface[k] = nan
            self.sequences.fluxes.saturationvapourpressuresnow[k] = 0.0
            self.sequences.fluxes.wsenssnow[k] = 0.0
            self.sequences.fluxes.wlatsnow[k] = 0.0
            self.sequences.fluxes.wsurf[k] = 0.0
        return self.sequences.fluxes.tempssurface[k]
    cpdef inline double return_adjustedwindspeed(self, double newheight)  nogil:
        return self.sequences.inputs.windspeed * (            log(newheight / self.parameters.fixed.z0)            / log(self.parameters.control.measuringheightwindspeed / self.parameters.fixed.z0)        )
    cpdef inline double return_actualvapourpressure(self, double saturationvapourpressure, double relativehumidity)  nogil:
        return saturationvapourpressure * relativehumidity / 100.0
    cpdef inline double return_netlongwaveradiationsnow(self, numpy.int32_t k)  nogil:
        cdef double d_fr
        cdef double d_counter
        cdef double d_temp
        d_temp = self.sequences.fluxes.tkor[k] + 273.15
        d_counter = self.sequences.aides.rlatm[k]
        if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
            d_fr = self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            d_counter = d_fr * d_counter + (1.0 - d_fr) * 0.97 * self.parameters.fixed.sigma * d_temp**4
        return self.parameters.fixed.sigma * (self.sequences.fluxes.tempssurface[k] + 273.15) ** 4 - d_counter
    cpdef inline double return_penman(self, numpy.int32_t k)  nogil:
        return (            self.sequences.fluxes.dailysaturationvapourpressureslope[k]            * self.sequences.fluxes.dailynetradiation[k]            / self.parameters.fixed.lw            + self.parameters.fixed.psy            * self.parameters.derived.days            * (0.13 + 0.094 * self.sequences.fluxes.dailywindspeed2m)            * (self.sequences.fluxes.dailysaturationvapourpressure[k] - self.sequences.fluxes.dailyactualvapourpressure[k])        ) / (self.sequences.fluxes.dailysaturationvapourpressureslope[k] + self.parameters.fixed.psy)
    cpdef inline double return_penmanmonteith(self, numpy.int32_t k, double actualsurfaceresistance)  nogil:
        cdef double d_c
        cdef double d_b
        cdef double d_t
        cdef double d_ar
        d_ar = min(max(self.sequences.fluxes.aerodynamicresistance[k], 1e-6), 1e6)
        d_t = 273.15 + self.sequences.fluxes.tkor[k]
        d_b = (4.0 * self.parameters.control.emissivity * self.parameters.fixed.sigma / self.parameters.derived.seconds) * d_t**3
        d_c = 1.0 + d_b * d_ar / self.sequences.fluxes.densityair[k] / self.parameters.fixed.cpluft
        return (            (                self.sequences.fluxes.saturationvapourpressureslope[k] * (self.sequences.fluxes.netradiation[k] + self.sequences.fluxes.g[k])                + self.parameters.derived.seconds                * d_c                * self.sequences.fluxes.densityair[k]                * self.parameters.fixed.cpluft                * (self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k])                / d_ar            )            / (                self.sequences.fluxes.saturationvapourpressureslope[k]                + self.parameters.fixed.psy * d_c * (1.0 + actualsurfaceresistance / d_ar)            )            / self.parameters.fixed.lw        )
    cpdef inline double return_energygainsnowsurface(self, double tempssurface)  nogil:
        cdef int k
        k = self.idx_hru
        self.sequences.fluxes.tempssurface[k] = tempssurface
        self.sequences.fluxes.saturationvapourpressuresnow[k] = self.return_saturationvapourpressure_v1(            self.sequences.fluxes.tempssurface[k]        )
        self.sequences.fluxes.wlatsnow[k] = self.return_wlatsnow_v1(k)
        self.sequences.fluxes.wsenssnow[k] = self.return_wsenssnow_v1(k)
        self.sequences.fluxes.netlongwaveradiationsnow[k] = self.return_netlongwaveradiationsnow_v1(k)
        self.sequences.fluxes.netradiationsnow[k] = self.return_netradiation_v1(            self.sequences.fluxes.netshortwaveradiationsnow[k],            self.sequences.fluxes.netlongwaveradiationsnow[k],        )
        self.sequences.fluxes.wsurf[k] = self.return_wsurf_v1(k)
        return (            self.sequences.fluxes.wsurf[k] + self.sequences.fluxes.netradiationsnow[k] - self.sequences.fluxes.wsenssnow[k] - self.sequences.fluxes.wlatsnow[k]        )
    cpdef inline double return_saturationvapourpressure(self, double temperature)  nogil:
        return 6.1078 * 2.71828 ** (17.08085 * temperature / (temperature + 234.175))
    cpdef inline double return_saturationvapourpressureslope(self, double temperature)  nogil:
        return (            24430.6            * exp(17.08085 * temperature / (temperature + 234.175))            / (temperature + 234.175) ** 2        )
    cpdef inline double return_netradiation(self, double netshortwaveradiation, double netlongwaveradiation)  nogil:
        return netshortwaveradiation - netlongwaveradiation
    cpdef inline double return_wsenssnow(self, numpy.int32_t k)  nogil:
        return (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k]) * (            self.sequences.fluxes.tempssurface[k] - self.sequences.fluxes.tkor[k]        )
    cpdef inline double return_wlatsnow(self, numpy.int32_t k)  nogil:
        return (            (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k])            * self.parameters.fixed.psyinv            * (self.sequences.fluxes.saturationvapourpressuresnow[k] - self.sequences.fluxes.actualvapourpressure[k])        )
    cpdef inline double return_wsurf(self, numpy.int32_t k)  nogil:
        if isinf(self.parameters.control.ktschnee):
            return inf
        return self.parameters.control.ktschnee * (self.sequences.aides.temps[k] - self.sequences.fluxes.tempssurface[k])
    cpdef inline double return_temps(self, numpy.int32_t k)  nogil:
        cdef double d_water
        cdef double d_ice
        if self.sequences.states.waes[k] > 0.0:
            d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
            d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
            return max(self.sequences.states.esnow[k] / (d_ice + d_water), -273.0)
        return nan
    cpdef inline double return_wg(self, numpy.int32_t k)  nogil:
        cdef double d_temp
        if self.sequences.states.waes[k] > 0.0:
            d_temp = self.sequences.aides.temps[k]
        else:
            d_temp = self.sequences.fluxes.tkor[k]
        return self.parameters.fixed.lambdag * (self.sequences.fluxes.tz[k] - d_temp) / self.parameters.fixed.z
    cpdef inline double return_backwardeulererror(self, double esnow)  nogil:
        cdef double d_esnow_old
        cdef int k
        k = self.idx_hru
        if self.sequences.states.waes[k] > 0.0:
            d_esnow_old = self.sequences.states.esnow[k]
            self.sequences.states.esnow[k] = esnow
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
            self.sequences.states.esnow[k] = d_esnow_old
            self.return_tempssurface_v1(k)
            self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
            return d_esnow_old - esnow + self.sequences.fluxes.wg[k] - self.sequences.fluxes.wsurf[k]
        return nan
    cpdef inline double return_esnow(self, numpy.int32_t k, double temps)  nogil:
        cdef double d_water
        cdef double d_ice
        d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
        d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
        return temps * (d_ice + d_water)
    cpdef inline double return_tempssurface(self, numpy.int32_t k)  nogil:
        if self.sequences.states.waes[k] > 0.0:
            if isinf(self.parameters.control.ktschnee):
                self.idx_hru = k
                self.return_energygainsnowsurface_v1(self.sequences.aides.temps[k])
                self.sequences.fluxes.wsurf[k] = (                    self.sequences.fluxes.wsenssnow[k] + self.sequences.fluxes.wlatsnow[k] - self.sequences.fluxes.netradiationsnow[k]                )
            else:
                self.idx_hru = k
                self.pegasustempssurface.find_x(-50.0, 0.0, -100.0, 0.0, 0.0, 1e-8, 10)
                self.sequences.fluxes.wsurf[k] = self.sequences.fluxes.wsurf[k] - (self.return_energygainsnowsurface_v1(                    self.sequences.fluxes.tempssurface[k]                ))
        else:
            self.sequences.fluxes.tempssurface[k] = nan
            self.sequences.fluxes.saturationvapourpressuresnow[k] = 0.0
            self.sequences.fluxes.wsenssnow[k] = 0.0
            self.sequences.fluxes.wlatsnow[k] = 0.0
            self.sequences.fluxes.wsurf[k] = 0.0
        return self.sequences.fluxes.tempssurface[k]
    cpdef inline void pass_qa_v1(self)  nogil:
        self.sequences.outlets.q[0] = self.sequences.outlets.q[0] + (self.sequences.fluxes.qa)
    cpdef inline void pass_qa(self)  nogil:
        self.sequences.outlets.q[0] = self.sequences.outlets.q[0] + (self.sequences.fluxes.qa)
