# coding: utf-8

"""
    Dofusdude

    # A project for you - the developer. The free, always-up-to-date, low-latency, insert-buzzword-here Ankama API for your next cool project!  ## Client SDKs Don't write types or functions yourself - I already (kinda) did! 😉 - [Javascript](https://github.com/dofusdude/dofusdude-js) npm i dofusdude-js --save - [Typescript](https://github.com/dofusdude/dofusdude-ts) npm i dofusdude-ts --save - [Go](https://github.com/dofusdude/dodugo) go get -u github.com/dofusdude/dodugo - [Python](https://github.com/dofusdude/dofusdude-py) pip install dofusdude - [PHP](https://github.com/dofusdude/dofusdude-php)  Everything, including this site, is generated out of the [Docs Repo](https://github.com/dofusdude/api-docs). Consider it the Single Source of Truth. If there is a problem with the SDKs, create an issue there.  Your favorite language is missing? Please let me know!  # Main Features - 🥷 **Seamless Auto-Update** load data in the background when a new Dofus version is released and serving it within 2 minutes with atomic data source switching. No downtime and no effects for the user, just always up-to-date.  - ⚡ **Blazingly Fast** all data in-memory, aggressive caching over short time spans, HTTP/2 multiplexing, written in Go, optimized for low latency, hosted on bare metal in 🇩🇪.  - 📨 **Discord Integration** Ankama related Twitter, RSS and Almanax feeds to post to Discord servers with advanced features like filters or mentions. Use the endpoints as a dev or the official [Web Client](https://discord.dofusdude.com) as a user.  - 🩸 **Dofus 2 Beta** from stable to bleeding edge by replacing /dofus2 with /dofus2beta.  - 🗣️ **Multilingual** supporting _en_, _fr_, _es_, _pt_ including the dropped languages from the Dofus website _de_ and _it_.  - 🧠 **Search by Relevance** allowing typos in name and description, handled by language specific text analysis and indexing by the powerful [Meilisearch](https://www.meilisearch.com) written in Rust.  - 🕵️ **Complete** actual data from the game including items invisible to the encyclopedia like quest items.  - 🖼️ **HD Images** rendering vector graphics into PNGs up to 800x800 px in the background.   ## Current state - Weapons ✅ - Equipment ✅ - Sets ✅ - Resources ✅ - Consumables ✅ - Pets ✅ - Mounts ✅ - Cosmetics/Ceremonial Items ✅ - Harnesses ✅ - Quest Items ✅ - Almanax ✅ - Monsters ❌ - Spells ❌  ... and much more on the Roadmap on my Discord.   ## Deploy now. Use forever. Everything you see here on this site, you can use now and forever. Updates could introduce new fields, new paths or parameter but never break backwards compatibility, so no field or parameter will be deleted.  There is one exception! **The API will _always_ choose being up-to-date over everything else**. So if Ankama decides to drop languages from the game like they did with their website, the API will loose support for them, too.  ## Only the beginning... 🤯 I want this project to be useful and not just add plain GET-categories no one needs.  There is a long list of features I want to add (see the Roadmap on my [Discord](https://discord.gg/3EtHskZD8h)). But they are all focussed on you, the developers. So please let me know what you need. I will change the list based on demand.  # Get started! 🥳 Scroll down and try it for yourself!  Or see how these other awesome projects use it: - [KaellyBot](https://github.com/Kaysoro/KaellyBot) by Kaysoro - [Dofus Craftlist](https://dofuscraftlist-dev.netlify.app) by Lystina - [AlmanaxApp](https://almanaxapp.netlify.app) by Lystina - [DofuStuffSimulator](https://dofusstuffsimulator.netlify.app/)  I highly recommend using the SDKs for quick results. I use them myself for parts of the API.  ## Thank you! I highly welcome everyone on my [Discord](https://discord.gg/3EtHskZD8h) to just talk about projects and use cases or give feedback of any kind.  The servers have a fixed monthly cost to provide very fast responses. If you want to help me keeping them running or simply  donate, consider becoming a [GitHub Sponsor](https://github.com/sponsors/dofusdude). 

    The version of the OpenAPI document: 0.8.0
    Contact: stelzo@steado.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, conint, conlist, constr, validator

from typing import List, Optional

from dofusdude.models.mount import Mount
from dofusdude.models.mount_list_entry import MountListEntry
from dofusdude.models.mounts_list_paged import MountsListPaged

from dofusdude.api_client import ApiClient
from dofusdude.api_response import ApiResponse
from dofusdude.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_all_mounts_list(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], game : StrictStr, filter_family_name : Annotated[Optional[StrictStr], Field(description="only results with the translated family name")] = None, accept_encoding : Annotated[Optional[StrictStr], Field(description="optional compression for saving bandwidth")] = None, **kwargs) -> MountsListPaged:  # noqa: E501
        """List All Mounts  # noqa: E501

        Retrieve all mounts with one request. This endpoint is just an alias for the a list with disabled pagination (page[size]=-1) and all fields[type] set.  If you want everything unfiltered, delete the other query parameters.  Be careful with testing or (god forbid) using /all in your browser, the returned json is huge and will slow down the browser!  Tip: set the HTTP Header 'Accept-Encoding: gzip' for saving bandwidth. You will need to uncompress it on your end. Example with cURL: ``` curl -sH 'Accept-Encoding: gzip' <api-endpoint> | gunzip - ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_mounts_list(language, game, filter_family_name, accept_encoding, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param game: (required)
        :type game: str
        :param filter_family_name: only results with the translated family name
        :type filter_family_name: str
        :param accept_encoding: optional compression for saving bandwidth
        :type accept_encoding: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MountsListPaged
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_all_mounts_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_all_mounts_list_with_http_info(language, game, filter_family_name, accept_encoding, **kwargs)  # noqa: E501

    @validate_arguments
    def get_all_mounts_list_with_http_info(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], game : StrictStr, filter_family_name : Annotated[Optional[StrictStr], Field(description="only results with the translated family name")] = None, accept_encoding : Annotated[Optional[StrictStr], Field(description="optional compression for saving bandwidth")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List All Mounts  # noqa: E501

        Retrieve all mounts with one request. This endpoint is just an alias for the a list with disabled pagination (page[size]=-1) and all fields[type] set.  If you want everything unfiltered, delete the other query parameters.  Be careful with testing or (god forbid) using /all in your browser, the returned json is huge and will slow down the browser!  Tip: set the HTTP Header 'Accept-Encoding: gzip' for saving bandwidth. You will need to uncompress it on your end. Example with cURL: ``` curl -sH 'Accept-Encoding: gzip' <api-endpoint> | gunzip - ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_mounts_list_with_http_info(language, game, filter_family_name, accept_encoding, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param game: (required)
        :type game: str
        :param filter_family_name: only results with the translated family name
        :type filter_family_name: str
        :param accept_encoding: optional compression for saving bandwidth
        :type accept_encoding: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MountsListPaged, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'language',
            'game',
            'filter_family_name',
            'accept_encoding'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_mounts_list" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['language']:
            _path_params['language'] = _params['language']

        if _params['game']:
            _path_params['game'] = _params['game']


        # process the query parameters
        _query_params = []
        if _params.get('filter_family_name') is not None:  # noqa: E501
            _query_params.append(('filter[family_name]', _params['filter_family_name']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['accept_encoding']:
            _header_params['Accept-Encoding'] = _params['accept_encoding']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "MountsListPaged",
            '400': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/{game}/{language}/mounts/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_mounts_list(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], game : StrictStr, filter_family_name : Annotated[Optional[StrictStr], Field(description="only results with the translated family name")] = None, page_size : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="size of the results from the list. -1 disables pagination and gets all in one response.")] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.")] = None, fields_mount : Annotated[Optional[conlist(StrictStr, unique_items=True)], Field(description="adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.")] = None, **kwargs) -> MountsListPaged:  # noqa: E501
        """List Mounts  # noqa: E501

        Retrieve a list of mounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mounts_list(language, game, filter_family_name, page_size, page_number, fields_mount, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param game: (required)
        :type game: str
        :param filter_family_name: only results with the translated family name
        :type filter_family_name: str
        :param page_size: size of the results from the list. -1 disables pagination and gets all in one response.
        :type page_size: int
        :param page_number: page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.
        :type page_number: int
        :param fields_mount: adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.
        :type fields_mount: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MountsListPaged
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_mounts_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_mounts_list_with_http_info(language, game, filter_family_name, page_size, page_number, fields_mount, **kwargs)  # noqa: E501

    @validate_arguments
    def get_mounts_list_with_http_info(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], game : StrictStr, filter_family_name : Annotated[Optional[StrictStr], Field(description="only results with the translated family name")] = None, page_size : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="size of the results from the list. -1 disables pagination and gets all in one response.")] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.")] = None, fields_mount : Annotated[Optional[conlist(StrictStr, unique_items=True)], Field(description="adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List Mounts  # noqa: E501

        Retrieve a list of mounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mounts_list_with_http_info(language, game, filter_family_name, page_size, page_number, fields_mount, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param game: (required)
        :type game: str
        :param filter_family_name: only results with the translated family name
        :type filter_family_name: str
        :param page_size: size of the results from the list. -1 disables pagination and gets all in one response.
        :type page_size: int
        :param page_number: page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.
        :type page_number: int
        :param fields_mount: adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.
        :type fields_mount: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MountsListPaged, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'language',
            'game',
            'filter_family_name',
            'page_size',
            'page_number',
            'fields_mount'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mounts_list" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['language']:
            _path_params['language'] = _params['language']

        if _params['game']:
            _path_params['game'] = _params['game']


        # process the query parameters
        _query_params = []
        if _params.get('filter_family_name') is not None:  # noqa: E501
            _query_params.append(('filter[family_name]', _params['filter_family_name']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('page[size]', _params['page_size']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('page[number]', _params['page_number']))

        if _params.get('fields_mount') is not None:  # noqa: E501
            _query_params.append(('fields[mount]', _params['fields_mount']))
            _collection_formats['fields[mount]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "MountsListPaged",
            '400': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/{game}/{language}/mounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_mounts_search(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], game : StrictStr, query : Annotated[StrictStr, Field(..., description="case sensitive search query")], filter_family_name : Annotated[Optional[StrictStr], Field(description="only results with the translated family name")] = None, limit : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="maximum number of returned results")] = None, **kwargs) -> List[MountListEntry]:  # noqa: E501
        """Search Mounts  # noqa: E501

        Search in all names and descriptions of mounts with a query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mounts_search(language, game, query, filter_family_name, limit, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param game: (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_family_name: only results with the translated family name
        :type filter_family_name: str
        :param limit: maximum number of returned results
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[MountListEntry]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_mounts_search_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_mounts_search_with_http_info(language, game, query, filter_family_name, limit, **kwargs)  # noqa: E501

    @validate_arguments
    def get_mounts_search_with_http_info(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], game : StrictStr, query : Annotated[StrictStr, Field(..., description="case sensitive search query")], filter_family_name : Annotated[Optional[StrictStr], Field(description="only results with the translated family name")] = None, limit : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="maximum number of returned results")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Search Mounts  # noqa: E501

        Search in all names and descriptions of mounts with a query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mounts_search_with_http_info(language, game, query, filter_family_name, limit, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param game: (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_family_name: only results with the translated family name
        :type filter_family_name: str
        :param limit: maximum number of returned results
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[MountListEntry], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'language',
            'game',
            'query',
            'filter_family_name',
            'limit'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mounts_search" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['language']:
            _path_params['language'] = _params['language']

        if _params['game']:
            _path_params['game'] = _params['game']


        # process the query parameters
        _query_params = []
        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        if _params.get('filter_family_name') is not None:  # noqa: E501
            _query_params.append(('filter[family_name]', _params['filter_family_name']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "List[MountListEntry]",
            '400': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/{game}/{language}/mounts/search', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_mounts_single(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], ankama_id : Annotated[StrictInt, Field(..., description="identifier")], game : StrictStr, **kwargs) -> Mount:  # noqa: E501
        """Single Mounts  # noqa: E501

        Retrieve a specific mount with id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mounts_single(language, ankama_id, game, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param ankama_id: identifier (required)
        :type ankama_id: int
        :param game: (required)
        :type game: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Mount
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_mounts_single_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_mounts_single_with_http_info(language, ankama_id, game, **kwargs)  # noqa: E501

    @validate_arguments
    def get_mounts_single_with_http_info(self, language : Annotated[constr(strict=True, max_length=2, min_length=2), Field(..., description="a valid language code")], ankama_id : Annotated[StrictInt, Field(..., description="identifier")], game : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Single Mounts  # noqa: E501

        Retrieve a specific mount with id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mounts_single_with_http_info(language, ankama_id, game, async_req=True)
        >>> result = thread.get()

        :param language: a valid language code (required)
        :type language: str
        :param ankama_id: identifier (required)
        :type ankama_id: int
        :param game: (required)
        :type game: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Mount, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'language',
            'ankama_id',
            'game'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mounts_single" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['language']:
            _path_params['language'] = _params['language']

        if _params['ankama_id']:
            _path_params['ankama_id'] = _params['ankama_id']

        if _params['game']:
            _path_params['game'] = _params['game']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "Mount",
            '400': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/{game}/{language}/mounts/{ankama_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
